/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.view.EditorView;
import gnu.trove.TIntFloatHashMap;
import org.intellij.lang.annotations.JdkConstants;

class CharWidthCache {
    private static final int CACHE_SIZE_LIMIT = 1024;
    private static final float SHIFT = 1.0f;
    private final EditorView myView;
    private final TIntFloatHashMap myCache = new TIntFloatHashMap();

    CharWidthCache(EditorView view) {
        this.myView = view;
    }

    void clear() {
        this.myCache.clear();
    }

    float getCodePointWidth(int codePoint, @JdkConstants.FontStyle int fontStyle) {
        int key = CharWidthCache.createKey(codePoint, fontStyle);
        float width = this.getCachedValue(key);
        if (width < 0.0f) {
            width = ComplementaryFontsRegistry.getFontAbleToDisplay(codePoint, fontStyle, this.myView.getEditor().getColorsScheme().getFontPreferences(), this.myView.getFontRenderContext()).charWidth2D(codePoint);
            this.saveInCache(key, width);
        }
        return width;
    }

    private float getCachedValue(int key) {
        return this.myCache.get(key) - 1.0f;
    }

    private void saveInCache(int key, float value) {
        if (this.myCache.size() >= 1024) {
            this.myCache.clear();
        }
        this.myCache.put(key, value + 1.0f);
    }

    private static int createKey(int codePoint, @JdkConstants.FontStyle int fontStyle) {
        return fontStyle << 21 | codePoint;
    }
}

