/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.Getter;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RangeMarkerTree<T extends RangeMarkerEx>
extends IntervalTreeImpl<T>
implements PrioritizedInternalDocumentListener {
    private static final int DUPLICATE_LIMIT = 30;

    RangeMarkerTree(@NotNull Document document) {
        if (document == null) {
            RangeMarkerTree.$$$reportNull$$$0(0);
        }
        document.addDocumentListener((DocumentListener)this);
    }

    RangeMarkerTree() {
    }

    @Override
    public void moveTextHappened(@NotNull Document document, int start2, int end, int newBase) {
        if (document == null) {
            RangeMarkerTree.$$$reportNull$$$0(1);
        }
        this.reTarget(start2, end, newBase);
    }

    @Override
    public int getPriority() {
        return 40;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            RangeMarkerTree.$$$reportNull$$$0(2);
        }
        this.updateMarkersOnChange(event);
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<T> i1, @NotNull IntervalTreeImpl.IntervalNode<T> i2) {
        boolean stickyR2;
        boolean greedyR2;
        int o2Length;
        boolean greedyL2;
        if (i1 == null) {
            RangeMarkerTree.$$$reportNull$$$0(3);
        }
        if (i2 == null) {
            RangeMarkerTree.$$$reportNull$$$0(4);
        }
        RMNode o1 = (RMNode)i1;
        RMNode o2 = (RMNode)i2;
        boolean greedyL1 = o1.isGreedyToLeft();
        if (greedyL1 != (greedyL2 = o2.isGreedyToLeft())) {
            return greedyL1 ? -1 : 1;
        }
        int o1Length = o1.intervalEnd() - o1.intervalStart();
        int d = o1Length - (o2Length = o2.intervalEnd() - o2.intervalStart());
        if (d != 0) {
            return d;
        }
        boolean greedyR1 = o1.isGreedyToRight();
        if (greedyR1 != (greedyR2 = o2.isGreedyToRight())) {
            return greedyR1 ? -1 : 1;
        }
        boolean stickyR1 = o1.isStickingToRight();
        if (stickyR1 != (stickyR2 = o2.isStickingToRight())) {
            return stickyR1 ? -1 : 1;
        }
        return 0;
    }

    void dispose(@NotNull Document document) {
        if (document == null) {
            RangeMarkerTree.$$$reportNull$$$0(5);
        }
        document.removeDocumentListener((DocumentListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RMNode<T> addInterval(@NotNull T interval, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (interval == null) {
            RangeMarkerTree.$$$reportNull$$$0(6);
        }
        ((RangeMarkerImpl)interval).setValid(true);
        RMNode node = (RMNode)super.addInterval(interval, start2, end, greedyToLeft, greedyToRight, stickingToRight, layer);
        if (DEBUG && node.intervals.size() > 30 && !ApplicationInfoImpl.isInStressTest() && ApplicationManager.getApplication().isUnitTestMode()) {
            this.l.readLock().lock();
            try {
                String msg = this.errMsg(node);
                if (msg != null) {
                    LOG.warn(msg);
                }
            }
            finally {
                this.l.readLock().unlock();
            }
        }
        RMNode rMNode = node;
        if (rMNode == null) {
            RangeMarkerTree.$$$reportNull$$$0(7);
        }
        return rMNode;
    }

    private String errMsg(@NotNull RMNode<T> node) {
        if (node == null) {
            RangeMarkerTree.$$$reportNull$$$0(8);
        }
        System.gc();
        AtomicInteger alive = new AtomicInteger();
        node.processAliveKeys(t -> {
            alive.incrementAndGet();
            return true;
        });
        if (alive.get() > 30) {
            return "Too many range markers (" + alive + ") registered for interval " + node;
        }
        return null;
    }

    @Override
    @NotNull
    protected RMNode<T> createNewNode(@NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (key == null) {
            RangeMarkerTree.$$$reportNull$$$0(9);
        }
        RMNode<T> rMNode = new RMNode<T>(this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight);
        if (rMNode == null) {
            RangeMarkerTree.$$$reportNull$$$0(10);
        }
        return rMNode;
    }

    @Override
    protected RMNode<T> lookupNode(@NotNull T key) {
        if (key == null) {
            RangeMarkerTree.$$$reportNull$$$0(11);
        }
        return ((RangeMarkerImpl)key).myNode;
    }

    @Override
    protected void setNode(@NotNull T key, IntervalTreeImpl.IntervalNode<T> intervalNode) {
        if (key == null) {
            RangeMarkerTree.$$$reportNull$$$0(12);
        }
        ((RangeMarkerImpl)key).myNode = (RMNode)intervalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarkersOnChange(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(13);
        }
        try {
            this.l.writeLock().lock();
            if (this.size() == 0) {
                return;
            }
            this.checkMax(true);
            this.incModCount();
            SmartList affected = new SmartList();
            this.collectAffectedMarkersAndShiftSubtrees(this.getRoot(), e, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
            this.checkMax(false);
            if (!affected.isEmpty()) {
                for (int i = affected.size() - 1; i >= 0; --i) {
                    IntervalTreeImpl.IntervalNode node = (IntervalTreeImpl.IntervalNode)affected.get(i);
                    int startOffset = node.intervalStart();
                    int endOffset = node.intervalEnd();
                    this.removeNode(node);
                    this.checkMax(false);
                    node.clearDelta();
                    node.setParent(null);
                    node.setLeft(null);
                    node.setRight(null);
                    node.setValid(true);
                    assert (node.intervalStart() == startOffset);
                    assert (node.intervalEnd() == endOffset);
                }
                this.checkMax(true);
                for (IntervalTreeImpl.IntervalNode node : affected) {
                    List keys = node.intervals;
                    if (keys.isEmpty()) continue;
                    RangeMarkerImpl marker = null;
                    for (int i = keys.size() - 1; i >= 0; --i) {
                        Getter key = keys.get(i);
                        marker = (RangeMarkerImpl)key.get();
                        if (marker == null) continue;
                        if (marker.isValid()) break;
                        node.removeIntervalInternal(i);
                        marker = null;
                    }
                    if (marker == null) continue;
                    marker.documentChanged(e);
                    if (marker.isValid()) {
                        this.findOrInsertWithIntervals(node);
                        continue;
                    }
                    node.setValid(false);
                    ((RMNode)node).onRemoved();
                }
            }
            this.checkMax(true);
            IntervalTreeImpl.IntervalNode root = this.getRoot();
            assert (root == null || root.maxEnd + root.delta <= e.getDocument().getTextLength());
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void findOrInsertWithIntervals(IntervalTreeImpl.IntervalNode<T> node) {
        IntervalTreeImpl.IntervalNode<T> insertedNode = this.findOrInsert(node);
        if (insertedNode != node) {
            insertedNode.addIntervalsFrom(node);
        }
    }

    boolean collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<T> root, @NotNull DocumentEvent e, @NotNull List<? super IntervalTreeImpl.IntervalNode<T>> affected) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(14);
        }
        if (affected == null) {
            RangeMarkerTree.$$$reportNull$$$0(15);
        }
        if (root == null) {
            return true;
        }
        boolean norm = this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        int offset = e.getOffset();
        int affectedEndOffset = offset + e.getOldLength();
        boolean hasAliveKeys = root.hasAliveKey(false);
        if (!hasAliveKeys) {
            affected.add(root);
        }
        if (offset <= maxEnd) {
            if (affectedEndOffset < root.intervalStart()) {
                int lengthDelta = e.getNewLength() - e.getOldLength();
                int newD = root.changeDelta(lengthDelta);
                norm &= newD == 0;
                RedBlackTree.Node left = root.getLeft();
                if (left != null) {
                    int newL = ((IntervalTreeImpl.IntervalNode)left).changeDelta(-lengthDelta);
                    norm &= newL == 0;
                }
                norm &= this.pushDelta(root);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)left, e, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                this.correctMax(root, 0);
            } else {
                if (offset <= root.intervalEnd()) {
                    if (hasAliveKeys) {
                        affected.add(root);
                    }
                    root.setValid(false);
                }
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), e, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getRight(), e, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                this.correctMax(root, 0);
            }
        }
        return norm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reTarget(int start2, int end, int newBase) {
        this.l.writeLock().lock();
        try {
            this.checkMax(true);
            ArrayList affected = new ArrayList();
            this.collectNodesToRetarget(this.getRoot(), start2, end, affected);
            if (affected.isEmpty()) {
                return;
            }
            for (IntervalTreeImpl.IntervalNode node : affected) {
                this.removeNode(node);
            }
            int shift = newBase - start2;
            for (IntervalTreeImpl.IntervalNode node : affected) {
                node.setLeft(null);
                node.setRight(null);
                node.setParent(null);
                node.changeDelta(shift);
                node.setValid(true);
                this.pushDelta(node);
                List keys = node.intervals;
                if (keys.isEmpty()) continue;
                RangeMarkerImpl marker = null;
                for (int i = keys.size() - 1; i >= 0; --i) {
                    Getter key = keys.get(i);
                    marker = (RangeMarkerImpl)key.get();
                    if (marker == null) continue;
                    if (marker.isValid()) break;
                    node.removeIntervalInternal(i);
                    marker = null;
                }
                if (marker == null) continue;
                marker.onReTarget(start2, end, newBase);
                if (marker.isValid()) {
                    this.findOrInsertWithIntervals(node);
                    continue;
                }
                node.setValid(false);
                ((RMNode)node).onRemoved();
            }
        }
        finally {
            this.checkMax(true);
            this.l.writeLock().unlock();
        }
    }

    private void collectNodesToRetarget(@Nullable IntervalTreeImpl.IntervalNode<T> root, int start2, int end, @NotNull List<? super IntervalTreeImpl.IntervalNode<T>> affected) {
        if (affected == null) {
            RangeMarkerTree.$$$reportNull$$$0(16);
        }
        if (root == null) {
            return;
        }
        this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        if (start2 > maxEnd) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), start2, end, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
        if (start2 <= root.intervalStart() && root.intervalEnd() <= end) {
            affected.add(root);
        }
        if (end < root.intervalStart()) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getRight(), start2, end, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interval";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RangeMarkerTree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RangeMarkerTree";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addInterval";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "moveTextHappened";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compareEqualStartIntervals";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInterval";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "errMsg";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNewNode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lookupNode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setNode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateMarkersOnChange";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedMarkersAndShiftSubtrees";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectNodesToRetarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RMNode<T extends RangeMarkerEx>
    extends IntervalTreeImpl.IntervalNode<T> {
        private static final byte EXPAND_TO_LEFT_FLAG = 8;
        private static final byte EXPAND_TO_RIGHT_FLAG = 16;
        private static final byte STICK_TO_RIGHT_FLAG = 32;

        RMNode(@NotNull RangeMarkerTree<T> rangeMarkerTree, @NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight) {
            if (rangeMarkerTree == null) {
                RMNode.$$$reportNull$$$0(0);
            }
            if (key == null) {
                RMNode.$$$reportNull$$$0(1);
            }
            super(rangeMarkerTree, key, start2, end);
            this.setFlag((byte)8, greedyToLeft);
            this.setFlag((byte)16, greedyToRight);
            this.setFlag((byte)32, stickingToRight);
        }

        boolean isGreedyToLeft() {
            return this.isFlagSet((byte)8);
        }

        boolean isGreedyToRight() {
            return this.isFlagSet((byte)16);
        }

        boolean isStickingToRight() {
            return this.isFlagSet((byte)32);
        }

        void onRemoved() {
        }

        @Override
        public String toString() {
            return (this.isGreedyToLeft() ? "[" : "(") + this.intervalStart() + "," + this.intervalEnd() + (this.isGreedyToRight() ? "]" : ")");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeMarkerTree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/RangeMarkerTree$RMNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

