/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.FontInfo;
import gnu.trove.TObjectIntHashMap;
import java.awt.font.FontRenderContext;
import org.intellij.lang.annotations.JdkConstants;

public class DefaultEditorTextRepresentationHelper
implements EditorTextRepresentationHelper {
    private static final int MAX_SYMBOLS_WIDTHS_CACHE_SIZE = 1000;
    private final TObjectIntHashMap<Key> mySymbolWidthCache = new TObjectIntHashMap();
    private final Key mySharedKey = new Key();
    private final Editor myEditor;
    private FontRenderContext myFontRenderContext;

    public DefaultEditorTextRepresentationHelper(Editor editor) {
        this.myEditor = editor;
    }

    @Override
    public int charWidth(int c2, int fontType) {
        this.mySharedKey.fontType = fontType;
        this.mySharedKey.c = c2;
        return this.charWidth(c2);
    }

    private int charWidth(int c2) {
        int result2 = this.mySymbolWidthCache.get((Object)this.mySharedKey);
        if (result2 > 0) {
            return result2;
        }
        Key key = this.mySharedKey.clone();
        FontInfo font = ComplementaryFontsRegistry.getFontAbleToDisplay(c2, key.fontType, this.myEditor.getColorsScheme().getFontPreferences(), this.myFontRenderContext);
        result2 = font.charWidth(c2);
        if (this.mySymbolWidthCache.size() >= 1000) {
            this.mySymbolWidthCache.clear();
        }
        this.mySymbolWidthCache.put((Object)key, result2);
        return result2;
    }

    public void clearSymbolWidthCache() {
        this.mySymbolWidthCache.clear();
    }

    public void updateContext() {
        FontRenderContext oldContext = this.myFontRenderContext;
        this.myFontRenderContext = FontInfo.getFontRenderContext(this.myEditor.getContentComponent());
        if (!this.myFontRenderContext.equals(oldContext)) {
            this.clearSymbolWidthCache();
        }
    }

    private static class Key {
        @JdkConstants.FontStyle
        private int fontType;
        private int c;

        private Key() {
            this(0, 32);
        }

        Key(@JdkConstants.FontStyle int fontType, int c2) {
            this.fontType = fontType;
            this.c = c2;
        }

        protected Key clone() {
            return new Key(this.fontType, this.c);
        }

        public int hashCode() {
            int result2 = this.fontType;
            result2 = 31 * result2 + this.c;
            return result2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.fontType != key.fontType) {
                return false;
            }
            return this.c == key.c;
        }
    }
}

