/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ParallelActivity;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public abstract class ComponentManagerImpl
extends UserDataHolderBase
implements ComponentManager,
org.picocontainer.Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.components.ComponentManager");
    private volatile MutablePicoContainer myPicoContainer;
    private volatile boolean myDisposed;
    private volatile boolean myDisposeCompleted;
    private MessageBus myMessageBus;
    private final Map<String, BaseComponent> myNameToComponent;
    private int myComponentConfigCount;
    private int myInstantiatedComponentCount;
    private boolean myComponentsCreated;
    private final List<BaseComponent> myBaseComponents;
    private final ComponentManager myParentComponentManager;
    private final Condition myDisposedCondition;

    protected ComponentManagerImpl(@Nullable ComponentManager parentComponentManager) {
        this.myNameToComponent = new THashMap();
        this.myInstantiatedComponentCount = 0;
        this.myBaseComponents = new SmartList();
        this.myDisposedCondition = o -> this.isDisposed();
        this.myParentComponentManager = parentComponentManager;
        this.bootstrapPicoContainer(((Object)((Object)this)).toString());
    }

    protected ComponentManagerImpl(@Nullable ComponentManager parentComponentManager, @NotNull String name) {
        if (name == null) {
            ComponentManagerImpl.$$$reportNull$$$0(0);
        }
        this.myNameToComponent = new THashMap();
        this.myInstantiatedComponentCount = 0;
        this.myBaseComponents = new SmartList();
        this.myDisposedCondition = o -> this.isDisposed();
        this.myParentComponentManager = parentComponentManager;
        this.bootstrapPicoContainer(name);
    }

    @Nullable
    protected String activityNamePrefix() {
        return null;
    }

    protected void registerComponents(@NotNull List<? extends IdeaPluginDescriptor> plugins2) {
        Application app;
        if (plugins2 == null) {
            ComponentManagerImpl.$$$reportNull$$$0(1);
        }
        boolean headless = (app = ApplicationManager.getApplication()) == null || app.isHeadlessEnvironment();
        int componentConfigCount = 0;
        for (IdeaPluginDescriptor ideaPluginDescriptor : plugins2) {
            for (ComponentConfig config2 : this.getMyComponentConfigsFromDescriptor(ideaPluginDescriptor)) {
                if (!config2.prepareClasses(headless) || !this.isComponentSuitable(config2)) continue;
                this.registerComponents(config2, (PluginDescriptor)ideaPluginDescriptor);
                ++componentConfigCount;
            }
            this.registerServices(ideaPluginDescriptor);
        }
        this.myComponentConfigCount = componentConfigCount;
    }

    protected final void createComponents(@Nullable ProgressIndicator indicator) {
        String activityNamePrefix;
        LOG.assertTrue(!this.myComponentsCreated);
        if (indicator != null) {
            indicator.setIndeterminate(false);
        }
        Activity activity = (activityNamePrefix = this.activityNamePrefix()) == null ? null : StartUpMeasurer.start((String)(activityNamePrefix + "component creation"));
        DefaultPicoContainer picoContainer = (DefaultPicoContainer)this.getPicoContainer();
        for (ComponentAdapter componentAdapter : picoContainer.getComponentAdapters()) {
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter)) continue;
            ((ComponentConfigComponentAdapter)componentAdapter).getComponentInstance((PicoContainer)picoContainer, indicator);
        }
        if (activity != null) {
            activity.end();
        }
        this.myComponentsCreated = true;
    }

    protected void registerServices(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            ComponentManagerImpl.$$$reportNull$$$0(2);
        }
    }

    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ComponentManagerImpl.$$$reportNull$$$0(3);
        }
        indicator.setFraction(this.getPercentageOfComponentsLoaded());
    }

    protected final double getPercentageOfComponentsLoaded() {
        return (double)this.myInstantiatedComponentCount / (double)this.myComponentConfigCount;
    }

    @NotNull
    public MessageBus getMessageBus() {
        if (this.myDisposed) {
            this.throwAlreadyDisposed();
        }
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            ComponentManagerImpl.$$$reportNull$$$0(4);
        }
        return messageBus;
    }

    public final boolean isComponentsCreated() {
        return this.myComponentsCreated;
    }

    protected final synchronized void disposeComponents() {
        assert (!this.myDisposeCompleted) : "Already disposed!";
        this.myDisposed = true;
        List<BaseComponent> components = this.myBaseComponents;
        for (int i = components.size() - 1; i >= 0; --i) {
            try {
                components.get(i).disposeComponent();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.myBaseComponents.clear();
        this.myComponentConfigCount = -1;
    }

    public final <T> T getComponent(@NotNull Class<T> interfaceClass) {
        MutablePicoContainer picoContainer;
        ComponentAdapter adapter;
        if (interfaceClass == null) {
            ComponentManagerImpl.$$$reportNull$$$0(5);
        }
        if ((adapter = (picoContainer = this.getPicoContainer()).getComponentAdapter(interfaceClass)) == null) {
            return null;
        }
        return (T)adapter.getComponentInstance((PicoContainer)picoContainer);
    }

    public final <T> T getComponent(@NotNull Class<T> interfaceClass, T defaultImplementation) {
        T component;
        if (interfaceClass == null) {
            ComponentManagerImpl.$$$reportNull$$$0(6);
        }
        return (component = this.getComponent(interfaceClass)) == null ? defaultImplementation : component;
    }

    @Nullable
    protected ProgressIndicator getProgressIndicator() {
        return ProgressManager.getInstance().getProgressIndicator();
    }

    protected void handleInitComponentError(@NotNull Throwable ex, String componentClassName, PluginId pluginId) {
        if (ex == null) {
            ComponentManagerImpl.$$$reportNull$$$0(7);
        }
        LOG.error(ex);
    }

    public void registerComponentImplementation(@NotNull Class<?> componentKey, @NotNull Class<?> componentImplementation) {
        if (componentKey == null) {
            ComponentManagerImpl.$$$reportNull$$$0(8);
        }
        if (componentImplementation == null) {
            ComponentManagerImpl.$$$reportNull$$$0(9);
        }
        this.registerComponentImplementation(componentKey, componentImplementation, false);
    }

    public void registerComponentImplementation(@NotNull Class<?> componentKey, @NotNull Class<?> componentImplementation, boolean shouldBeRegistered) {
        if (componentKey == null) {
            ComponentManagerImpl.$$$reportNull$$$0(10);
        }
        if (componentImplementation == null) {
            ComponentManagerImpl.$$$reportNull$$$0(11);
        }
        MutablePicoContainer picoContainer = this.getPicoContainer();
        ComponentConfigComponentAdapter adapter = (ComponentConfigComponentAdapter)picoContainer.unregisterComponent(componentKey);
        if (shouldBeRegistered) {
            LOG.assertTrue(adapter != null);
        }
        picoContainer.registerComponent((ComponentAdapter)new ComponentConfigComponentAdapter(componentKey, componentImplementation, null, false));
    }

    public synchronized <T> T registerComponentInstance(@NotNull Class<T> componentKey, @NotNull T componentImplementation) {
        if (componentKey == null) {
            ComponentManagerImpl.$$$reportNull$$$0(12);
        }
        if (componentImplementation == null) {
            ComponentManagerImpl.$$$reportNull$$$0(13);
        }
        MutablePicoContainer picoContainer = this.getPicoContainer();
        ComponentAdapter adapter = picoContainer.getComponentAdapter(componentKey);
        LOG.assertTrue(adapter instanceof ComponentConfigComponentAdapter);
        ComponentConfigComponentAdapter componentAdapter = (ComponentConfigComponentAdapter)adapter;
        Object oldInstance = componentAdapter.myInitializedComponentInstance;
        componentAdapter.myInitializedComponentInstance = componentImplementation;
        return (T)oldInstance;
    }

    public boolean hasComponent(@NotNull Class interfaceClass) {
        if (interfaceClass == null) {
            ComponentManagerImpl.$$$reportNull$$$0(14);
        }
        return this.getPicoContainer().getComponentAdapter((Object)interfaceClass) != null;
    }

    @NotNull
    public <T> T[] getComponents(@NotNull Class<T> baseClass) {
        if (baseClass == null) {
            ComponentManagerImpl.$$$reportNull$$$0(15);
        }
        Object[] objectArray = ArrayUtil.toObjectArray(this.getComponentInstancesOfType(baseClass), baseClass);
        if (objectArray == null) {
            ComponentManagerImpl.$$$reportNull$$$0(16);
        }
        return objectArray;
    }

    @NotNull
    public final <T> List<T> getComponentInstancesOfType(@NotNull Class<T> baseClass) {
        if (baseClass == null) {
            ComponentManagerImpl.$$$reportNull$$$0(17);
        }
        List<T> list2 = this.getComponentInstancesOfType(baseClass, false);
        if (list2 == null) {
            ComponentManagerImpl.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    public final <T> List<T> getComponentInstancesOfType(@NotNull Class<T> baseClass, boolean createIfNotYet) {
        if (baseClass == null) {
            ComponentManagerImpl.$$$reportNull$$$0(19);
        }
        ArrayList<Object> result2 = null;
        for (ComponentAdapter componentAdapter : ((DefaultPicoContainer)this.getPicoContainer()).getComponentAdapters()) {
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter) || !ReflectionUtil.isAssignable(baseClass, (Class)componentAdapter.getComponentImplementation())) continue;
            ComponentConfigComponentAdapter adapter = (ComponentConfigComponentAdapter)componentAdapter;
            Object instance = createIfNotYet ? adapter.getComponentInstance((PicoContainer)this.myPicoContainer) : adapter.myInitializedComponentInstance;
            if (instance == null) continue;
            if (result2 == null) {
                result2 = new ArrayList<Object>();
            }
            result2.add(instance);
        }
        List list2 = ContainerUtil.notNullize(result2);
        if (list2 == null) {
            ComponentManagerImpl.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    public MutablePicoContainer getPicoContainer() {
        MutablePicoContainer container = this.myPicoContainer;
        if (container == null || this.myDisposeCompleted) {
            this.throwAlreadyDisposed();
        }
        MutablePicoContainer mutablePicoContainer = container;
        if (mutablePicoContainer == null) {
            ComponentManagerImpl.$$$reportNull$$$0(21);
        }
        return mutablePicoContainer;
    }

    @Contract(value="->fail")
    private void throwAlreadyDisposed() {
        ReadAction.run(() -> {
            ProgressManager.checkCanceled();
            throw new AssertionError((Object)("Already disposed: " + (Object)((Object)this)));
        });
    }

    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        DefaultPicoContainer defaultPicoContainer = this.myParentComponentManager == null ? new DefaultPicoContainer() : new DefaultPicoContainer(this.myParentComponentManager.getPicoContainer());
        if (defaultPicoContainer == null) {
            ComponentManagerImpl.$$$reportNull$$$0(22);
        }
        return defaultPicoContainer;
    }

    protected boolean isComponentSuitable(@NotNull ComponentConfig componentConfig) {
        Map options;
        if (componentConfig == null) {
            ComponentManagerImpl.$$$reportNull$$$0(23);
        }
        return (options = componentConfig.options) == null || !Boolean.parseBoolean((String)options.get("internal")) || ApplicationManager.getApplication().isInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDisposeCompleted = true;
        if (this.myMessageBus != null) {
            Disposer.dispose((Disposable)this.myMessageBus);
            this.myMessageBus = null;
        }
        this.myPicoContainer = null;
        ComponentManagerImpl componentManagerImpl = this;
        synchronized (componentManagerImpl) {
            this.myNameToComponent.clear();
        }
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    public List<ComponentConfig> getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            ComponentManagerImpl.$$$reportNull$$$0(24);
        }
        List list2 = plugin.getAppComponents();
        if (list2 == null) {
            ComponentManagerImpl.$$$reportNull$$$0(25);
        }
        return list2;
    }

    protected void bootstrapPicoContainer(@NotNull String name) {
        MutablePicoContainer picoContainer;
        if (name == null) {
            ComponentManagerImpl.$$$reportNull$$$0(26);
        }
        this.myPicoContainer = picoContainer = this.createPicoContainer();
        this.myMessageBus = MessageBusFactory.newMessageBus((Object)name, this.myParentComponentManager == null ? null : this.myParentComponentManager.getMessageBus());
        if (this.myMessageBus instanceof MessageBusImpl) {
            ((MessageBusImpl)this.myMessageBus).setMessageDeliveryListener((topic, messageName, handler2, duration) -> this.logMessageBusDelivery(topic, messageName, handler2, duration));
        }
        picoContainer.registerComponentInstance(MessageBus.class, (Object)this.myMessageBus);
    }

    protected void logMessageBusDelivery(Topic topic, String messageName, Object handler2, long durationNanos) {
        ClassLoader loader = handler2.getClass().getClassLoader();
        String pluginId = loader instanceof PluginClassLoader ? ((PluginClassLoader)((Object)loader)).getPluginIdString() : "com.intellij";
        StartUpMeasurer.addPluginCost((String)pluginId, (String)"MessageBus", (long)durationNanos);
    }

    protected final ComponentManager getParentComponentManager() {
        return this.myParentComponentManager;
    }

    @Nullable
    static PluginId getConfig(@NotNull ComponentAdapter adapter) {
        if (adapter == null) {
            ComponentManagerImpl.$$$reportNull$$$0(27);
        }
        return adapter instanceof ComponentConfigComponentAdapter ? ((ComponentConfigComponentAdapter)adapter).myPluginId : null;
    }

    public final boolean isWorkspaceComponent(@NotNull Class<?> componentImplementation) {
        ComponentConfigComponentAdapter adapter;
        if (componentImplementation == null) {
            ComponentManagerImpl.$$$reportNull$$$0(28);
        }
        return (adapter = this.getComponentAdapter(componentImplementation)) != null && adapter.isWorkspaceComponent;
    }

    @Nullable
    private ComponentConfigComponentAdapter getComponentAdapter(@NotNull Class<?> componentImplementation) {
        if (componentImplementation == null) {
            ComponentManagerImpl.$$$reportNull$$$0(29);
        }
        for (ComponentAdapter componentAdapter : ((DefaultPicoContainer)this.getPicoContainer()).getComponentAdapters()) {
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter) || componentAdapter.getComponentImplementation() != componentImplementation) continue;
            return (ComponentConfigComponentAdapter)componentAdapter;
        }
        return null;
    }

    @NotNull
    public final Condition<?> getDisposed() {
        Condition condition = this.myDisposedCondition;
        if (condition == null) {
            ComponentManagerImpl.$$$reportNull$$$0(30);
        }
        return condition;
    }

    @NotNull
    public static String getComponentName(@NotNull Object component) {
        if (component == null) {
            ComponentManagerImpl.$$$reportNull$$$0(31);
        }
        if (component instanceof NamedComponent) {
            String string = ((NamedComponent)component).getComponentName();
            if (string == null) {
                ComponentManagerImpl.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = component.getClass().getName();
        if (string == null) {
            ComponentManagerImpl.$$$reportNull$$$0(33);
        }
        return string;
    }

    private void registerComponents(@NotNull ComponentConfig config2, @NotNull PluginDescriptor pluginDescriptor) {
        if (config2 == null) {
            ComponentManagerImpl.$$$reportNull$$$0(34);
        }
        if (pluginDescriptor == null) {
            ComponentManagerImpl.$$$reportNull$$$0(35);
        }
        ClassLoader loader = pluginDescriptor.getPluginClassLoader();
        try {
            Class<?> interfaceClass = Class.forName(config2.getInterfaceClass(), true, loader);
            Class<?> implementationClass = Comparing.equal((String)config2.getInterfaceClass(), (String)config2.getImplementationClass()) ? interfaceClass : (StringUtil.isEmpty((String)config2.getImplementationClass()) ? null : Class.forName(config2.getImplementationClass(), true, loader));
            MutablePicoContainer picoContainer = this.getPicoContainer();
            if (config2.options != null && Boolean.parseBoolean((String)config2.options.get("overrides"))) {
                ComponentAdapter oldAdapter = picoContainer.getComponentAdapterOfType(interfaceClass);
                if (oldAdapter == null) {
                    throw new RuntimeException(config2 + " does not override anything");
                }
                picoContainer.unregisterComponent(oldAdapter.getComponentKey());
            }
            if (implementationClass != null) {
                boolean ws = config2.options != null && Boolean.parseBoolean((String)config2.options.get("workspace"));
                picoContainer.registerComponent((ComponentAdapter)new ComponentConfigComponentAdapter(interfaceClass, implementationClass, pluginDescriptor.getPluginId(), ws));
            }
        }
        catch (Throwable t) {
            this.handleInitComponentError(t, null, pluginDescriptor.getPluginId());
        }
    }

    private void registerComponentInstance(@NotNull Object instance) {
        if (instance == null) {
            ComponentManagerImpl.$$$reportNull$$$0(36);
        }
        ++this.myInstantiatedComponentCount;
        if (instance instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)instance));
        }
        if (!(instance instanceof BaseComponent)) {
            return;
        }
        BaseComponent baseComponent = (BaseComponent)instance;
        String componentName = baseComponent.getComponentName();
        if (this.myNameToComponent.containsKey(componentName)) {
            BaseComponent loadedComponent = this.myNameToComponent.get(componentName);
            if (!instance.equals(loadedComponent)) {
                String errorMessage = "Component name collision: " + componentName + ' ' + (loadedComponent == null ? "null" : loadedComponent.getClass()) + " and " + instance.getClass();
                PluginException.logPluginError((Logger)LOG, (String)errorMessage, null, instance.getClass());
            }
        } else {
            this.myNameToComponent.put(componentName, baseComponent);
        }
        this.myBaseComponents.add(baseComponent);
    }

    public synchronized BaseComponent getComponent(@NotNull String name) {
        if (name == null) {
            ComponentManagerImpl.$$$reportNull$$$0(37);
        }
        return this.myNameToComponent.get(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 30: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 30: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 2: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/ComponentManagerImpl";
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentConfig";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/ComponentManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentInstancesOfType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPicoContainer";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createPicoContainer";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyComponentConfigsFromDescriptor";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposed";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "registerComponents";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerServices";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProgressDuringInit";
                break;
            }
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 30: 
            case 32: 
            case 33: {
                break;
            }
            case 5: 
            case 6: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleInitComponentError";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentImplementation";
                break;
            }
            case 12: 
            case 13: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasComponent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstancesOfType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isComponentSuitable";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getMyComponentConfigsFromDescriptor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "bootstrapPicoContainer";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isWorkspaceComponent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapter";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getComponentName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 30: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ComponentConfigComponentAdapter
    extends CachingConstructorInjectionComponentAdapter {
        private final PluginId myPluginId;
        private volatile Object myInitializedComponentInstance;
        private boolean myInitializing;
        final boolean isWorkspaceComponent;

        ComponentConfigComponentAdapter(@NotNull Class<?> interfaceClass, @Nullable Class<?> implementationClass, PluginId pluginId, boolean isWorkspaceComponent) {
            if (interfaceClass == null) {
                ComponentConfigComponentAdapter.$$$reportNull$$$0(0);
            }
            if (implementationClass == null) {
                ComponentConfigComponentAdapter.$$$reportNull$$$0(1);
            }
            super(interfaceClass, implementationClass, null, true);
            this.myPluginId = pluginId;
            this.isWorkspaceComponent = isWorkspaceComponent;
        }

        public Object getComponentInstance(@NotNull PicoContainer picoContainer) {
            if (picoContainer == null) {
                ComponentConfigComponentAdapter.$$$reportNull$$$0(2);
            }
            return this.getComponentInstance(picoContainer, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getComponentInstance(@NotNull PicoContainer picoContainer, @Nullable ProgressIndicator indicator) {
            Object instance;
            if (picoContainer == null) {
                ComponentConfigComponentAdapter.$$$reportNull$$$0(3);
            }
            if ((instance = this.myInitializedComponentInstance) != null || ComponentManagerImpl.this.myDisposed) {
                return instance;
            }
            try {
                ComponentConfigComponentAdapter componentConfigComponentAdapter = this;
                synchronized (componentConfigComponentAdapter) {
                    instance = this.myInitializedComponentInstance;
                    if (instance != null) {
                        return instance;
                    }
                    Activity activity = this.createMeasureActivity(picoContainer);
                    instance = super.getComponentInstance(picoContainer);
                    if (this.myInitializing) {
                        String errorMessage = "Cyclic component initialization: " + this.getComponentKey();
                        if (this.myPluginId != null) {
                            LOG.error((Throwable)new PluginException(errorMessage, this.myPluginId));
                        } else {
                            LOG.error(new Throwable(errorMessage));
                        }
                    }
                    try {
                        this.myInitializing = true;
                        ComponentManagerImpl.this.registerComponentInstance(instance);
                        if (indicator != null) {
                            indicator.checkCanceled();
                            ComponentManagerImpl.this.setProgressDuringInit(indicator);
                        }
                        ComponentManagerImpl.this.initializeComponent(instance, null);
                        if (instance instanceof BaseComponent) {
                            ((BaseComponent)instance).initComponent();
                        }
                        if (activity != null) {
                            activity.end();
                        }
                    }
                    finally {
                        this.myInitializing = false;
                    }
                    this.myInitializedComponentInstance = instance;
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                ComponentManagerImpl.this.handleInitComponentError(t, ((Class)this.getComponentKey()).getName(), this.myPluginId);
            }
            return instance;
        }

        @Nullable
        private Activity createMeasureActivity(@NotNull PicoContainer picoContainer) {
            StartUpMeasurer.Level level;
            if (picoContainer == null) {
                ComponentConfigComponentAdapter.$$$reportNull$$$0(4);
            }
            if ((level = DefaultPicoContainer.getActivityLevel((PicoContainer)picoContainer)) == StartUpMeasurer.Level.APPLICATION || level == StartUpMeasurer.Level.PROJECT && ComponentManagerImpl.this.activityNamePrefix() != null) {
                return ParallelActivity.COMPONENT.start(this.getComponentImplementation().getName(), level, this.myPluginId != null ? this.myPluginId.getIdString() : null);
            }
            return null;
        }

        public String toString() {
            return "ComponentConfigAdapter[" + this.getComponentKey() + "]: implementation=" + this.getComponentImplementation() + ", plugin=" + this.myPluginId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interfaceClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implementationClass";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "picoContainer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/components/impl/ComponentManagerImpl$ComponentConfigComponentAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getComponentInstance";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createMeasureActivity";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

