/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.constraints.ConstrainedExecution;
import com.intellij.openapi.application.constraints.ExpirableConstrainedExecution;
import com.intellij.openapi.application.constraints.Expiration;
import com.intellij.openapi.application.impl.AppUIExecutorEx;
import com.intellij.openapi.application.impl.AppUIExecutorImpl;
import com.intellij.openapi.application.impl.InSmartMode;
import com.intellij.openapi.application.impl.WithDocumentsCommitted;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BooleanSupplier;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B9\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ7\u0010\u000f\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0019H\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\b\u0010!\u001a\u00020\u0019H\u0016J\u0014\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010$\u001a\u00020\u0015H\u0016J\"\u0010\"\u001a\b\u0012\u0004\u0012\u0002H%0#\"\u0004\b\u0000\u0010%2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H%0&H\u0016J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/openapi/application/impl/AppUIExecutorImpl;", "Lcom/intellij/openapi/application/constraints/ExpirableConstrainedExecution;", "Lcom/intellij/openapi/application/impl/AppUIExecutorEx;", "modality", "Lcom/intellij/openapi/application/ModalityState;", "(Lcom/intellij/openapi/application/ModalityState;)V", "constraints", "", "Lcom/intellij/openapi/application/constraints/ConstrainedExecution$ContextConstraint;", "cancellationConditions", "Ljava/util/function/BooleanSupplier;", "expirableHandles", "", "Lcom/intellij/openapi/application/constraints/Expiration;", "(Lcom/intellij/openapi/application/ModalityState;[Lcom/intellij/openapi/application/constraints/ConstrainedExecution$ContextConstraint;[Ljava/util/function/BooleanSupplier;Ljava/util/Set;)V", "cloneWith", "expirationSet", "([Lcom/intellij/openapi/application/constraints/ConstrainedExecution$ContextConstraint;[Ljava/util/function/BooleanSupplier;Ljava/util/Set;)Lcom/intellij/openapi/application/impl/AppUIExecutorEx;", "dispatchLaterUnconstrained", "", "runnable", "Ljava/lang/Runnable;", "execute", "command", "inSmartMode", "Lcom/intellij/openapi/application/AppUIExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "inTransaction", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "inUndoTransparentAction", "inWriteAction", "later", "submit", "Lorg/jetbrains/concurrency/CancellablePromise;", "task", "T", "Ljava/util/concurrent/Callable;", "withDocumentsCommitted", "intellij.platform.ide.impl"})
public final class AppUIExecutorImpl
extends ExpirableConstrainedExecution<AppUIExecutorEx>
implements AppUIExecutorEx {
    private final ModalityState modality;

    @Override
    @NotNull
    protected AppUIExecutorEx cloneWith(@NotNull ConstrainedExecution.ContextConstraint[] constraints, @NotNull BooleanSupplier[] cancellationConditions, @NotNull Set<? extends Expiration> expirationSet) {
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)cancellationConditions, (String)"cancellationConditions");
        Intrinsics.checkParameterIsNotNull(expirationSet, (String)"expirationSet");
        return new AppUIExecutorImpl(this.modality, constraints, cancellationConditions, expirationSet);
    }

    @Override
    public void dispatchLaterUnconstrained(@NotNull Runnable runnable2) {
        Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
        ApplicationManager.getApplication().invokeLater(runnable2, this.modality);
    }

    public void execute(@NotNull Runnable command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this.asExecutor().execute(command);
    }

    @NotNull
    public CancellablePromise<?> submit(@NotNull Runnable task2) {
        Intrinsics.checkParameterIsNotNull((Object)task2, (String)"task");
        CancellablePromise<Void> cancellablePromise = this.asExecutor().submit(task2);
        Intrinsics.checkExpressionValueIsNotNull(cancellablePromise, (String)"asExecutor().submit(task)");
        return cancellablePromise;
    }

    @NotNull
    public <T> CancellablePromise<T> submit(@NotNull Callable<T> task2) {
        Intrinsics.checkParameterIsNotNull(task2, (String)"task");
        CancellablePromise<T> cancellablePromise = this.asExecutor().submit(task2);
        Intrinsics.checkExpressionValueIsNotNull(cancellablePromise, (String)"asExecutor().submit(task)");
        return cancellablePromise;
    }

    @NotNull
    public AppUIExecutor later() {
        int n;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            IdeEventQueue ideEventQueue = IdeEventQueue.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)ideEventQueue, (String)"IdeEventQueue.getInstance()");
            n = ideEventQueue.getEventCount();
        } else {
            n = -1;
        }
        int edtEventCount = n;
        return (AppUIExecutor)this.withConstraint(new ConstrainedExecution.ContextConstraint(this, edtEventCount){
            private volatile boolean usedOnce;
            final /* synthetic */ AppUIExecutorImpl this$0;
            final /* synthetic */ int $edtEventCount;

            public final boolean getUsedOnce() {
                return this.usedOnce;
            }

            public final void setUsedOnce(boolean bl) {
                this.usedOnce = bl;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isCorrectContext() {
                switch (this.$edtEventCount) {
                    case -1: {
                        Application application = ApplicationManager.getApplication();
                        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                        boolean bl = application.isDispatchThread();
                        return bl;
                    }
                    default: {
                        if (this.usedOnce) return true;
                        IdeEventQueue ideEventQueue = IdeEventQueue.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)ideEventQueue, (String)"IdeEventQueue.getInstance()");
                        if (this.$edtEventCount == ideEventQueue.getEventCount()) return false;
                        return true;
                    }
                }
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                ApplicationManager.getApplication().invokeLater(new Runnable(this, runnable2){
                    final /* synthetic */ later.1 this$0;
                    final /* synthetic */ Runnable $runnable;

                    public final void run() {
                        this.this$0.setUsedOnce(true);
                        this.$runnable.run();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$runnable = runnable2;
                    }
                }, AppUIExecutorImpl.access$getModality$p(this.this$0));
            }

            @NotNull
            public String toString() {
                return "later";
            }
            {
                this.this$0 = $outer;
                this.$edtEventCount = $captured_local_variable$1;
            }
        });
    }

    @NotNull
    public AppUIExecutor withDocumentsCommitted(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return (AppUIExecutor)this.withConstraint(new WithDocumentsCommitted(project, this.modality), (Disposable)project);
    }

    @NotNull
    public AppUIExecutor inSmartMode(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return (AppUIExecutor)this.withConstraint(new InSmartMode(project), (Disposable)project);
    }

    @NotNull
    public AppUIExecutor inTransaction(@NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        TransactionGuard transactionGuard = TransactionGuard.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)transactionGuard, (String)"TransactionGuard.getInstance()");
        TransactionId id = transactionGuard.getContextTransaction();
        return ((AppUIExecutorEx)this.withConstraint(new ConstrainedExecution.ContextConstraint(id){
            final /* synthetic */ TransactionId $id;

            public boolean isCorrectContext() {
                TransactionGuard transactionGuard = TransactionGuard.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)transactionGuard, (String)"TransactionGuard.getInstance()");
                return transactionGuard.getContextTransaction() != null;
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                TransactionGuard.getInstance().submitTransaction((Disposable)ApplicationManager.getApplication(), this.$id, runnable2);
            }

            @NotNull
            public String toString() {
                return "inTransaction";
            }
            {
                this.$id = $captured_local_variable$0;
            }
        })).expireWith(parentDisposable);
    }

    @Override
    @NotNull
    public AppUIExecutor inUndoTransparentAction() {
        return (AppUIExecutor)this.withConstraint(new ConstrainedExecution.ContextConstraint(){

            public boolean isCorrectContext() {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)commandProcessor, (String)"CommandProcessor.getInstance()");
                return commandProcessor.isUndoTransparentActionInProgress();
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                CommandProcessor.getInstance().runUndoTransparentAction(runnable2);
            }

            @NotNull
            public String toString() {
                return "inUndoTransparentAction";
            }
        });
    }

    @Override
    @NotNull
    public AppUIExecutor inWriteAction() {
        return (AppUIExecutor)this.withConstraint(new ConstrainedExecution.ContextConstraint(){

            public boolean isCorrectContext() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                return application.isWriteAccessAllowed();
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                ApplicationManager.getApplication().runWriteAction(runnable2);
            }

            @NotNull
            public String toString() {
                return "inWriteAction";
            }
        });
    }

    private AppUIExecutorImpl(ModalityState modality, ConstrainedExecution.ContextConstraint[] constraints, BooleanSupplier[] cancellationConditions, Set<? extends Expiration> expirableHandles) {
        super(constraints, cancellationConditions, expirableHandles);
        this.modality = modality;
    }

    public AppUIExecutorImpl(final @NotNull ModalityState modality) {
        Intrinsics.checkParameterIsNotNull((Object)modality, (String)"modality");
        ConstrainedExecution.ContextConstraint[] contextConstraintArray = new ConstrainedExecution.ContextConstraint[]{new ConstrainedExecution.ContextConstraint(){

            @Override
            public boolean isCorrectContext() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                return application.isDispatchThread() && !ModalityState.current().dominates(modality);
            }

            @Override
            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                ApplicationManager.getApplication().invokeLater(runnable2, modality);
            }

            @Override
            @NotNull
            public String toString() {
                return "onUiThread(" + modality + ')';
            }
        }};
        ModalityState modalityState = modality;
        AppUIExecutorImpl appUIExecutorImpl = this;
        BooleanSupplier[] booleanSupplierArray = new BooleanSupplier[]{};
        appUIExecutorImpl(modalityState, contextConstraintArray, booleanSupplierArray, SetsKt.emptySet());
    }

    public static final /* synthetic */ ModalityState access$getModality$p(AppUIExecutorImpl $this) {
        return $this.modality;
    }
}

