/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.Semaphore;
import java.util.function.Supplier;

public class ActionUpdateEdtExecutor {
    public static <T> T computeOnEdt(Supplier<T> supplier) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            return supplier.get();
        }
        Semaphore semaphore = new Semaphore(1);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        Ref result2 = Ref.create();
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                if (indicator == null || !indicator.isCanceled()) {
                    result2.set(supplier.get());
                }
            }
            finally {
                semaphore.up();
            }
        });
        while (!semaphore.waitFor(10L)) {
            if (indicator == null || !indicator.isCanceled()) continue;
            throw new ProcessCanceledException();
        }
        if (indicator != null && indicator.isCanceled()) {
            throw new ProcessCanceledException();
        }
        return (T)result2.get();
    }
}

