/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.notification.EventLog;
import com.intellij.notification.LogModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public class IdeNotificationArea
extends JLabel
implements UISettingsListener,
CustomStatusBarWidget,
IconLikeCustomStatusBarWidget {
    public static final String WIDGET_ID = "Notifications";
    private final Project myProject;
    private StatusBar myStatusBar;

    public IdeNotificationArea(@NotNull Project project) {
        if (project == null) {
            IdeNotificationArea.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!IdeNotificationArea.this.myProject.isDisposed()) {
                    EventLog.toggleLog(IdeNotificationArea.this.myProject, null);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/notification/impl/IdeNotificationArea$1", "onClick"));
            }
        }.installOn((Component)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(LogModel.LOG_MODEL_CHANGED, () -> ApplicationManager.getApplication().invokeLater(() -> this.updateStatus()));
        final Disposable onToolWindowRegistration = Disposer.newDisposable((String)"EventLog#onToolWindowRegistration");
        Disposer.register((Disposable)this, (Disposable)onToolWindowRegistration);
        this.myProject.getMessageBus().connect(onToolWindowRegistration).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ("Event Log".equals(id)) {
                    Disposer.dispose((Disposable)onToolWindowRegistration);
                    ApplicationManager.getApplication().invokeLater(() -> IdeNotificationArea.this.updateStatus());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/notification/impl/IdeNotificationArea$2", "toolWindowRegistered"));
            }
        });
        this.setBorder(StatusBarWidget.WidgetBorder.ICON);
    }

    public void uiSettingsChanged(UISettings uiSettings) {
        this.updateStatus();
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            IdeNotificationArea.$$$reportNull$$$0(1);
        }
        return null;
    }

    public void dispose() {
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            IdeNotificationArea.$$$reportNull$$$0(2);
        }
        this.myStatusBar = statusBar;
        this.updateStatus();
    }

    @NotNull
    public String ID() {
        if (WIDGET_ID == null) {
            IdeNotificationArea.$$$reportNull$$$0(3);
        }
        return WIDGET_ID;
    }

    private void updateStatus() {
        if (this.myProject.isDisposed()) {
            return;
        }
        ArrayList<Notification> notifications = EventLog.getLogModel(this.myProject).getNotifications();
        this.updateIconOnStatusBarAndToolWindow(notifications);
        int count = notifications.size();
        this.setToolTipText(count > 0 ? String.format("%s notification%s pending", count, count == 1 ? "" : "s") : "No new notifications");
        this.myStatusBar.updateWidget(this.ID());
    }

    private void updateIconOnStatusBarAndToolWindow(ArrayList<Notification> notifications) {
        if (UISettings.getInstance().getHideToolStripes() || UISettings.getInstance().getPresentationMode()) {
            this.setVisible(true);
            this.setIcon((Icon)this.createIconWithNotificationCount(notifications, false));
        } else {
            ToolWindow eventLog = EventLog.getEventLog(this.myProject);
            if (eventLog != null) {
                eventLog.setIcon((Icon)this.createIconWithNotificationCount(notifications, true));
            }
            this.setVisible(false);
        }
    }

    private LayeredIcon createIconWithNotificationCount(ArrayList<? extends Notification> notifications, boolean forToolWindow) {
        return IdeNotificationArea.createIconWithNotificationCount(this, IdeNotificationArea.getMaximumType(notifications), notifications.size(), forToolWindow);
    }

    @NotNull
    public static LayeredIcon createIconWithNotificationCount(JComponent component, NotificationType type, int size, boolean forToolWindow) {
        LayeredIcon icon = new LayeredIcon(2);
        Icon baseIcon = IdeNotificationArea.getPendingNotificationsIcon(type, forToolWindow);
        icon.setIcon(baseIcon, 0);
        if (size > 0) {
            Object textColor = type == NotificationType.ERROR || type == NotificationType.INFORMATION ? new JBColor(Color.white, new Color(0xF2F2F2)) : new Color(0x333333);
            icon.setIcon((Icon)new TextIcon(component, size < 10 ? String.valueOf(size) : "9+", (Color)textColor, baseIcon), 1);
        }
        LayeredIcon layeredIcon = icon;
        if (layeredIcon == null) {
            IdeNotificationArea.$$$reportNull$$$0(4);
        }
        return layeredIcon;
    }

    public JComponent getComponent() {
        return this;
    }

    private static Icon getPendingNotificationsIcon(NotificationType maximumType, boolean forToolWindow) {
        if (maximumType != null) {
            switch (maximumType) {
                case WARNING: {
                    return forToolWindow ? AllIcons.Toolwindows.WarningEvents : AllIcons.Ide.Notification.WarningEvents;
                }
                case ERROR: {
                    return forToolWindow ? AllIcons.Toolwindows.ErrorEvents : AllIcons.Ide.Notification.ErrorEvents;
                }
                case INFORMATION: {
                    return forToolWindow ? AllIcons.Toolwindows.InfoEvents : AllIcons.Ide.Notification.InfoEvents;
                }
            }
        }
        return forToolWindow ? AllIcons.Toolwindows.NoEvents : AllIcons.Ide.Notification.NoEvents;
    }

    @Nullable
    private static NotificationType getMaximumType(List<? extends Notification> notifications) {
        NotificationType result2 = null;
        for (Notification notification : notifications) {
            if (NotificationType.ERROR == notification.getType()) {
                return NotificationType.ERROR;
            }
            if (NotificationType.WARNING == notification.getType()) {
                result2 = NotificationType.WARNING;
                continue;
            }
            if (result2 != null || NotificationType.INFORMATION != notification.getType()) continue;
            result2 = NotificationType.INFORMATION;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/IdeNotificationArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/IdeNotificationArea";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconWithNotificationCount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TextIcon
    implements Icon {
        private final String myStr;
        private final JComponent myComponent;
        private final Color myTextColor;
        private final Icon myBaseIcon;
        private final int myWidth;
        private final Font myFont;

        TextIcon(JComponent component, @NotNull String str, @NotNull Color textColor, @NotNull Icon baseIcon) {
            if (str == null) {
                TextIcon.$$$reportNull$$$0(0);
            }
            if (textColor == null) {
                TextIcon.$$$reportNull$$$0(1);
            }
            if (baseIcon == null) {
                TextIcon.$$$reportNull$$$0(2);
            }
            this.myStr = str;
            this.myComponent = component;
            this.myTextColor = textColor;
            this.myBaseIcon = baseIcon;
            this.myFont = new Font(NotificationsUtil.getFontName(), 1, JBUIScale.scale((int)9));
            this.myWidth = this.myComponent.getFontMetrics(this.myFont).stringWidth(this.myStr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TextIcon)) {
                return false;
            }
            TextIcon icon = (TextIcon)o;
            if (this.myWidth != icon.myWidth) {
                return false;
            }
            if (!this.myComponent.equals(icon.myComponent)) {
                return false;
            }
            return this.myStr.equals(icon.myStr);
        }

        public int hashCode() {
            int result2 = this.myStr.hashCode();
            result2 = 31 * result2 + this.myComponent.hashCode();
            result2 = 31 * result2 + this.myWidth;
            return result2;
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            UISettings.setupAntialiasing((Graphics)g);
            Font originalFont = g.getFont();
            Color originalColor = g.getColor();
            g.setFont(this.myFont);
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)c2, g);
            boolean isTwoChar = this.myStr.length() == 2;
            float center = this.getIconWidth() - fm.stringWidth(this.myStr) + (isTwoChar ? JBUIScale.scale((int)1) : 0);
            float textX = (float)x + center / 2.0f;
            float textY = y + SimpleColoredComponent.getTextBaseLine((FontMetrics)fm, (int)this.getIconHeight());
            if (!JreHiDpiUtil.isJreHiDPI((Graphics2D)g2)) {
                textX = (float)Math.floor(textX);
            }
            g.setColor(this.myTextColor);
            g2.drawString(this.myStr.substring(0, 1), textX, textY);
            if (isTwoChar) {
                g2.drawString(this.myStr.substring(1), textX += (float)(fm.charWidth(this.myStr.charAt(0)) - JBUIScale.scale((int)1)), textY);
            }
            g.setFont(originalFont);
            g.setColor(originalColor);
        }

        @Override
        public int getIconWidth() {
            return this.myBaseIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myBaseIcon.getIconHeight();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "str";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textColor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseIcon";
                    break;
                }
            }
            objectArray[1] = "com/intellij/notification/impl/IdeNotificationArea$TextIcon";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

