/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.intellij.largeFilesEditor.editor.AbsoluteSymbolPosition;
import com.intellij.largeFilesEditor.editor.Page;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;

public class DocumentOfPagesModel {
    private static final Logger LOG = Logger.getInstance(DocumentOfPagesModel.class);
    private final Document myDocument;
    private final ArrayList<Page> pagesInDocument = new ArrayList();
    private final ArrayList<Integer> symbolOffsetToEndOfPage = new ArrayList();

    DocumentOfPagesModel(Document document) {
        this.myDocument = document;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public int getPagesAmount() {
        return this.pagesInDocument.size();
    }

    public ArrayList<Page> getPagesList() {
        return this.pagesInDocument;
    }

    public Page getPageByIndex(int index) {
        return this.pagesInDocument.get(index);
    }

    public Page getFirstPage() {
        if (this.pagesInDocument.isEmpty()) {
            return null;
        }
        return this.pagesInDocument.get(0);
    }

    public Page getLastPage() {
        if (this.pagesInDocument.isEmpty()) {
            return null;
        }
        return this.pagesInDocument.get(this.pagesInDocument.size() - 1);
    }

    public void addDocumentListener(DocumentListener listener2) {
        this.myDocument.addDocumentListener(listener2);
    }

    public void removeDocumentListener(DocumentListener listener2) {
        this.myDocument.removeDocumentListener(listener2);
    }

    public void addPageIntoEnd(Page page, Project project) {
        this.pagesInDocument.add(page);
        this.symbolOffsetToEndOfPage.add((this.symbolOffsetToEndOfPage.isEmpty() ? 0 : this.symbolOffsetToEndOfPage.get(this.symbolOffsetToEndOfPage.size() - 1)) + page.getText().length());
        DocumentOfPagesModel.runAsWriteAction(project, this.myDocument.getTextLength() == 0 ? () -> this.myDocument.setText((CharSequence)page.getText()) : () -> this.myDocument.insertString(this.myDocument.getTextLength(), (CharSequence)page.getText()));
    }

    public void removeLastPage(Project project) {
        if (this.pagesInDocument.size() > 0) {
            int indexOfLastPage = this.pagesInDocument.size() - 1;
            Page lastPage = this.pagesInDocument.get(indexOfLastPage);
            this.pagesInDocument.remove(indexOfLastPage);
            this.symbolOffsetToEndOfPage.remove(indexOfLastPage);
            DocumentOfPagesModel.runAsWriteAction(project, () -> this.myDocument.deleteString(this.myDocument.getTextLength() - lastPage.getText().length(), this.myDocument.getTextLength()));
        }
    }

    public void removeAllPages(Project project) {
        if (!this.pagesInDocument.isEmpty()) {
            this.pagesInDocument.clear();
            this.symbolOffsetToEndOfPage.clear();
            DocumentOfPagesModel.runAsWriteAction(project, () -> this.myDocument.deleteString(0, this.myDocument.getTextLength()));
        }
    }

    private static void runAsWriteAction(Project project, Runnable action2) {
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(action2), null, null);
    }

    public AbsoluteSymbolPosition offsetToAbsoluteSymbolPosition(int offset) {
        if (offset < 0 || offset > this.myDocument.getTextLength()) {
            throw new IllegalArgumentException("offset=" + offset + " document.length=" + this.myDocument.getTextLength());
        }
        for (int i = this.pagesInDocument.size() - 1; i >= 0; --i) {
            int symbolOffsetToStartOfPage = this.getSymbolOffsetToStartOfPage(i);
            if (offset < symbolOffsetToStartOfPage) continue;
            return new AbsoluteSymbolPosition(this.pagesInDocument.get(i).getPageNumber(), offset - symbolOffsetToStartOfPage);
        }
        LOG.warn((Throwable)new UnsupportedOperationException("offset=" + offset + " document.length=" + this.myDocument.getTextLength() + " pagesInDocument.size=" + this.pagesInDocument.size()));
        return new AbsoluteSymbolPosition(0L, 0);
    }

    public int absoluteSymbolPositionToOffset(AbsoluteSymbolPosition absolutePosition) {
        if (absolutePosition == null || this.pagesInDocument.size() == 0) {
            return 0;
        }
        if (absolutePosition.pageNumber < this.getFirstPage().getPageNumber()) {
            return 0;
        }
        if (absolutePosition.pageNumber > this.getLastPage().getPageNumber()) {
            return this.myDocument.getTextLength();
        }
        for (int i = 0; i < this.pagesInDocument.size(); ++i) {
            if (absolutePosition.pageNumber != this.pagesInDocument.get(i).getPageNumber()) continue;
            return this.getSymbolOffsetToStartOfPage(i) + absolutePosition.symbolOffsetInPage;
        }
        LOG.warn((Throwable)new UnsupportedOperationException("absolutePosition=" + absolutePosition + " document.length=" + this.myDocument.getTextLength() + " pagesInDocument.size=" + this.pagesInDocument.size()));
        return 0;
    }

    public int getSymbolOffsetToStartOfPage(int indexOfPage) {
        if (indexOfPage == 0) {
            return 0;
        }
        if (indexOfPage >= 1 && indexOfPage <= this.symbolOffsetToEndOfPage.size()) {
            return this.symbolOffsetToEndOfPage.get(indexOfPage - 1);
        }
        int emergencyResult = 0;
        if (indexOfPage > this.symbolOffsetToEndOfPage.size()) {
            emergencyResult = this.symbolOffsetToEndOfPage.get(this.symbolOffsetToEndOfPage.size() - 1);
        }
        LOG.info((Throwable)new IllegalArgumentException("Large File Editor Subsystem] DocumentOfPagesModel.getSymbolOffsetToStartOfPage(...): indexOfPage=" + indexOfPage + " symbolOffsetToEndOfPage.size()=" + this.symbolOffsetToEndOfPage.size()));
        return emergencyResult;
    }

    public int tryGetIndexOfNeededPageInList(long needPageNumber) {
        for (int i = 0; i < this.pagesInDocument.size(); ++i) {
            if (this.pagesInDocument.get(i).getPageNumber() != needPageNumber) continue;
            return i;
        }
        return -1;
    }
}

