/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.pratt;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.pratt.MutableMarker;
import com.intellij.lang.pratt.PrattTokenType;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PrattBuilder {
    public abstract Lexer getLexer();

    public abstract void setTokenTypeRemapper(@Nullable ITokenTypeRemapper var1);

    public abstract MutableMarker mark();

    public PrattBuilder createChildBuilder(int priority, @Nullable String expectedMessage) {
        return this.createChildBuilder(priority).expecting(expectedMessage);
    }

    public PrattBuilder createChildBuilder(int priority) {
        return this.createChildBuilder().withLowestPriority(priority);
    }

    @Nullable
    public IElementType parseChildren(int priority, @Nullable String expectedMessage) {
        return this.createChildBuilder(priority, expectedMessage).parse();
    }

    protected abstract PrattBuilder createChildBuilder();

    public boolean assertToken(PrattTokenType type) {
        if (this.checkToken(type)) {
            return true;
        }
        this.error(type.getExpectedText(this));
        return false;
    }

    public boolean assertToken(IElementType type, @NotNull String errorMessage) {
        if (errorMessage == null) {
            PrattBuilder.$$$reportNull$$$0(0);
        }
        if (this.checkToken(type)) {
            return true;
        }
        this.error(errorMessage);
        return false;
    }

    public boolean checkToken(IElementType type) {
        if (this.isToken(type)) {
            this.advance();
            return true;
        }
        return false;
    }

    public abstract void advance();

    public abstract void error(@NotNull String var1);

    public boolean isEof() {
        return this.isToken(null);
    }

    public boolean isToken(@Nullable IElementType type) {
        return this.getTokenType() == type;
    }

    @Nullable
    public abstract IElementType getTokenType();

    @Nullable
    public abstract String getTokenText();

    public abstract void reduce(@NotNull IElementType var1);

    public ListIterator<IElementType> getBackResultIterator() {
        List<IElementType> resultTypes = this.getResultTypes();
        return resultTypes.listIterator(resultTypes.size());
    }

    public abstract List<IElementType> getResultTypes();

    public abstract PrattBuilder getParent();

    public abstract int getPriority();

    public abstract int getCurrentOffset();

    public abstract PrattBuilder expecting(@Nullable String var1);

    public abstract PrattBuilder withLowestPriority(int var1);

    @Nullable
    public abstract IElementType parse();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/lang/pratt/PrattBuilder", "assertToken"));
    }
}

