/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogSystemLogger;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.WhiteListGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.TestModeValidationRule;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SensitiveDataValidator {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.eventLog.validator.SensitiveDataValidator");
    private static final ConcurrentMap<String, SensitiveDataValidator> instances = ContainerUtil.newConcurrentMap();
    private final String myRecorderId;
    private final Semaphore mySemaphore;
    private final AtomicBoolean isWhiteListInitialized;
    protected final Map<String, WhiteListGroupRules> eventsValidators;
    private String myVersion;
    private final EventLogWhitelistPersistence myWhitelistPersistence;
    private final EventLogExternalSettingsService mySettingsService;

    @NotNull
    public static SensitiveDataValidator getInstance(@NotNull String recorderId) {
        if (recorderId == null) {
            SensitiveDataValidator.$$$reportNull$$$0(0);
        }
        SensitiveDataValidator sensitiveDataValidator = instances.computeIfAbsent(recorderId, id -> ApplicationManager.getApplication().isUnitTestMode() ? new BlindSensitiveDataValidator((String)id) : new SensitiveDataValidator((String)id));
        if (sensitiveDataValidator == null) {
            SensitiveDataValidator.$$$reportNull$$$0(1);
        }
        return sensitiveDataValidator;
    }

    protected SensitiveDataValidator(@NotNull String recorderId) {
        if (recorderId == null) {
            SensitiveDataValidator.$$$reportNull$$$0(2);
        }
        this.eventsValidators = ContainerUtil.newConcurrentMap();
        this.myRecorderId = recorderId;
        this.mySemaphore = new Semaphore();
        this.isWhiteListInitialized = new AtomicBoolean(false);
        this.myWhitelistPersistence = new EventLogWhitelistPersistence(recorderId);
        this.mySettingsService = new EventLogExternalSettingsService(recorderId);
        this.myVersion = this.updateValidators(this.myWhitelistPersistence.getCachedWhiteList());
        EventLogSystemLogger.logWhitelistLoad(recorderId, this.myVersion);
    }

    public String guaranteeCorrectEventId(@NotNull EventLogGroup group, @NotNull EventContext context) {
        if (group == null) {
            SensitiveDataValidator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            SensitiveDataValidator.$$$reportNull$$$0(4);
        }
        if (this.isUnreachableWhitelist()) {
            return ValidationResultType.UNREACHABLE_WHITELIST.getDescription();
        }
        if (SensitiveDataValidator.isSystemEventId(context.eventId)) {
            return context.eventId;
        }
        ValidationResultType validationResultType = this.validateEvent(group, context);
        return validationResultType == ValidationResultType.ACCEPTED ? context.eventId : validationResultType.getDescription();
    }

    public Map<String, Object> guaranteeCorrectEventData(@NotNull EventLogGroup group, @NotNull EventContext context) {
        WhiteListGroupRules whiteListRule;
        if (group == null) {
            SensitiveDataValidator.$$$reportNull$$$0(5);
        }
        if (context == null) {
            SensitiveDataValidator.$$$reportNull$$$0(6);
        }
        if (SensitiveDataValidator.isTestModeEnabled(whiteListRule = this.eventsValidators.get(group.getId()))) {
            return context.eventData;
        }
        ConcurrentMap validatedData = ContainerUtil.newConcurrentMap();
        for (Map.Entry<String, Object> entry : context.eventData.entrySet()) {
            Object entryValue;
            String key;
            ValidationResultType resultType = this.validateEventData(context, whiteListRule, key = entry.getKey(), entryValue = entry.getValue());
            validatedData.put(key, resultType == ValidationResultType.ACCEPTED ? entryValue : resultType.getDescription());
        }
        if (context.pluginInfo != null && !validatedData.containsKey("plugin") && !validatedData.containsKey("plugin_type")) {
            StatisticsUtilKt.addPluginInfoTo(context.pluginInfo, validatedData);
        }
        return validatedData;
    }

    private static boolean isTestModeEnabled(@Nullable WhiteListGroupRules rule) {
        return TestModeValidationRule.isTestModeEnabled() && rule != null && Arrays.stream(rule.getEventIdRules()).anyMatch(r -> r instanceof TestModeValidationRule);
    }

    public SensitiveDataValidator update() {
        String version2 = this.updateValidators(this.getWhiteListContent());
        if (!StringUtil.equals((CharSequence)version2, (CharSequence)this.myVersion)) {
            this.myVersion = version2;
            EventLogSystemLogger.logWhitelistUpdated(this.myRecorderId, this.myVersion);
        }
        return this;
    }

    public void reload() {
        this.updateValidators(this.myWhitelistPersistence.getCachedWhiteList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String updateValidators(@Nullable String whiteListContent) {
        if (whiteListContent != null) {
            this.mySemaphore.down();
            try {
                this.eventsValidators.clear();
                this.isWhiteListInitialized.set(false);
                FUStatisticsWhiteListGroupsService.WLGroups groups = FUStatisticsWhiteListGroupsService.parseWhiteListContent(whiteListContent);
                if (groups != null) {
                    BuildNumber buildNumber = BuildNumber.fromString((String)EventLogConfiguration.INSTANCE.getBuild());
                    Map<String, WhiteListGroupRules> result2 = groups.groups.stream().filter(group -> group.accepts(buildNumber)).collect(Collectors.toMap(group -> group.id, group -> SensitiveDataValidator.createRules(group, groups.rules)));
                    this.eventsValidators.putAll(result2);
                    this.isWhiteListInitialized.set(true);
                }
                String string = groups == null ? null : groups.version;
                return string;
            }
            finally {
                this.mySemaphore.up();
            }
        }
        return null;
    }

    private boolean isUnreachableWhitelist() {
        return !this.isWhiteListInitialized.get();
    }

    private static boolean isSystemEventId(@Nullable String eventId) {
        return "invoked".equals(eventId) || "registered".equals(eventId);
    }

    public ValidationResultType validateEvent(@NotNull EventLogGroup group, @NotNull EventContext context) {
        WhiteListGroupRules whiteListRule;
        if (group == null) {
            SensitiveDataValidator.$$$reportNull$$$0(7);
        }
        if (context == null) {
            SensitiveDataValidator.$$$reportNull$$$0(8);
        }
        if ((whiteListRule = this.eventsValidators.get(group.getId())) == null || !whiteListRule.areEventIdRulesDefined()) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        return whiteListRule.validateEventId(context);
    }

    private ValidationResultType validateEventData(@NotNull EventContext context, @Nullable WhiteListGroupRules whiteListRule, @NotNull String key, @NotNull Object entryValue) {
        if (context == null) {
            SensitiveDataValidator.$$$reportNull$$$0(9);
        }
        if (key == null) {
            SensitiveDataValidator.$$$reportNull$$$0(10);
        }
        if (entryValue == null) {
            SensitiveDataValidator.$$$reportNull$$$0(11);
        }
        if (this.isUnreachableWhitelist()) {
            return ValidationResultType.UNREACHABLE_WHITELIST;
        }
        if (whiteListRule == null) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        if (FeatureUsageData.Companion.getPlatformDataKeys().contains(key)) {
            return ValidationResultType.ACCEPTED;
        }
        return whiteListRule.validateEventData(key, entryValue, context);
    }

    @NotNull
    private static WhiteListGroupRules createRules(@NotNull FUStatisticsWhiteListGroupsService.WLGroup group, @Nullable FUStatisticsWhiteListGroupsService.WLRule globalRules) {
        if (group == null) {
            SensitiveDataValidator.$$$reportNull$$$0(12);
        }
        WhiteListGroupRules whiteListGroupRules = globalRules != null ? WhiteListGroupRules.create(group, globalRules.enums, globalRules.regexps) : WhiteListGroupRules.create(group, null, null);
        if (whiteListGroupRules == null) {
            SensitiveDataValidator.$$$reportNull$$$0(13);
        }
        return whiteListGroupRules;
    }

    protected String getWhiteListContent() {
        String content2;
        long lastModified = FUStatisticsWhiteListGroupsService.lastModifiedWhitelist(this.mySettingsService);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loading whitelist, last modified cached=" + this.myWhitelistPersistence.getLastModified() + ", last modified on the server=" + lastModified);
        }
        if ((lastModified <= 0L || lastModified > this.myWhitelistPersistence.getLastModified()) && StringUtil.isNotEmpty((String)(content2 = FUStatisticsWhiteListGroupsService.loadWhiteListFromServer(this.mySettingsService)))) {
            this.myWhitelistPersistence.cacheWhiteList(content2, lastModified);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Update local whitelist, last modified cached=" + this.myWhitelistPersistence.getLastModified());
            }
            return content2;
        }
        return this.myWhitelistPersistence.getCachedWhiteList();
    }

    public boolean shouldUpdateCache(@NotNull String gsonWhiteListContent) {
        int cachedVersion;
        if (gsonWhiteListContent == null) {
            SensitiveDataValidator.$$$reportNull$$$0(14);
        }
        return (cachedVersion = SensitiveDataValidator.getVersion(this.myWhitelistPersistence.getCachedWhiteList())) == 0 || SensitiveDataValidator.getVersion(gsonWhiteListContent) > cachedVersion;
    }

    private static int getVersion(@Nullable String whiteListContent) {
        if (whiteListContent == null) {
            return 0;
        }
        FUStatisticsWhiteListGroupsService.WLGroups groups = FUStatisticsWhiteListGroupsService.parseWhiteListContent(whiteListContent);
        if (groups == null) {
            return 0;
        }
        String version2 = groups.version;
        if (version2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(version2);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/SensitiveDataValidator";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryValue";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gsonWhiteListContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/SensitiveDataValidator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "guaranteeCorrectEventId";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "guaranteeCorrectEventData";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateEvent";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateEventData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRules";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldUpdateCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BlindSensitiveDataValidator
    extends SensitiveDataValidator {
        protected BlindSensitiveDataValidator(@NotNull String recorderId) {
            if (recorderId == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(0);
            }
            super(recorderId);
        }

        @Override
        public String guaranteeCorrectEventId(@NotNull EventLogGroup group, @NotNull EventContext context) {
            if (group == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(1);
            }
            if (context == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(2);
            }
            return context.eventId;
        }

        @Override
        public Map<String, Object> guaranteeCorrectEventData(@NotNull EventLogGroup group, @NotNull EventContext context) {
            if (group == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(3);
            }
            if (context == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(4);
            }
            return context.eventData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recorderId";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/SensitiveDataValidator$BlindSensitiveDataValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "guaranteeCorrectEventId";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "guaranteeCorrectEventData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

