/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectIntHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JpsElementPropertiesSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;

public class ProjectStructureUsageCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public String getGroupId() {
        if ("project.structure" == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(0);
        }
        return "project.structure";
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(1);
        }
        Map typeNames = JBIterable.from((Iterable)JpsModelSerializerExtension.getExtensions()).filter(o -> PluginInfoDetectorKt.getPluginInfo(o.getClass()).isDevelopedByJetBrains()).flatMap(JpsModelSerializerExtension::getModuleSourceRootPropertiesSerializers).toMap(JpsElementPropertiesSerializer::getType, JpsElementPropertiesSerializer::getTypeId);
        int contentRoots = 0;
        int sourceRoots = 0;
        int excludedRoots = 0;
        int packagePrefix = 0;
        TObjectIntHashMap types = new TObjectIntHashMap();
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            contentRoots += rootManager.getContentEntries().length;
            sourceRoots += rootManager.getSourceRoots(true).length;
            excludedRoots += rootManager.getExcludeRoots().length;
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder source : entry.getSourceFolders()) {
                    String key2;
                    if (StringUtil.isNotEmpty((String)source.getPackagePrefix())) {
                        ++packagePrefix;
                    }
                    if ((key2 = (String)typeNames.get(source.getRootType())) == null || types.increment((Object)key2)) continue;
                    types.put((Object)key2, 1);
                }
            }
        }
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        result2.add(MetricEventFactoryKt.newCounterMetric("modules.total", modules.length));
        result2.add(MetricEventFactoryKt.newCounterMetric("content.roots.total", contentRoots));
        result2.add(MetricEventFactoryKt.newCounterMetric("source.roots.total", sourceRoots));
        result2.add(MetricEventFactoryKt.newCounterMetric("excluded.roots.total", excludedRoots));
        types.forEachEntry((key, count) -> result2.add(MetricEventFactoryKt.newCounterMetric("source.root", count, new FeatureUsageData().addData("type", (String)key))));
        if (PlatformUtils.isIntelliJ()) {
            result2.add(MetricEventFactoryKt.newCounterMetric("package.prefix", packagePrefix));
        }
        HashSet<MetricEvent> hashSet = result2;
        if (hashSet == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/ProjectStructureUsageCollector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/ProjectStructureUsageCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

