/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddGroupToLocalWhitelistDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AddGroupToLocalWhitelistDialog.class);
    private JPanel myMainPanel;
    private JTextField myGroupIdTextField;
    private JBLabel myGroupIdLabel;
    private ComboBox<String> myRecorderComboBox;
    private JBLabel myRecorderLabel;
    private JPanel myAddCustomRulePanel;
    private JCheckBox myAddCustomRuleCheckBox;
    private ContextHelpLabel myContextHelpLabel;
    private final Project myProject;
    private final EditorEx myValidationRulesEditor;
    private final List<PsiFile> myTempFiles;

    protected AddGroupToLocalWhitelistDialog(@NotNull Project project) {
        if (project == null) {
            AddGroupToLocalWhitelistDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.$$$setupUI$$$();
        this.myTempFiles = new ArrayList<PsiFile>();
        this.myProject = project;
        this.myRecorderLabel.setLabelFor(this.myRecorderComboBox);
        this.myGroupIdLabel.setLabelFor((Component)this.myGroupIdTextField);
        this.myValidationRulesEditor = this.initEditor(project, this.myAddCustomRulePanel);
        this.myAddCustomRuleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                AddGroupToLocalWhitelistDialog.this.updateRulesOption();
            }
        });
        this.myAddCustomRuleCheckBox.setSelected(false);
        this.updateRulesOption();
        this.setOKButtonText("&Add");
        Disposer.register((Disposable)project, (Disposable)this.getDisposable());
        this.setTitle("Add Test Group to Local Whitelist");
        this.init();
    }

    private void updateRulesOption() {
        boolean customRules = this.myAddCustomRuleCheckBox.isSelected();
        this.myAddCustomRulePanel.setVisible(customRules);
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = AddGroupToLocalWhitelistDialog.class.getCanonicalName();
        if (string == null) {
            AddGroupToLocalWhitelistDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGroupIdTextField;
    }

    public boolean isCustomRules() {
        return this.myAddCustomRuleCheckBox.isSelected();
    }

    @NotNull
    public String getCustomRules() {
        String string = this.myValidationRulesEditor.getDocument().getText();
        if (string == null) {
            AddGroupToLocalWhitelistDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getGroupId() {
        return StringUtil.nullize((String)this.myGroupIdTextField.getText());
    }

    @Nullable
    public String getRecorderId() {
        Object item = this.myRecorderComboBox.getSelectedItem();
        return item instanceof String ? (String)item : null;
    }

    @NotNull
    private EditorEx initEditor(@NotNull Project project, @NotNull JPanel panel2) {
        if (project == null) {
            AddGroupToLocalWhitelistDialog.$$$reportNull$$$0(3);
        }
        if (panel2 == null) {
            AddGroupToLocalWhitelistDialog.$$$reportNull$$$0(4);
        }
        String templateText = "{\n  \"event_id\": [],\n  \"event_data\": {\n  }\n}";
        PsiFile file2 = AddGroupToLocalWhitelistDialog.createTempFile(project, "event-log-validation-rules", "{\n  \"event_id\": [],\n  \"event_data\": {\n  }\n}");
        assert (file2 != null);
        this.myTempFiles.add(file2);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        if (document == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)"{\n  \"event_id\": [],\n  \"event_data\": {\n  }\n}");
        }
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createEditor(document, project, file2.getVirtualFile(), false);
        editor.setFile(file2.getVirtualFile());
        editor.getSettings().setLineMarkerAreaShown(false);
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)editor.getComponent(), "Center");
        editor.getSettings().setFoldingOutlineShown(false);
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName("JSON");
        LightVirtualFile lightFile = new LightVirtualFile("Dummy.json", fileType, (CharSequence)"");
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, (VirtualFile)lightFile);
        try {
            editor.setHighlighter(highlighter);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
        EditorEx editorEx = editor;
        if (editorEx == null) {
            AddGroupToLocalWhitelistDialog.$$$reportNull$$$0(5);
        }
        return editorEx;
    }

    @Nullable
    private static PsiFile createTempFile(@NotNull Project project, @NotNull String filename, @NotNull String request) {
        if (project == null) {
            AddGroupToLocalWhitelistDialog.$$$reportNull$$$0(6);
        }
        if (filename == null) {
            AddGroupToLocalWhitelistDialog.$$$reportNull$$$0(7);
        }
        if (request == null) {
            AddGroupToLocalWhitelistDialog.$$$reportNull$$$0(8);
        }
        String fileName2 = PathUtil.makeFileName((String)filename, (String)"json");
        try {
            ThrowableComputable computable = () -> {
                Document document;
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file2 = fileService.findFile(RootType.findById((String)"scratches"), fileName2, ScratchFileService.Option.create_if_missing);
                fileService.getScratchesMapping().setMapping(file2, (Object)Language.findLanguageByID((String)"JSON"));
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
                Document document2 = document = psiFile != null ? PsiDocumentManager.getInstance((Project)project).getDocument(psiFile) : null;
                if (document == null) {
                    return null;
                }
                document.insertString(document.getTextLength(), (CharSequence)request);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                return psiFile;
            };
            return (PsiFile)WriteCommandAction.writeCommandAction((Project)project).withName("Creating temp JSON file for event log").withGlobalUndo().shouldRecordActionForActiveDocument(false).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(computable);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void createUIComponents() {
        this.myRecorderComboBox = new ComboBox();
        StatisticsEventLoggerKt.getEventLogProviders().stream().map(provider -> provider.getRecorderId()).forEach(id -> this.myRecorderComboBox.addItem(id));
        String description = "Should be used before whitelisting to test that validation rules for the group work correctly";
        this.myContextHelpLabel = ContextHelpLabel.create((String)"Should be used before whitelisting to test that validation rules for the group work correctly");
    }

    public void dispose() {
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            for (PsiFile file2 : this.myTempFiles) {
                try {
                    file2.delete();
                }
                catch (IncorrectOperationException e) {
                    LOG.warn((Throwable)e);
                }
            }
        });
        if (!this.myValidationRulesEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myValidationRulesEditor);
        }
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/actions/AddGroupToLocalWhitelistDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/actions/AddGroupToLocalWhitelistDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomRules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "initEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initEditor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        JTextField jTextField;
        JBLabel jBLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myGroupIdLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Group ID:");
        jBLabel2.setDisplayedMnemonic('G');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myGroupIdTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myRecorderLabel = jBLabel = new JBLabel();
        jBLabel.setText("Recorder:");
        jBLabel.setDisplayedMnemonic('R');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        ComboBox<String> comboBox2 = this.myRecorderComboBox;
        jPanel2.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myAddCustomRuleCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Add custom validation rules");
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ContextHelpLabel contextHelpLabel = this.myContextHelpLabel;
        jPanel3.add((Component)contextHelpLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myAddCustomRulePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        jBLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup2 = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

