/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.GcPauseWatcher;
import com.intellij.diagnostic.LoadingPhase;
import com.intellij.diagnostic.ParallelActivity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.CliResult;
import com.intellij.ide.CommandLineProcessor;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.MainRunner;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.idea.Main;
import com.intellij.idea.SplashManager;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemPropertyBean;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyBean;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.mac.MacOSApplicationProvider;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeaApplication {
    private static final String[] SAFE_JAVA_ENV_PARAMETERS = new String[]{"idea.required.plugins.id"};
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.idea.IdeaApplication");
    private static List<File> ourFilesToLoad = Collections.emptyList();

    private IdeaApplication() {
    }

    public static void initApplication(@NotNull String[] rawArgs) {
        List<IdeaPluginDescriptor> plugins2;
        if (rawArgs == null) {
            IdeaApplication.$$$reportNull$$$0(0);
        }
        Activity initAppActivity = MainRunner.startupStart.endAndStart("app initialization");
        CompletableFuture<List<IdeaPluginDescriptor>> pluginDescriptorsFuture = new CompletableFuture<List<IdeaPluginDescriptor>>();
        EventQueue.invokeLater(() -> IdeaApplication.executeInitAppInEdt(rawArgs, initAppActivity, pluginDescriptorsFuture));
        try {
            plugins2 = PluginManagerCore.getLoadedPlugins();
        }
        catch (Throwable e) {
            pluginDescriptorsFuture.completeExceptionally(e);
            return;
        }
        pluginDescriptorsFuture.complete(plugins2);
    }

    private static void executeInitAppInEdt(@NotNull String[] rawArgs, @NotNull Activity initAppActivity, @NotNull CompletableFuture<List<IdeaPluginDescriptor>> pluginDescriptorsFuture) {
        if (rawArgs == null) {
            IdeaApplication.$$$reportNull$$$0(1);
        }
        if (initAppActivity == null) {
            IdeaApplication.$$$reportNull$$$0(2);
        }
        if (pluginDescriptorsFuture == null) {
            IdeaApplication.$$$reportNull$$$0(3);
        }
        String[] args = IdeaApplication.processProgramArguments(rawArgs);
        ApplicationStarter starter2 = IdeaApplication.createAppStarter(args, pluginDescriptorsFuture);
        Activity createAppActivity = initAppActivity.startChild("create app");
        boolean headless = Main.isHeadless();
        ApplicationImpl app = new ApplicationImpl(Boolean.getBoolean("idea.is.internal"), false, headless, Main.isCommandLine(), "idea");
        createAppActivity.end();
        if (!headless) {
            IconLoader.activate();
            IconLoader.setStrictGlobally((boolean)app.isInternal());
            if (SystemInfo.isMac) {
                Activity activity = initAppActivity.startChild("mac app init");
                MacOSApplicationProvider.initApplication();
                activity.end();
            }
            app.executeOnPooledThread(() -> {
                new AsyncProcessIcon("");
                new AsyncProcessIcon.Big("");
                new AnimatedIcon.Blinking(AllIcons.Ide.FatalError);
                new AnimatedIcon.FS();
                AllIcons.Ide.Shadow.Top.getIconHeight();
            });
        }
        starter2.premain(args);
        ArrayList<Future> futures = new ArrayList<Future>();
        futures.add(IdeaApplication.registerRegistryAndMessageBusAndComponent(pluginDescriptorsFuture, app));
        if (!headless) {
            if (SystemInfo.isMac) {
                futures.add(ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    Activity activity = ParallelActivity.PREPARE_APP_INIT.start("mac touchbar");
                    TouchBarsManager.isTouchBarAvailable();
                    activity.end();
                }));
            }
            SplashManager.showLicenseeInfoOnSplash(LOG);
        }
        Activity placeOnEventQueueActivity = initAppActivity.startChild("place on event queue");
        EventQueue.invokeLater(() -> {
            placeOnEventQueueActivity.end();
            StartupUtil.installExceptionHandler();
            initAppActivity.end();
            try {
                Activity activity = StartUpMeasurer.start((String)"wait plugin initialization");
                for (Future future2 : futures) {
                    future2.get();
                }
                activity.end();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
            app.load(null, SplashManager.getProgressIndicator());
            if (!headless) {
                IdeaApplication.addActivateAndWindowsCliListeners(app);
            }
            ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> starter2.main(args));
            if (PluginManagerCore.isRunningFromSources()) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> AppUIUtil.updateWindowIcon(JOptionPane.getRootFrame()));
            }
        });
    }

    @NotNull
    private static CompletableFuture<Void> registerRegistryAndMessageBusAndComponent(@NotNull CompletableFuture<List<IdeaPluginDescriptor>> pluginDescriptorsFuture, @NotNull ApplicationImpl app) {
        if (pluginDescriptorsFuture == null) {
            IdeaApplication.$$$reportNull$$$0(4);
        }
        if (app == null) {
            IdeaApplication.$$$reportNull$$$0(5);
        }
        CompletionStage completionStage = pluginDescriptorsFuture.thenCompose(pluginDescriptors -> {
            CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
                Activity sysActivity = ParallelActivity.PREPARE_APP_INIT.start("init system properties");
                SystemPropertyBean.initSystemProperties();
                sysActivity.end();
                Activity activity = ParallelActivity.PREPARE_APP_INIT.start("add registry keys");
                RegistryKeyBean.addKeysFromPlugins();
                activity.end();
                Activity busActivity = ParallelActivity.PREPARE_APP_INIT.start("add message bus listeners");
                ApplicationImpl.registerMessageBusListeners(app, pluginDescriptors, false);
                busActivity.end();
            }, AppExecutorUtil.getAppExecutorService());
            Activity activity = ParallelActivity.PREPARE_APP_INIT.start("app component registration");
            ((ApplicationImpl)ApplicationManager.getApplication()).registerComponents((List<? extends IdeaPluginDescriptor>)pluginDescriptors);
            activity.end();
            return future2;
        });
        if (completionStage == null) {
            IdeaApplication.$$$reportNull$$$0(6);
        }
        return completionStage;
    }

    private static void addActivateAndWindowsCliListeners(@NotNull ApplicationImpl app) {
        if (app == null) {
            IdeaApplication.$$$reportNull$$$0(7);
        }
        StartupUtil.addExternalInstanceListener(args -> {
            AtomicReference ref = new AtomicReference();
            app.invokeAndWait(() -> {
                JFrame frame;
                LOG.info("ApplicationImpl.externalInstanceListener invocation");
                String currentDirectory = args.isEmpty() ? null : (String)args.get(0);
                List<String> realArgs = args.isEmpty() ? args : args.subList(1, args.size());
                Pair<Project, Future<? extends CliResult>> projectAndFuture = CommandLineProcessor.processExternalCommandLine(realArgs, currentDirectory);
                ref.set(projectAndFuture.getSecond());
                Project project = (Project)projectAndFuture.getFirst();
                JFrame jFrame = frame = project == null ? WindowManager.getInstance().findVisibleFrame() : (JFrame)WindowManager.getInstance().getIdeFrame(project);
                if (frame != null) {
                    if (frame instanceof IdeFrame) {
                        AppIcon.getInstance().requestFocus((IdeFrame)frame);
                    } else {
                        frame.toFront();
                        DialogEarthquakeShaker.shake((Window)frame);
                    }
                }
            });
            return (Future)ref.get();
        });
        MainRunner.LISTENER = (currentDirectory, args) -> {
            List<String> argsList = Arrays.asList(args);
            LOG.info("Received external Windows command line: current directory " + currentDirectory + ", command line " + argsList);
            if (argsList.isEmpty()) {
                return 0;
            }
            ModalityState state = app.getDefaultModalityState();
            for (ApplicationStarter starter2 : ApplicationStarter.EP_NAME.getExtensionList()) {
                if (!starter2.canProcessExternalCommandLine() || !argsList.get(0).equals(starter2.getCommandName()) || !starter2.allowAnyModalityState()) continue;
                state = app.getAnyModalityState();
            }
            AtomicReference ref = new AtomicReference();
            app.invokeAndWait(() -> ref.set(CommandLineProcessor.processExternalCommandLine(argsList, currentDirectory).getSecond()), state);
            CliResult result2 = CliResult.getOrWrapFailure((Future)((Future)ref.get()), (int)1);
            return result2.getReturnCode();
        };
    }

    @NotNull
    private static ApplicationStarter createAppStarter(@NotNull String[] args, @NotNull Future<?> pluginsLoaded) {
        if (args == null) {
            IdeaApplication.$$$reportNull$$$0(8);
        }
        if (pluginsLoaded == null) {
            IdeaApplication.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(!ApplicationManagerEx.isAppLoaded());
        LoadingPhase.setCurrentPhase((LoadingPhase)LoadingPhase.SPLASH);
        StartupUtil.patchSystem(LOG);
        if (args.length <= 0) {
            IdeStarter ideStarter = new IdeStarter();
            if (ideStarter == null) {
                IdeaApplication.$$$reportNull$$$0(10);
            }
            return ideStarter;
        }
        try {
            pluginsLoaded.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CompletionException(e);
        }
        ApplicationStarter starter2 = IdeaApplication.findStarter(args[0]);
        if (starter2 != null) {
            if (Main.isHeadless() && !starter2.isHeadless()) {
                Main.showMessage((String)"Startup Error", (String)"Application cannot start in headless mode", (boolean)true);
                System.exit(1);
            }
            ApplicationStarter applicationStarter = starter2;
            if (applicationStarter == null) {
                IdeaApplication.$$$reportNull$$$0(11);
            }
            return applicationStarter;
        }
        IdeStarter ideStarter = new IdeStarter();
        if (ideStarter == null) {
            IdeaApplication.$$$reportNull$$$0(12);
        }
        return ideStarter;
    }

    @NotNull
    public static String[] processProgramArguments(@NotNull String[] args) {
        if (args == null) {
            IdeaApplication.$$$reportNull$$$0(13);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        List<String> safeKeys = Arrays.asList(SAFE_JAVA_ENV_PARAMETERS);
        for (String arg : args) {
            String[] keyValue;
            if (arg.startsWith("-D") && (keyValue = arg.substring(2).split("=")).length == 2 && safeKeys.contains(keyValue[0])) {
                System.setProperty(keyValue[0], keyValue[1]);
                continue;
            }
            if ("nosplash".equals(arg)) continue;
            arguments.add(arg);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(arguments);
        if (stringArray == null) {
            IdeaApplication.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    @Nullable
    public static ApplicationStarter findStarter(@Nullable String key) {
        ApplicationStarter starter2;
        Iterator iterator = ApplicationStarter.EP_NAME.getIterable(null).iterator();
        while (iterator.hasNext() && (starter2 = (ApplicationStarter)iterator.next()) != null) {
            if (!Comparing.equal((String)starter2.getCommandName(), (String)key)) continue;
            return starter2;
        }
        return null;
    }

    public static void openFilesOnLoading(@NotNull List<File> files2) {
        if (files2 == null) {
            IdeaApplication.$$$reportNull$$$0(15);
        }
        ourFilesToLoad = files2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawArgs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initAppActivity";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptorsFuture";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/IdeaApplication";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsLoaded";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/IdeaApplication";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "registerRegistryAndMessageBusAndComponent";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppStarter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processProgramArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initApplication";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeInitAppInEdt";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerRegistryAndMessageBusAndComponent";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addActivateAndWindowsCliListeners";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAppStarter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processProgramArguments";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "openFilesOnLoading";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IdeStarter
    implements ApplicationStarter {
        public boolean isHeadless() {
            return false;
        }

        public String getCommandName() {
            return null;
        }

        public boolean canProcessExternalCommandLine() {
            return true;
        }

        @NotNull
        public Future<? extends CliResult> processExternalCommandLineAsync(@NotNull String[] args, @Nullable String currentDirectory) {
            if (args == null) {
                IdeStarter.$$$reportNull$$$0(0);
            }
            LOG.info("Request to open in " + currentDirectory + " with parameters: " + StringUtil.join((String[])args, (String)","));
            if (args.length > 0) {
                VirtualFile virtualFile;
                String filename = args[0];
                File file2 = new File(currentDirectory, filename);
                if (file2.exists() && (virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2)) != null) {
                    int line2 = -1;
                    if (args.length > 2 && "--line".equals(args[1])) {
                        try {
                            line2 = Integer.parseInt(args[2]);
                        }
                        catch (NumberFormatException ex) {
                            LOG.error("Wrong line number:" + args[2]);
                        }
                    }
                    EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class);
                    PlatformProjectOpenProcessor.doOpenProject(virtualFile, null, line2, null, options);
                }
                Future future2 = CliResult.error((int)1, (String)("Can't find file:" + file2));
                if (future2 == null) {
                    IdeStarter.$$$reportNull$$$0(1);
                }
                return future2;
            }
            Future future3 = CliResult.ok();
            if (future3 == null) {
                IdeStarter.$$$reportNull$$$0(2);
            }
            return future3;
        }

        private static Project loadProjectFromExternalCommandLine(@NotNull List<String> commandLineArgs) {
            if (commandLineArgs == null) {
                IdeStarter.$$$reportNull$$$0(3);
            }
            Project project = null;
            if (!commandLineArgs.isEmpty() && commandLineArgs.get(0) != null) {
                LOG.info("IdeaApplication.loadProject");
                String currentDirectory = System.getenv("IDEA_INITIAL_DIRECTORY");
                LOG.info("IDEA_INITIAL_DIRECTORY: " + currentDirectory);
                project = (Project)CommandLineProcessor.processExternalCommandLine(commandLineArgs, currentDirectory).getFirst();
            }
            return project;
        }

        public void main(String[] args) {
            boolean willOpenProject;
            Activity frameInitActivity = StartUpMeasurer.start((String)"frame initialization");
            GcPauseWatcher.Companion.getInstance();
            Activity setWindowManagerActivity = frameInitActivity.startChild("set window manager");
            Application app = ApplicationManager.getApplication();
            WindowManagerImpl windowManager = (WindowManagerImpl)WindowManager.getInstance();
            IdeEventQueue.getInstance().setWindowManager(windowManager);
            setWindowManagerActivity.end();
            List<String> commandLineArgs = args == null || args.length == 0 ? Collections.emptyList() : Arrays.asList(args);
            Activity appFrameCreatedActivity = frameInitActivity.startChild("call appFrameCreated");
            AppLifecycleListener lifecyclePublisher = (AppLifecycleListener)app.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC);
            lifecyclePublisher.appFrameCreated(commandLineArgs);
            appFrameCreatedActivity.end();
            boolean bl = willOpenProject = !commandLineArgs.isEmpty() || RecentProjectsManager.getInstance().willReopenProjectOnStart();
            if (Registry.is((String)"ide.popup.enablePopupType")) {
                System.setProperty("jbre.popupwindow.settype", "true");
            }
            LoadingPhase.setCurrentPhase((LoadingPhase)LoadingPhase.FRAME_SHOWN);
            if (!willOpenProject || JetBrainsProtocolHandler.getCommand() != null) {
                WelcomeFrame.showNow(SplashManager.getHideTask());
                lifecyclePublisher.welcomeScreenDisplayed();
            }
            frameInitActivity.end();
            app.executeOnPooledThread(() -> LifecycleUsageTriggerCollector.onIdeStart());
            TransactionGuard.submitTransaction((Disposable)app, () -> {
                Project project = !ourFilesToLoad.isEmpty() ? ProjectUtil.tryOpenFileList(null, ourFilesToLoad, "MacMenu") : (!commandLineArgs.isEmpty() ? IdeStarter.loadProjectFromExternalCommandLine(commandLineArgs) : null);
                ((AppLifecycleListener)app.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).appStarting(project);
                if (project == null && !JetBrainsProtocolHandler.appStartedWithCommand()) {
                    RecentProjectsManager.getInstance().reopenLastProjectOnStart();
                }
                EventQueue.invokeLater(PluginManager::reportPluginError);
            });
            if (!app.isHeadlessEnvironment()) {
                IdeStarter.postOpenUiTasks(app);
            }
        }

        private static void postOpenUiTasks(@NotNull Application app) {
            if (app == null) {
                IdeStarter.$$$reportNull$$$0(4);
            }
            if (SystemInfo.isMac) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    TouchBarsManager.onApplicationInitialized();
                    if (TouchBarsManager.isTouchBarAvailable()) {
                        CustomActionsSchema.addSettingsGroup("TouchBar", "Touch Bar");
                    }
                });
            }
            app.invokeLater(() -> {
                Activity updateSystemDockActivity = StartUpMeasurer.start((String)"system dock menu");
                SystemDock.updateMenu();
                updateSystemDockActivity.end();
            });
            app.invokeLater(() -> {
                GeneralSettings generalSettings = GeneralSettings.getInstance();
                generalSettings.addPropertyChangeListener("supportScreenReaders", (Disposable)app, e -> ScreenReader.setActive((boolean)((Boolean)e.getNewValue())));
                ScreenReader.setActive((boolean)generalSettings.isSupportScreenReaders());
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/idea/IdeaApplication$IdeStarter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLineArgs";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "app";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/idea/IdeaApplication$IdeStarter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processExternalCommandLineAsync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "processExternalCommandLineAsync";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "loadProjectFromExternalCommandLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "postOpenUiTasks";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

