/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeEditorPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeConfigurable
extends NamedConfigurable<NamedScope> {
    private final Disposable myDisposable = Disposer.newDisposable();
    private NamedScope myScope;
    private ScopeEditorPanel myPanel;
    private String myPackageSet;
    private final JCheckBox mySharedCheckbox;
    private final JLabel mySharedContextHelp;
    private boolean myShareScope;
    private final Project myProject;
    private Icon myIcon;

    public ScopeConfigurable(NamedScope scope, boolean shareScope, Project project, Runnable updateTree) {
        super(true, updateTree);
        this.myScope = scope;
        this.myShareScope = shareScope;
        this.myProject = project;
        this.mySharedCheckbox = new JCheckBox(IdeBundle.message((String)"share.scope.checkbox.title", (Object[])new Object[0]), shareScope);
        this.mySharedContextHelp = new JLabel(AllIcons.General.ContextHelp);
        this.mySharedContextHelp.setToolTipText(IdeBundle.message((String)"share.scope.context.help", (Object[])new Object[0]));
        this.mySharedContextHelp.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
        this.myPanel = new ScopeEditorPanel(project, this.getHolder());
        this.myIcon = this.getHolder(this.myShareScope).getIcon();
        this.mySharedCheckbox.addActionListener(e -> {
            this.myIcon = this.getHolder().getIcon();
            this.myPanel.setHolder(this.getHolder());
        });
    }

    public void setDisplayName(String name) {
        if (Comparing.strEqual((String)this.myScope.getName(), (String)name)) {
            return;
        }
        PackageSet packageSet = this.myScope.getValue();
        this.myScope = new NamedScope(name, this.myIcon, packageSet != null ? packageSet.createCopy() : null);
    }

    public NamedScope getEditableObject() {
        return new NamedScope(this.myScope.getName(), this.myIcon, this.myPanel.getCurrentScope());
    }

    public String getBannerSlogan() {
        return IdeBundle.message((String)"scope.banner.text", (Object[])new Object[]{this.myScope.getName()});
    }

    public String getDisplayName() {
        return this.myScope.getName();
    }

    @NotNull
    public NamedScopesHolder getHolder() {
        NamedScopesHolder namedScopesHolder = this.getHolder(this.mySharedCheckbox.isSelected());
        if (namedScopesHolder == null) {
            ScopeConfigurable.$$$reportNull$$$0(0);
        }
        return namedScopesHolder;
    }

    @NotNull
    private NamedScopesHolder getHolder(boolean local) {
        Object object = local ? DependencyValidationManager.getInstance((Project)this.myProject) : NamedScopeManager.getInstance((Project)this.myProject);
        if (object == null) {
            ScopeConfigurable.$$$reportNull$$$0(1);
        }
        return object;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "project.scopes";
    }

    @Nullable
    protected JComponent createTopRightComponent() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add("West", this.mySharedCheckbox);
        panel2.add("East", this.mySharedContextHelp);
        return panel2;
    }

    public JComponent createOptionsPanel() {
        JPanel panel2 = this.myPanel.getPanel();
        panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)10, (int)10));
        return panel2;
    }

    public boolean isModified() {
        if (this.mySharedCheckbox.isSelected() != this.myShareScope) {
            return true;
        }
        PackageSet currentScope = this.myPanel.getCurrentScope();
        return !Comparing.strEqual((String)this.myPackageSet, (String)(currentScope != null ? currentScope.getText() : null));
    }

    public void apply() throws ConfigurationException {
        try {
            this.myPanel.apply();
            PackageSet packageSet = this.myPanel.getCurrentScope();
            this.myScope = new NamedScope(this.myScope.getName(), this.myIcon, packageSet);
            this.myPackageSet = packageSet != null ? packageSet.getText() : null;
            this.myShareScope = this.mySharedCheckbox.isSelected();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void reset() {
        this.mySharedCheckbox.setSelected(this.myShareScope);
        this.myPanel.reset(this.myScope.getValue(), null);
        PackageSet packageSet = this.myScope.getValue();
        this.myPackageSet = packageSet != null ? packageSet.getText() : null;
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            this.myPanel.cancelCurrentProgress();
            this.myPanel.clearCaches();
            Disposer.dispose((Disposable)this.myDisposable);
            this.myPanel = null;
        }
    }

    public void cancelCurrentProgress() {
        if (this.myPanel != null) {
            this.myPanel.cancelCurrentProgress();
        }
    }

    public NamedScope getScope() {
        return this.myScope;
    }

    public void restoreCanceledProgress() {
        if (this.myPanel != null) {
            this.myPanel.restoreCanceledProgress();
        }
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return this.myIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/scopeChooser/ScopeConfigurable", "getHolder"));
    }
}

