/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class PlatformModuleRendererFactory
extends ModuleRendererFactory {
    @Override
    public DefaultListCellRenderer getModuleRenderer() {
        return new PlatformModuleRenderer();
    }

    @Override
    public boolean rendersLocationString() {
        return true;
    }

    public static class PlatformModuleRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String containerText;
            ItemPresentation presentation;
            Component component = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
            String text2 = "";
            if (value instanceof NavigationItem && (presentation = ((NavigationItem)value).getPresentation()) != null && !StringUtil.isEmpty((String)(containerText = presentation.getLocationString()))) {
                text2 = " " + containerText;
            }
            this.setText(text2);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.setHorizontalTextPosition(2);
            this.setBackground(isSelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
            this.setForeground(isSelected ? UIUtil.getListSelectionForeground() : UIUtil.getInactiveTextColor());
            return component;
        }
    }
}

