/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.util.TreeChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeClassChooserDialog<T extends PsiNamedElement>
extends DialogWrapper
implements TreeChooser<T> {
    @NotNull
    private final Project myProject;
    private final GlobalSearchScope myScope;
    @NotNull
    private final TreeChooser.Filter<T> myClassFilter;
    private final Class<T> myElementClass;
    @Nullable
    private final T myBaseClass;
    private final boolean myIsShowMembers;
    private final boolean myIsShowLibraryContents;
    private Tree myTree;
    private T mySelectedClass;
    private BaseProjectTreeBuilder myBuilder;
    private TabbedPaneWrapper myTabbedPane;
    private ChooseByNamePanel myGotoByNamePanel;
    private T myInitialClass;

    public AbstractTreeClassChooserDialog(String title, Project project, Class<T> elementClass) {
        this(title, project, elementClass, null);
    }

    public AbstractTreeClassChooserDialog(String title, Project project, Class<T> elementClass, @Nullable T initialClass) {
        this(title, project, GlobalSearchScope.projectScope((Project)project), elementClass, null, initialClass);
    }

    public AbstractTreeClassChooserDialog(String title, @NotNull Project project, GlobalSearchScope scope, @NotNull Class<T> elementClass, @Nullable TreeChooser.Filter<T> classFilter, @Nullable T initialClass) {
        if (project == null) {
            AbstractTreeClassChooserDialog.$$$reportNull$$$0(0);
        }
        if (elementClass == null) {
            AbstractTreeClassChooserDialog.$$$reportNull$$$0(1);
        }
        this(title, project, scope, (Class<Object>)elementClass, (TreeChooser.Filter<Object>)classFilter, null, initialClass, false, true);
    }

    public AbstractTreeClassChooserDialog(String title, @NotNull Project project, GlobalSearchScope scope, @NotNull Class<T> elementClass, @Nullable TreeChooser.Filter<T> classFilter, @Nullable T baseClass, @Nullable T initialClass, boolean isShowMembers, boolean isShowLibraryContents) {
        if (project == null) {
            AbstractTreeClassChooserDialog.$$$reportNull$$$0(2);
        }
        if (elementClass == null) {
            AbstractTreeClassChooserDialog.$$$reportNull$$$0(3);
        }
        super(project, true);
        this.myScope = scope;
        this.myElementClass = elementClass;
        this.myClassFilter = classFilter == null ? this.allFilter() : classFilter;
        this.myBaseClass = baseClass;
        this.myInitialClass = initialClass;
        this.myIsShowMembers = isShowMembers;
        this.myIsShowLibraryContents = isShowLibraryContents;
        this.setTitle(title);
        this.myProject = project;
        this.init();
        if (initialClass != null) {
            this.select(initialClass);
        }
        this.handleSelectionChanged();
    }

    private TreeChooser.Filter<T> allFilter() {
        return __ -> true;
    }

    protected JComponent createCenterPanel() {
        DefaultTreeModel model2 = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model2);
        AbstractProjectTreeStructure treeStructure = new AbstractProjectTreeStructure(this.myProject){

            public boolean isFlattenPackages() {
                return false;
            }

            @Override
            public boolean isShowMembers() {
                return AbstractTreeClassChooserDialog.this.myIsShowMembers;
            }

            public boolean isHideEmptyMiddlePackages() {
                return true;
            }

            public boolean isAbbreviatePackageNames() {
                return false;
            }

            public boolean isShowLibraryContents() {
                return AbstractTreeClassChooserDialog.this.myIsShowLibraryContents;
            }

            public boolean isShowModules() {
                return false;
            }
        };
        this.myBuilder = new ProjectTreeBuilder(this.myProject, (JTree)this.myTree, model2, (Comparator<NodeDescriptor>)AlphaComparator.INSTANCE, treeStructure);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.expandRow(0);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
        scrollPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 13);
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    AbstractTreeClassChooserDialog.this.doOKAction();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                TreePath path = AbstractTreeClassChooserDialog.this.myTree.getPathForLocation(event.getX(), event.getY());
                if (path != null && AbstractTreeClassChooserDialog.this.myTree.isPathSelected(path)) {
                    AbstractTreeClassChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addTreeSelectionListener(__ -> this.handleSelectionChanged());
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTabbedPane = new TabbedPaneWrapper(this.getDisposable());
        final JPanel dummyPanel = new JPanel(new BorderLayout());
        String name = null;
        this.myGotoByNamePanel = new ChooseByNamePanel(this.myProject, this.createChooseByNameModel(), name, this.myScope.isSearchInLibraries(), (PsiElement)this.getContext()){

            @Override
            protected void showTextFieldPanel() {
            }

            @Override
            protected void close(boolean isOk) {
                super.close(isOk);
                if (isOk) {
                    AbstractTreeClassChooserDialog.this.doOKAction();
                } else {
                    AbstractTreeClassChooserDialog.this.doCancelAction();
                }
            }

            @Override
            @NotNull
            protected Set<Object> filter(@NotNull Set<Object> elements2) {
                if (elements2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                Set set = AbstractTreeClassChooserDialog.this.doFilter(elements2);
                if (set == null) {
                    4.$$$reportNull$$$0(1);
                }
                return set;
            }

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback2, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback2, modalityState, allowMultipleSelection);
                dummyPanel.add((Component)AbstractTreeClassChooserDialog.this.myGotoByNamePanel.getPanel(), "Center");
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)IdeFocusTraversalPolicy.getPreferredFocusedComponent(AbstractTreeClassChooserDialog.this.myGotoByNamePanel.getPanel()), true));
            }

            @Override
            protected void showList() {
                super.showList();
                if (AbstractTreeClassChooserDialog.this.myInitialClass != null && this.myList.getModel().getSize() > 0) {
                    this.myList.setSelectedValue(AbstractTreeClassChooserDialog.this.myInitialClass, true);
                    AbstractTreeClassChooserDialog.this.myInitialClass = null;
                }
            }

            @Override
            protected void chosenElementMightChange() {
                AbstractTreeClassChooserDialog.this.handleSelectionChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elements";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/AbstractTreeClassChooserDialog$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/AbstractTreeClassChooserDialog$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "filter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "filter";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myGotoByNamePanel);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.search.by.name", (Object[])new Object[0]), dummyPanel);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.project", (Object[])new Object[0]), scrollPane);
        this.myGotoByNamePanel.invoke(new MyCallback(), this.getModalityState(), false);
        this.myTabbedPane.addChangeListener(__ -> this.handleSelectionChanged());
        return this.myTabbedPane.getComponent();
    }

    private Set<Object> doFilter(Set<Object> elements2) {
        LinkedHashSet<Object> result2 = new LinkedHashSet<Object>();
        for (Object o : elements2) {
            if (!this.myElementClass.isInstance(o) || !this.getFilter().isAccepted((Object)((PsiNamedElement)o))) continue;
            result2.add(o);
        }
        return result2;
    }

    protected ChooseByNameModel createChooseByNameModel() {
        if (this.myBaseClass == null) {
            return new MyGotoClassModel(this.myProject, this);
        }
        BaseClassInheritorsProvider<T> inheritorsProvider = this.getInheritorsProvider(this.myBaseClass);
        if (inheritorsProvider != null) {
            return new SubclassGotoClassModel<T>(this.myProject, this, inheritorsProvider);
        }
        throw new IllegalStateException("inheritors provider is null");
    }

    @Nullable
    protected BaseClassInheritorsProvider<T> getInheritorsProvider(@NotNull T baseClass) {
        if (baseClass == null) {
            AbstractTreeClassChooserDialog.$$$reportNull$$$0(4);
        }
        return null;
    }

    private void handleSelectionChanged() {
        this.mySelectedClass = this.calcSelectedClass();
        this.setOKActionEnabled(this.mySelectedClass != null && this.myClassFilter.isAccepted(this.mySelectedClass));
    }

    public T getSelected() {
        return this.getExitCode() == 0 ? (T)this.mySelectedClass : null;
    }

    public void select(@NotNull T aClass) {
        if (aClass == null) {
            AbstractTreeClassChooserDialog.$$$reportNull$$$0(5);
        }
        this.selectElementInTree((PsiElement)aClass);
    }

    public void selectDirectory(@NotNull PsiDirectory directory) {
        if (directory == null) {
            AbstractTreeClassChooserDialog.$$$reportNull$$$0(6);
        }
        this.selectElementInTree((PsiElement)directory);
    }

    public void showDialog() {
        this.show();
    }

    public void showPopup() {
        ChooseByNamePopup popup2 = ChooseByNamePopup.createPopup(this.myProject, this.createChooseByNameModel(), this.getContext());
        popup2.invoke(new ChooseByNamePopupComponent.Callback(){

            public void elementChosen(Object element) {
                AbstractTreeClassChooserDialog.this.mySelectedClass = (PsiNamedElement)element;
                ((Navigatable)element).navigate(true);
            }
        }, this.getModalityState(), true);
    }

    private T getContext() {
        return this.myBaseClass != null ? this.myBaseClass : this.myInitialClass;
    }

    private void selectElementInTree(@NotNull PsiElement element) {
        if (element == null) {
            AbstractTreeClassChooserDialog.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myBuilder == null) {
                return;
            }
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            this.myBuilder.selectAsync(element, vFile, false);
        }, this.getModalityState());
    }

    @NotNull
    private ModalityState getModalityState() {
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.getRootPane());
        if (modalityState == null) {
            AbstractTreeClassChooserDialog.$$$reportNull$$$0(8);
        }
        return modalityState;
    }

    @Nullable
    protected T calcSelectedClass() {
        if (this.getTabbedPane().getSelectedIndex() == 0) {
            return (T)((PsiNamedElement)this.getGotoByNamePanel().getChosenElement());
        }
        TreePath path = this.getTree().getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return this.getSelectedFromTreeUserObject(node);
    }

    protected abstract T getSelectedFromTreeUserObject(DefaultMutableTreeNode var1);

    public void dispose() {
        if (this.myBuilder != null) {
            Disposer.dispose((Disposable)this.myBuilder);
            this.myBuilder = null;
        }
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.TreeClassChooserDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGotoByNamePanel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractTreeClassChooserDialog.$$$reportNull$$$0(9);
        }
        return project;
    }

    protected GlobalSearchScope getScope() {
        return this.myScope;
    }

    @NotNull
    protected TreeChooser.Filter<T> getFilter() {
        TreeChooser.Filter<T> filter = this.myClassFilter;
        if (filter == null) {
            AbstractTreeClassChooserDialog.$$$reportNull$$$0(10);
        }
        return filter;
    }

    T getBaseClass() {
        return this.myBaseClass;
    }

    T getInitialClass() {
        return this.myInitialClass;
    }

    protected TabbedPaneWrapper getTabbedPane() {
        return this.myTabbedPane;
    }

    protected Tree getTree() {
        return this.myTree;
    }

    protected ChooseByNamePanel getGotoByNamePanel() {
        return this.myGotoByNamePanel;
    }

    @NotNull
    protected abstract List<T> getClassesByName(String var1, boolean var2, String var3, GlobalSearchScope var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/AbstractTreeClassChooserDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/AbstractTreeClassChooserDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInheritorsProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectElementInTree";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCallback
    extends ChooseByNamePopupComponent.Callback {
        private MyCallback() {
        }

        public void elementChosen(Object element) {
            AbstractTreeClassChooserDialog.this.mySelectedClass = (PsiNamedElement)element;
            AbstractTreeClassChooserDialog.this.close(0);
        }
    }

    private static class SubclassGotoClassModel<T extends PsiNamedElement>
    extends MyGotoClassModel<T> {
        private final BaseClassInheritorsProvider<T> myInheritorsProvider;
        private boolean myFastMode;

        SubclassGotoClassModel(@NotNull Project project, @NotNull AbstractTreeClassChooserDialog<T> treeClassChooserDialog, @NotNull BaseClassInheritorsProvider<T> inheritorsProvider) {
            if (project == null) {
                SubclassGotoClassModel.$$$reportNull$$$0(0);
            }
            if (treeClassChooserDialog == null) {
                SubclassGotoClassModel.$$$reportNull$$$0(1);
            }
            if (inheritorsProvider == null) {
                SubclassGotoClassModel.$$$reportNull$$$0(2);
            }
            super(project, treeClassChooserDialog);
            this.myFastMode = true;
            this.myInheritorsProvider = inheritorsProvider;
            assert (this.myInheritorsProvider.getBaseClass() != null);
        }

        @Override
        public void processNames(final @NotNull Processor<? super String> nameProcessor, @NotNull FindSymbolParameters parameters) {
            if (nameProcessor == null) {
                SubclassGotoClassModel.$$$reportNull$$$0(3);
            }
            if (parameters == null) {
                SubclassGotoClassModel.$$$reportNull$$$0(4);
            }
            if (this.myFastMode) {
                this.myFastMode = this.myInheritorsProvider.searchForInheritorsOfBaseClass().forEach(new Processor<T>(){
                    private final long start = System.currentTimeMillis();

                    public boolean process(T aClass) {
                        if (System.currentTimeMillis() - this.start > 500L && !ApplicationManager.getApplication().isUnitTestMode()) {
                            return false;
                        }
                        if (this.getTreeClassChooserDialog().getFilter().isAccepted(aClass) && aClass.getName() != null) {
                            nameProcessor.process((Object)aClass.getName());
                        }
                        return true;
                    }
                });
            }
            if (!this.myFastMode) {
                for (String name : this.myInheritorsProvider.getNames()) {
                    nameProcessor.process((Object)name);
                }
            }
        }

        @Override
        protected boolean isAccepted(T aClass) {
            if (this.myFastMode) {
                return this.getTreeClassChooserDialog().getFilter().isAccepted(aClass);
            }
            return (aClass == this.getTreeClassChooserDialog().getBaseClass() || this.myInheritorsProvider.isInheritorOfBaseClass(aClass)) && this.getTreeClassChooserDialog().getFilter().isAccepted(aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeClassChooserDialog";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inheritorsProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameProcessor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/AbstractTreeClassChooserDialog$SubclassGotoClassModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processNames";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class BaseClassInheritorsProvider<T> {
        private final T myBaseClass;
        private final GlobalSearchScope myScope;

        public BaseClassInheritorsProvider(T baseClass, GlobalSearchScope scope) {
            this.myBaseClass = baseClass;
            this.myScope = scope;
        }

        public T getBaseClass() {
            return this.myBaseClass;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }

        @NotNull
        protected abstract Query<T> searchForInheritors(T var1, GlobalSearchScope var2, boolean var3);

        protected abstract boolean isInheritor(T var1, T var2, boolean var3);

        protected abstract String[] getNames();

        Query<T> searchForInheritorsOfBaseClass() {
            return this.searchForInheritors(this.myBaseClass, this.myScope, true);
        }

        boolean isInheritorOfBaseClass(T aClass) {
            return this.isInheritor(aClass, this.myBaseClass, true);
        }
    }

    protected static class MyGotoClassModel<T extends PsiNamedElement>
    extends GotoClassModel2 {
        private final AbstractTreeClassChooserDialog<T> myTreeClassChooserDialog;

        public MyGotoClassModel(@NotNull Project project, AbstractTreeClassChooserDialog<T> treeClassChooserDialog) {
            if (project == null) {
                MyGotoClassModel.$$$reportNull$$$0(0);
            }
            super(project);
            this.myTreeClassChooserDialog = treeClassChooserDialog;
        }

        AbstractTreeClassChooserDialog<T> getTreeClassChooserDialog() {
            return this.myTreeClassChooserDialog;
        }

        @Override
        @NotNull
        public Object[] getElementsByName(@NotNull String name, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator canceled) {
            if (name == null) {
                MyGotoClassModel.$$$reportNull$$$0(1);
            }
            if (parameters == null) {
                MyGotoClassModel.$$$reportNull$$$0(2);
            }
            if (canceled == null) {
                MyGotoClassModel.$$$reportNull$$$0(3);
            }
            String patternName = parameters.getLocalPatternName();
            List<T> classes = this.myTreeClassChooserDialog.getClassesByName(name, parameters.isSearchInLibraries(), patternName, this.myTreeClassChooserDialog.getScope());
            if (classes.isEmpty()) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    MyGotoClassModel.$$$reportNull$$$0(4);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            if (classes.size() == 1) {
                Object[] objectArray = this.isAccepted((PsiNamedElement)classes.get(0)) ? ArrayUtil.toObjectArray(classes) : ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                if (objectArray == null) {
                    MyGotoClassModel.$$$reportNull$$$0(5);
                }
                return objectArray;
            }
            HashSet<String> qNames = new HashSet<String>();
            ArrayList<PsiNamedElement> list2 = new ArrayList<PsiNamedElement>(classes.size());
            for (PsiNamedElement aClass : classes) {
                if (!qNames.add(this.getFullName(aClass)) || !this.isAccepted(aClass)) continue;
                list2.add(aClass);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(list2);
            if (objectArray == null) {
                MyGotoClassModel.$$$reportNull$$$0(6);
            }
            return objectArray;
        }

        @Override
        @Nullable
        public String getPromptText() {
            return null;
        }

        protected boolean isAccepted(T aClass) {
            return this.myTreeClassChooserDialog.getFilter().isAccepted(aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "canceled";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/AbstractTreeClassChooserDialog$MyGotoClassModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/AbstractTreeClassChooserDialog$MyGotoClassModel";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsByName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementsByName";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

