/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import org.jetbrains.annotations.Nullable;

public class PorterStemmerUtil {
    private PorterStemmerUtil() {
    }

    @Nullable
    public static String stem(String str) {
        int strLen = str.length();
        if (strLen > 0) {
            int lastNonLetter = -1;
            for (int i = 0; i < strLen; ++i) {
                char c2 = str.charAt(i);
                if (Character.isDigit(c2) || c2 == '-' || c2 == '_') {
                    lastNonLetter = i;
                    continue;
                }
                if (Character.isLetter(c2)) continue;
                return null;
            }
            if (++lastNonLetter > 0 && lastNonLetter < strLen) {
                return str.substring(0, lastNonLetter) + PorterStemmerUtil.stemString(str.substring(lastNonLetter));
            }
            return PorterStemmerUtil.stemString(str);
        }
        return null;
    }

    private static String stemString(String str) {
        str = PorterStemmerUtil.step1a(str);
        str = PorterStemmerUtil.step1b(str);
        str = PorterStemmerUtil.step1c(str);
        str = PorterStemmerUtil.step2(str);
        str = PorterStemmerUtil.step3(str);
        str = PorterStemmerUtil.step4(str);
        str = PorterStemmerUtil.step5a(str);
        str = PorterStemmerUtil.step5b(str);
        return str;
    }

    private static String step1a(String str) {
        if (str.endsWith("sses")) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ies")) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ss")) {
            return str;
        }
        if (str.endsWith("s")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static String step1b(String str) {
        if (str.endsWith("eed")) {
            if (PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
                return str.substring(0, str.length() - 1);
            }
            return str;
        }
        if (str.endsWith("ed") && PorterStemmerUtil.containsVowel(str.substring(0, str.length() - 2))) {
            return PorterStemmerUtil.step1b2(str.substring(0, str.length() - 2));
        }
        if (str.endsWith("ing") && PorterStemmerUtil.containsVowel(str.substring(0, str.length() - 3))) {
            return PorterStemmerUtil.step1b2(str.substring(0, str.length() - 3));
        }
        return str;
    }

    private static String step1b2(String str) {
        if (str.endsWith("at") || str.endsWith("bl") || str.endsWith("iz")) {
            return str + "e";
        }
        if (PorterStemmerUtil.endsWithDoubleConsonent(str) && !str.endsWith("l") && !str.endsWith("s") && !str.endsWith("z")) {
            return str.substring(0, str.length() - 1);
        }
        if (PorterStemmerUtil.stringMeasure(str) == 1 && PorterStemmerUtil.endsWithCVC(str)) {
            return str + "e";
        }
        return str;
    }

    private static String step1c(String str) {
        if (str.endsWith("y") && PorterStemmerUtil.containsVowel(str.substring(0, str.length() - 1))) {
            return str.substring(0, str.length() - 1) + "i";
        }
        return str;
    }

    private static String step2(String str) {
        if (str.endsWith("ational") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return str.substring(0, str.length() - 5) + "e";
        }
        if (str.endsWith("tional") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("enci") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("anci") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 1)) > 0) {
            return str.substring(0, str.length() - 1) + "e";
        }
        if (str.endsWith("izer") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 1)) > 0) {
            return str.substring(0, str.length() - 1);
        }
        if (str.endsWith("abli") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 1)) > 0) {
            return str.substring(0, str.length() - 1) + "e";
        }
        if (str.endsWith("alli") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("entli") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("eli") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ousli") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ization") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return str.substring(0, str.length() - 5) + "e";
        }
        if (str.endsWith("ation") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3) + "e";
        }
        if (str.endsWith("ator") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2) + "e";
        }
        if (str.endsWith("alism") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iveness") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("fulness") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ousness") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("aliti") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iviti") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3) + "e";
        }
        if (str.endsWith("biliti") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return str.substring(0, str.length() - 5) + "le";
        }
        return str;
    }

    private static String step3(String str) {
        if (str.endsWith("icate") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ative") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return str.substring(0, str.length() - 5);
        }
        if (str.endsWith("alize") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iciti") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ical") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ful") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ness") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        return str;
    }

    private static String step4(String str) {
        if (str.endsWith("al") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ance") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ence") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("er") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ic") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("able") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ible") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ant") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ement") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 5)) > 1) {
            return str.substring(0, str.length() - 5);
        }
        if (str.endsWith("ment") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ent") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if ((str.endsWith("sion") || str.endsWith("tion")) && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ou") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ism") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ate") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iti") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ous") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ive") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ize") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        return str;
    }

    private static String step5a(String str) {
        if (str.endsWith("e") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 1)) > 1) {
            return str.substring(0, str.length() - 1);
        }
        if (str.endsWith("e") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 1)) == 1 && !PorterStemmerUtil.endsWithCVC(str.substring(0, str.length() - 1))) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static String step5b(String str) {
        if (str.endsWith("l") && PorterStemmerUtil.stringMeasure(str.substring(0, str.length() - 1)) > 1 && PorterStemmerUtil.endsWithDoubleConsonent(str)) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static boolean containsVowel(String str) {
        char[] strchars;
        for (char strchar : strchars = str.toCharArray()) {
            if (!PorterStemmerUtil.isVowel(strchar)) continue;
            return true;
        }
        return str.indexOf(121) > -1;
    }

    private static boolean isVowel(char c2) {
        return c2 == 'a' || c2 == 'e' || c2 == 'i' || c2 == 'o' || c2 == 'u';
    }

    private static boolean endsWithDoubleConsonent(String str) {
        char c2 = str.charAt(str.length() - 1);
        return str.length() > 1 && c2 == str.charAt(str.length() - 2) && !PorterStemmerUtil.containsVowel(str.substring(str.length() - 2));
    }

    private static int stringMeasure(String str) {
        char[] strchars;
        int count = 0;
        boolean vowelSeen = false;
        for (char strchar : strchars = str.toCharArray()) {
            if (PorterStemmerUtil.isVowel(strchar)) {
                vowelSeen = true;
                continue;
            }
            if (!vowelSeen) continue;
            ++count;
            vowelSeen = false;
        }
        return count;
    }

    private static boolean endsWithCVC(String str) {
        if (str.length() < 3) {
            return false;
        }
        char c2 = str.charAt(str.length() - 1);
        char v = str.charAt(str.length() - 2);
        char c22 = str.charAt(str.length() - 3);
        if (c2 == 'w' || c2 == 'x' || c2 == 'y') {
            return false;
        }
        if (PorterStemmerUtil.isVowel(c2)) {
            return false;
        }
        if (!PorterStemmerUtil.isVowel(v)) {
            return false;
        }
        return !PorterStemmerUtil.isVowel(c22);
    }
}

