/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.ide.ui.laf.darcula.ui.DarculaJBPopupComboPopup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Path2D;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class WinIntelliJComboBoxUI
extends DarculaComboBoxUI {
    private static final String HOVER_PROPERTY = "JComboBox.mouseHover";
    private static final String PRESSED_PROPERTY = "JComboBox.mousePressed";
    private static final Border DEFAULT_EDITOR_BORDER = JBUI.Borders.empty((int)1, (int)0);
    private static final JBDimension ARROW_BUTTON_SIZE = new JBDimension(21, 24);
    private MouseListener mouseListener;
    private MouseListener buttonReleaseListener;
    private MouseListener buttonHoverListener;
    private MouseListener editorHoverListener;

    public static ComponentUI createUI(JComponent c2) {
        return new WinIntelliJComboBoxUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (!this.comboBox.isEditable()) {
            this.mouseListener = new ComboBoxMouseListener();
            this.comboBox.addMouseListener(this.mouseListener);
        }
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.mouseListener);
    }

    @Override
    protected PropertyChangeListener createPropertyListener() {
        return e -> {
            if ("enabled".equals(e.getPropertyName())) {
                EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
                if (etf != null) {
                    etf.setBackground(this.getComboBackground(true));
                }
            } else if ("editable".equals(e.getPropertyName())) {
                if (e.getNewValue() == Boolean.TRUE) {
                    this.comboBox.removeMouseListener(this.mouseListener);
                } else {
                    this.comboBox.addMouseListener(this.mouseListener);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c2) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            boolean applyAlpha;
            Container parent;
            Rectangle r = new Rectangle(c2.getSize());
            if (c2.isOpaque() && (parent = c2.getParent()) != null) {
                g2.setColor(DarculaUIUtil.isTableCellEditor(c2) && this.editor != null ? this.editor.getBackground() : parent.getBackground());
                g2.fill(r);
            }
            boolean isOpaque = this.editor != null && this.editor.isOpaque();
            g2.setColor(this.getComboBackground(isOpaque));
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)(DarculaUIUtil.isTableCellEditor(c2) ? 1 : 2)));
            boolean bl = applyAlpha = !this.comboBox.isEnabled() && (!isOpaque || !this.comboBox.isEditable());
            if (applyAlpha) {
                float alpha = this.comboBox.isEditable() ? 0.35f : 0.47f;
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
            }
            g2.fill(r);
            if (!this.comboBox.isEditable()) {
                this.hasFocus = this.comboBox.hasFocus();
                this.paintCurrentValue(g2, this.rectangleForCurrentValue(), this.hasFocus);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        int w = this.comboBox.getWidth();
        int h = this.comboBox.getHeight();
        Insets i = this.comboBox.getInsets();
        int buttonWidth = h;
        if (this.arrowButton != null) {
            buttonWidth = this.comboBox.getComponentOrientation().isLeftToRight() ? this.arrowButton.getWidth() - i.right : this.arrowButton.getWidth() - i.left;
        }
        Rectangle rect = this.comboBox.getComponentOrientation().isLeftToRight() ? new Rectangle(i.left, i.top, w - (i.left + i.right + buttonWidth), h - (i.top + i.bottom)) : new Rectangle(i.left + buttonWidth, i.top, w - (i.left + i.right + buttonWidth), h - (i.top + i.bottom));
        JBInsets.removeFrom((Rectangle)rect, (Insets)this.padding);
        rect.width = rect.width + (this.comboBox.isEditable() ? 0 : this.padding.right);
        return rect;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds2, boolean hasFocus) {
        boolean changeOpaque;
        ListCellRenderer<Object> renderer2 = this.comboBox.getRenderer();
        Component c2 = renderer2.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        c2.setFont(this.comboBox.getFont());
        c2.setForeground(this.comboBox.isEnabled() ? UIManager.getColor("Label.foreground") : UIManager.getColor("Label.disabledForeground"));
        Rectangle r = new Rectangle(bounds2);
        JComponent jc = (JComponent)c2;
        jc.setBorder(DEFAULT_EDITOR_BORDER);
        JBInsets.removeFrom((Rectangle)r, (Insets)jc.getInsets());
        boolean bl = changeOpaque = DarculaUIUtil.isTableCellEditor(this.comboBox) && c2.isOpaque();
        if (changeOpaque) {
            jc.setOpaque(false);
        } else if (c2.isOpaque()) {
            c2.setBackground(this.getComboBackground(true));
        }
        this.currentValuePane.paintComponent(g, c2, this.comboBox, r.x, r.y, r.width, r.height, c2 instanceof JPanel);
        if (changeOpaque) {
            jc.setOpaque(true);
        }
    }

    private Color getComboBackground(boolean opaque) {
        if (this.comboBox != null) {
            Color bg = this.comboBox.getBackground();
            Object value = this.comboBox.getSelectedItem();
            if (this.comboBox.isEnabled() && this.comboBox.isEditable() && this.editor != null) {
                return UIManager.getColor("TextField.background");
            }
            if (!this.comboBox.isEnabled()) {
                return opaque ? UIManager.getColor("Button.background.opaque") : UIManager.getColor("Button.background");
            }
            if (this.comboBox.isBackgroundSet() && !(bg instanceof UIResource)) {
                return bg;
            }
            if (value instanceof ColoredItem) {
                return ((ColoredItem)value).getColor();
            }
            if (!this.comboBox.isEditable()) {
                if (this.isPressed() || this.popup.isVisible()) {
                    return UIManager.getColor("Button.intellij.native.pressedBackgroundColor");
                }
                if (this.isHover()) {
                    return UIManager.getColor("Button.intellij.native.focusedBackgroundColor");
                }
            }
        }
        return UIManager.getColor("Button.background");
    }

    @Override
    protected JButton createArrowButton() {
        BasicArrowButton button2 = new BasicArrowButton(5){

            @Override
            public Dimension getPreferredSize() {
                return ARROW_BUTTON_SIZE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics g) {
                if (!UIUtil.isUnderWin10LookAndFeel()) {
                    return;
                }
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    Rectangle outerRect = new Rectangle(this.getSize());
                    JBInsets.removeFrom((Rectangle)outerRect, (Insets)JBUI.insets((int)1));
                    int bw = 1;
                    Object op = WinIntelliJComboBoxUI.this.comboBox.getClientProperty("JComponent.outline");
                    if (op != null) {
                        DarculaUIUtil.Outline.valueOf(op.toString()).setGraphicsColor(g2, WinIntelliJComboBoxUI.this.hasFocus);
                        bw = DarculaUIUtil.isTableCellEditor(WinIntelliJComboBoxUI.this.comboBox) ? 1 : 2;
                    }
                    Rectangle innerRect = new Rectangle(outerRect);
                    JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)bw));
                    if (WinIntelliJComboBoxUI.this.comboBox.isEditable() && WinIntelliJComboBoxUI.this.comboBox.isEnabled()) {
                        if (WinIntelliJComboBoxUI.this.isPressed() || WinIntelliJComboBoxUI.this.popup.isVisible()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.pressedBackgroundColor"));
                        } else if (WinIntelliJComboBoxUI.this.comboBox.hasFocus() || WinIntelliJComboBoxUI.this.isHover()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.focusedBackgroundColor"));
                        } else {
                            g2.setColor(WinIntelliJComboBoxUI.this.getComboBackground(false));
                        }
                        g2.fill(innerRect);
                    }
                    if (WinIntelliJComboBoxUI.this.comboBox.isEditable() && WinIntelliJComboBoxUI.this.comboBox.isEnabled()) {
                        Path2D.Float border = new Path2D.Float(0);
                        border.append(outerRect, false);
                        border.append(innerRect, false);
                        if (this.getModel().isPressed() || WinIntelliJComboBoxUI.this.popup.isVisible()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.pressedBorderColor"));
                            g2.fill(border);
                        } else if (WinIntelliJComboBoxUI.this.comboBox.hasFocus() || WinIntelliJComboBoxUI.this.isHover()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.focusedBorderColor"));
                            g2.fill(border);
                        }
                    }
                    Icon icon = WinIntelliJComboBoxUI.getArrowIcon(this);
                    int x = JBUIScale.scale((int)5);
                    int y = (this.getHeight() - icon.getIconHeight()) / 2;
                    icon.paintIcon(this, g2, x, y);
                }
                finally {
                    g2.dispose();
                }
            }
        };
        button2.setOpaque(false);
        this.buttonReleaseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!WinIntelliJComboBoxUI.this.comboBox.isEditable()) {
                    WinIntelliJComboBoxUI.this.comboBox.repaint();
                }
            }
        };
        this.buttonHoverListener = new DarculaUIUtil.MouseHoverPropertyTrigger(this.comboBox, HOVER_PROPERTY);
        button2.addMouseListener(this.buttonHoverListener);
        button2.addMouseListener(this.buttonReleaseListener);
        return button2;
    }

    public static Icon getArrowIcon(@NotNull JComponent c2) {
        if (c2 == null) {
            WinIntelliJComboBoxUI.$$$reportNull$$$0(0);
        }
        return LafIconLookup.getIcon((String)"comboDropTriangle", (boolean)false, (boolean)false, (boolean)c2.isEnabled());
    }

    @Override
    public void unconfigureArrowButton() {
        super.unconfigureArrowButton();
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.buttonReleaseListener);
            this.arrowButton.removeMouseListener(this.buttonHoverListener);
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        BasicComboBoxEditor.UIResource comboBoxEditor = new BasicComboBoxEditor.UIResource(){

            @Override
            protected JTextField createEditorComponent() {
                return new JTextField(){

                    @Override
                    public void setText(String s) {
                        if (this.getText().equals(s)) {
                            return;
                        }
                        super.setText(s);
                    }

                    @Override
                    public Color getBackground() {
                        return WinIntelliJComboBoxUI.this.getComboBackground(false);
                    }

                    @Override
                    public Border getBorder() {
                        return DEFAULT_EDITOR_BORDER;
                    }

                    @Override
                    public Insets getInsets() {
                        return DEFAULT_EDITOR_BORDER.getBorderInsets(this);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension size = super.getPreferredSize();
                        return new Dimension(size.width, Math.max(JBUIScale.scale((int)18), size.height));
                    }
                };
            }
        };
        return comboBoxEditor;
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        this.installEditorKeyListener(this.comboBox.getEditor());
        if (this.editor instanceof JComponent) {
            JComponent jEditor = (JComponent)this.editor;
            jEditor.setBorder(DEFAULT_EDITOR_BORDER);
            this.editorHoverListener = new DarculaUIUtil.MouseHoverPropertyTrigger(this.comboBox, HOVER_PROPERTY);
            if (this.editor instanceof JTextComponent) {
                this.editor.addMouseListener(this.editorHoverListener);
            } else {
                EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
                if (etf != null) {
                    etf.addMouseListener(this.editorHoverListener);
                    etf.setBackground(this.getComboBackground(true));
                }
            }
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.editor instanceof JTextComponent) {
            if (this.editorHoverListener != null) {
                this.editor.removeMouseListener(this.editorHoverListener);
            }
        } else {
            EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
            if (etf != null && this.editorHoverListener != null) {
                etf.removeMouseListener(this.editorHoverListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        if (this.comboBox == null || this.arrowButton == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            this.checkFocus();
            Rectangle r = new Rectangle(x, y, width, height);
            boolean isCellRenderer = DarculaUIUtil.isTableCellEditor(c2);
            int bw = 1;
            if (this.comboBox.isEnabled()) {
                Object op = this.comboBox.getClientProperty("JComponent.outline");
                if (op != null) {
                    DarculaUIUtil.Outline.valueOf(op.toString()).setGraphicsColor(g2, this.hasFocus);
                    bw = isCellRenderer ? 1 : 2;
                } else if (this.comboBox.isEditable()) {
                    if (this.hasFocus) {
                        g2.setColor(UIManager.getColor("TextField.focusedBorderColor"));
                    } else {
                        g2.setColor(UIManager.getColor(this.isEditorHover() ? "TextField.hoverBorderColor" : "TextField.borderColor"));
                    }
                } else if (this.isPressed() || this.popup.isVisible()) {
                    g2.setColor(UIManager.getColor("Button.intellij.native.pressedBorderColor"));
                } else if (this.isHover() || this.hasFocus) {
                    g2.setColor(UIManager.getColor("Button.intellij.native.focusedBorderColor"));
                } else {
                    g2.setColor(UIManager.getColor("Button.intellij.native.borderColor"));
                }
                if (!isCellRenderer) {
                    JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
                }
            } else {
                g2.setColor(UIManager.getColor("Button.intellij.native.borderColor"));
                float alpha = this.comboBox.isEditable() ? 0.35f : 0.47f;
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Path2D.Float border = new Path2D.Float(0);
            border.append(r, false);
            Rectangle innerRect = new Rectangle(r);
            JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)bw));
            border.append(innerRect, false);
            g2.fill(border);
        }
        finally {
            g2.dispose();
        }
    }

    private boolean isHover() {
        return this.comboBox != null && this.comboBox.getClientProperty(HOVER_PROPERTY) == Boolean.TRUE || this.arrowButton != null && this.arrowButton.getClientProperty(HOVER_PROPERTY) == Boolean.TRUE;
    }

    private boolean isEditorHover() {
        JComponent ec = (JComponent)this.comboBox.getEditor().getEditorComponent();
        EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
        Editor editor = etf != null ? etf.getEditor() : null;
        return this.arrowButton != null && this.arrowButton.getClientProperty(HOVER_PROPERTY) == Boolean.TRUE || ec != null && ec.getClientProperty(HOVER_PROPERTY) == Boolean.TRUE || editor != null && editor.getContentComponent().getClientProperty(HOVER_PROPERTY) == Boolean.TRUE;
    }

    private boolean isPressed() {
        return this.comboBox != null && this.comboBox.getClientProperty(PRESSED_PROPERTY) == Boolean.TRUE || this.arrowButton != null && this.arrowButton.getModel().isPressed();
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return JBUI.insets((int)(DarculaUIUtil.isTableCellEditor(c2) ? 0 : 1)).asUIResource();
    }

    @Override
    protected Dimension getSizeWithButton(Dimension size, Dimension editorSize) {
        ARROW_BUTTON_SIZE.update();
        Insets i = this.getInsets();
        int editorHeight = editorSize != null ? editorSize.height + i.top + i.bottom + this.padding.top + this.padding.bottom : 0;
        int editorWidth = editorSize != null ? editorSize.width + i.left + this.padding.left + this.padding.right : 0;
        editorWidth = Math.max(editorWidth, DarculaUIUtil.MINIMUM_WIDTH.get() + i.left);
        int width = size != null ? size.width : 0;
        int height = size != null ? size.height : 0;
        width = Math.max(editorWidth + WinIntelliJComboBoxUI.ARROW_BUTTON_SIZE.width, width + this.padding.left);
        height = Math.max(WinIntelliJComboBoxUI.ARROW_BUTTON_SIZE.height, Math.max(editorHeight, height));
        return new Dimension(width, height);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container parent) {
                JComboBox cb = (JComboBox)parent;
                if (WinIntelliJComboBoxUI.this.arrowButton != null) {
                    if (cb.getComponentOrientation().isLeftToRight()) {
                        WinIntelliJComboBoxUI.this.arrowButton.setBounds(cb.getWidth() - ARROW_BUTTON_SIZE.width, 0, ARROW_BUTTON_SIZE.width, cb.getHeight());
                    } else {
                        WinIntelliJComboBoxUI.this.arrowButton.setBounds(0, 0, ARROW_BUTTON_SIZE.width, cb.getHeight());
                    }
                }
                WinIntelliJComboBoxUI.this.layoutEditor();
            }
        };
    }

    @Override
    protected ComboPopup createPopup() {
        if (this.comboBox.getClientProperty("ComboBox.jbPopup") != null) {
            return new DarculaJBPopupComboPopup<Object>(this.comboBox){

                @Override
                protected void configureList(@NotNull JList<Object> list2) {
                    if (list2 == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    super.configureList(list2);
                    list2.setBackground(UIManager.getColor("TextField.background"));
                }

                @Override
                protected void customizeListRendererComponent(JComponent component) {
                    super.customizeListRendererComponent(component);
                    component.setBorder((Border)(this.getList().getComponentOrientation().isLeftToRight() ? JBUI.Borders.empty((int)0, (int)5, (int)0, (int)1) : JBUI.Borders.empty((int)0, (int)1, (int)0, (int)5)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/ui/laf/intellij/WinIntelliJComboBoxUI$5", "configureList"));
                }
            };
        }
        return new DarculaComboBoxUI.CustomComboPopup(this.comboBox){

            @Override
            protected void configurePopup() {
                super.configurePopup();
                this.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        comboBox.repaint();
                    }
                });
                this.setBorder(UIManager.getBorder("PopupMenu.border"));
            }

            @Override
            protected void configureList() {
                super.configureList();
                this.list.setBackground(UIManager.getColor("TextField.background"));
            }

            @Override
            protected void customizeListRendererComponent(JComponent component) {
                super.customizeListRendererComponent(component);
                component.setBorder((Border)(this.list.getComponentOrientation().isLeftToRight() ? JBUI.Borders.empty((int)0, (int)5, (int)0, (int)1) : JBUI.Borders.empty((int)0, (int)1, (int)0, (int)5)));
            }

            @Override
            public void show(Component invoker, int x, int y) {
                int i = DarculaUIUtil.isTableCellEditor(this.comboBox) ? 0 : 1;
                int yOffset = JBUIScale.scale((int)i);
                super.show(invoker, x, y - yOffset);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ide/ui/laf/intellij/WinIntelliJComboBoxUI", "getArrowIcon"));
    }

    private class ComboBoxMouseListener
    extends MouseAdapter {
        private ComboBoxMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.setPressedProperty(true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.setPressedProperty(false);
        }

        private void setPressedProperty(boolean isPressed) {
            if (!WinIntelliJComboBoxUI.this.comboBox.isEditable()) {
                WinIntelliJComboBoxUI.this.comboBox.putClientProperty(WinIntelliJComboBoxUI.PRESSED_PROPERTY, isPressed);
                WinIntelliJComboBoxUI.this.comboBox.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setHoverProperty(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setHoverProperty(false);
        }

        private void setHoverProperty(boolean isHover) {
            WinIntelliJComboBoxUI.this.comboBox.putClientProperty(WinIntelliJComboBoxUI.HOVER_PROPERTY, isHover);
            WinIntelliJComboBoxUI.this.comboBox.repaint();
        }
    }
}

