/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ScreenAreaTracker {
    private static final Collection<ScreenAreaConsumer> ourAreaConsumers = new LinkedHashSet<ScreenAreaConsumer>();

    public static boolean register(final @NotNull ScreenAreaConsumer consumer) {
        if (consumer == null) {
            ScreenAreaTracker.$$$reportNull$$$0(0);
        }
        if (!Registry.is((String)"ide.use.screen.area.tracker", (boolean)false)) {
            return true;
        }
        if (!Disposer.isDisposed((Disposable)consumer) && ourAreaConsumers.add(consumer)) {
            Disposer.register((Disposable)consumer, (Disposable)new Disposable(){

                public void dispose() {
                    ourAreaConsumers.remove(consumer);
                }
            });
            return true;
        }
        return false;
    }

    public static boolean canRectangleBeUsed(@NotNull Component parent, @NotNull Rectangle desiredScreenBounds, @Nullable ScreenAreaConsumer excludedConsumer) {
        if (parent == null) {
            ScreenAreaTracker.$$$reportNull$$$0(1);
        }
        if (desiredScreenBounds == null) {
            ScreenAreaTracker.$$$reportNull$$$0(2);
        }
        if (!Registry.is((String)"ide.use.screen.area.tracker", (boolean)false)) {
            return true;
        }
        Window window = UIUtil.getWindow((Component)parent);
        if (window != null) {
            for (ScreenAreaConsumer consumer : ourAreaConsumers) {
                Rectangle area;
                if (consumer == excludedConsumer || window != UIUtil.getWindow((Component)consumer.getUnderlyingAreaOwner()) || !(area = consumer.getConsumedScreenBounds()).intersects(desiredScreenBounds)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desiredScreenBounds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/ui/ScreenAreaTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canRectangleBeUsed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ScreenAreaConsumer
    extends Disposable {
        @NotNull
        public Rectangle getConsumedScreenBounds();

        public Component getUnderlyingAreaOwner();
    }
}

