/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.ide.todo.FileTree;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoNodeVisitor;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class TodoTreeBuilder
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.todo.TodoTreeBuilder");
    public static final Comparator<NodeDescriptor> NODE_DESCRIPTOR_COMPARATOR = Comparator.comparingInt(NodeDescriptor::getWeight).thenComparingInt(NodeDescriptor::getIndex);
    protected final Project myProject;
    protected final FileTree myFileTree;
    protected final HashSet<VirtualFile> myDirtyFileSet;
    protected final Map<VirtualFile, EditorHighlighter> myFile2Highlighter;
    protected final PsiTodoSearchHelper mySearchHelper;
    private final JTree myTree;
    private boolean myUpdatable;
    private final MyFileStatusListener myFileStatusListener;
    private TodoTreeStructure myTreeStructure;
    private StructureTreeModel myModel;
    private boolean myDisposed;

    TodoTreeBuilder(JTree tree, Project project) {
        this.myTree = tree;
        this.myProject = project;
        this.myFileTree = new FileTree();
        this.myDirtyFileSet = new HashSet();
        this.myFile2Highlighter = ContainerUtil.createConcurrentSoftValueMap();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        this.mySearchHelper = PsiTodoSearchHelper.SERVICE.getInstance((Project)this.myProject);
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiTreeChangeListener());
        this.myFileStatusListener = new MyFileStatusListener();
    }

    public StructureTreeModel getModel() {
        return this.myModel;
    }

    public void setModel(StructureTreeModel model2) {
        this.myModel = model2;
    }

    public final void init() {
        this.myTreeStructure = this.createTreeStructure();
        this.myTreeStructure.setTreeBuilder(this);
        try {
            this.rebuildCache();
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener((FileStatusListener)this.myFileStatusListener);
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public final void dispose() {
        this.myDisposed = true;
        FileStatusManager.getInstance((Project)this.myProject).removeFileStatusListener((FileStatusListener)this.myFileStatusListener);
    }

    final boolean isUpdatable() {
        return this.myUpdatable;
    }

    final void setUpdatable(boolean updatable) {
        if (this.myUpdatable != updatable) {
            this.myUpdatable = updatable;
            if (updatable) {
                DumbService.getInstance((Project)this.myProject).runWhenSmart(this::updateTree);
            }
        }
    }

    @NotNull
    protected abstract TodoTreeStructure createTreeStructure();

    public final TodoTreeStructure getTodoTreeStructure() {
        return this.myTreeStructure;
    }

    public Iterator<PsiFile> getAllFiles() {
        final Iterator<VirtualFile> iterator = this.myFileTree.getFileIterator();
        return new Iterator<PsiFile>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            @Nullable
            public PsiFile next() {
                VirtualFile vFile = (VirtualFile)iterator.next();
                if (vFile == null || !vFile.isValid()) {
                    return null;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)TodoTreeBuilder.this.myProject).findFile(vFile);
                if (psiFile == null || !psiFile.isValid()) {
                    return null;
                }
                return psiFile;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException();
            }
        };
    }

    public Iterator<PsiFile> getFiles(PsiDirectory psiDirectory) {
        return this.getFiles(psiDirectory, true);
    }

    public Iterator<PsiFile> getFiles(PsiDirectory psiDirectory, boolean skip) {
        List<VirtualFile> files2 = this.myFileTree.getFiles(psiDirectory.getVirtualFile());
        ArrayList<PsiFile> psiFileList = new ArrayList<PsiFile>(files2.size());
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file2 : files2) {
            PsiDirectory directory;
            PsiFile psiFile;
            boolean isInContent;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiDirectory);
            if (module != null && !(isInContent = ModuleRootManager.getInstance((Module)module).getFileIndex().isInContent(file2)) || !file2.isValid() || (psiFile = psiManager.findFile(file2)) == null || (directory = psiFile.getContainingDirectory()) != null && skip && TodoTreeHelper.getInstance(this.myProject).skipDirectory(directory)) continue;
            psiFileList.add(psiFile);
        }
        return psiFileList.iterator();
    }

    public Iterator<PsiFile> getFilesUnderDirectory(PsiDirectory psiDirectory) {
        List<VirtualFile> files2 = this.myFileTree.getFilesUnderDirectory(psiDirectory.getVirtualFile());
        ArrayList<PsiFile> psiFileList = new ArrayList<PsiFile>(files2.size());
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file2 : files2) {
            PsiFile psiFile;
            boolean isInContent;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiDirectory);
            if (module != null && !(isInContent = ModuleRootManager.getInstance((Module)module).getFileIndex().isInContent(file2)) || !file2.isValid() || (psiFile = psiManager.findFile(file2)) == null) continue;
            psiFileList.add(psiFile);
        }
        return psiFileList.iterator();
    }

    public Iterator<PsiFile> getFiles(Module module) {
        VirtualFile[] contentRoots;
        if (module.isDisposed()) {
            return Collections.emptyIterator();
        }
        ArrayList<PsiFile> psiFileList = new ArrayList<PsiFile>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (VirtualFile virtualFile : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            List<VirtualFile> files2 = this.myFileTree.getFiles(virtualFile);
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            for (VirtualFile file2 : files2) {
                PsiFile psiFile;
                if (fileIndex.getModuleForFile(file2) != module || !file2.isValid() || (psiFile = psiManager.findFile(file2)) == null) continue;
                psiFileList.add(psiFile);
            }
        }
        return psiFileList.iterator();
    }

    private boolean canContainTodoItems(PsiFile psiFile) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VirtualFile vFile = psiFile.getVirtualFile();
        return this.myFileTree.contains(vFile) || this.myDirtyFileSet.contains(vFile);
    }

    private void markFileAsDirty(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            TodoTreeBuilder.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile != null && !(vFile instanceof LightVirtualFile)) {
            this.myDirtyFileSet.add(vFile);
        }
    }

    void rebuildCache() {
        HashSet files2 = new HashSet();
        this.collectFiles((Processor<? super VirtualFile>)((Processor)virtualFile -> {
            files2.add(virtualFile);
            return true;
        }));
        this.rebuildCache(files2);
    }

    void collectFiles(Processor<? super VirtualFile> collector) {
        PsiFile[] psiFiles;
        TodoTreeStructure treeStructure = this.getTodoTreeStructure();
        for (PsiFile psiFile : psiFiles = this.mySearchHelper.findFilesWithTodoItems()) {
            if (this.mySearchHelper.getTodoItemsCount(psiFile) <= 0 || !treeStructure.accept(psiFile)) continue;
            collector.process((Object)psiFile.getVirtualFile());
        }
    }

    void rebuildCache(@NotNull Set<? extends VirtualFile> files2) {
        if (files2 == null) {
            TodoTreeBuilder.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myFileTree.clear();
        this.myDirtyFileSet.clear();
        this.myFile2Highlighter.clear();
        for (VirtualFile virtualFile : files2) {
            this.myFileTree.add(virtualFile);
        }
        this.getTodoTreeStructure().validateCache();
    }

    private void validateCache() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TodoTreeStructure treeStructure = this.getTodoTreeStructure();
        Iterator<VirtualFile> i = this.myDirtyFileSet.iterator();
        while (i.hasNext()) {
            PsiFile psiFile;
            VirtualFile file2 = i.next();
            PsiFile psiFile2 = psiFile = file2.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(file2) : null;
            if (psiFile == null || !treeStructure.accept(psiFile)) {
                if (this.myFileTree.contains(file2)) {
                    this.myFileTree.removeFile(file2);
                    this.myFile2Highlighter.remove(file2);
                }
            } else {
                this.myFileTree.removeFile(file2);
                this.myFileTree.add(file2);
                EditorHighlighter highlighter = this.myFile2Highlighter.get(file2);
                if (highlighter != null) {
                    highlighter.setText(PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile).getCharsSequence());
                }
            }
            i.remove();
        }
        LOG.assertTrue(this.myDirtyFileSet.isEmpty());
    }

    protected boolean isAutoExpandNode(NodeDescriptor descriptor2) {
        return this.getTodoTreeStructure().isAutoExpandNode(descriptor2);
    }

    public TodoItemNode getFirstPointerForElement(@Nullable Object element) {
        if (element instanceof TodoItemNode) {
            return (TodoItemNode)element;
        }
        if (element == null) {
            return null;
        }
        Object[] children2 = this.getTodoTreeStructure().getChildElements(element);
        if (children2.length == 0) {
            return null;
        }
        Object firstChild = children2[0];
        if (firstChild instanceof TodoItemNode) {
            return (TodoItemNode)firstChild;
        }
        return this.getFirstPointerForElement(firstChild);
    }

    public TodoItemNode getLastPointerForElement(Object element) {
        if (element instanceof TodoItemNode) {
            return (TodoItemNode)element;
        }
        Object[] children2 = this.getTodoTreeStructure().getChildElements(element);
        if (children2.length == 0) {
            return null;
        }
        Object firstChild = children2[children2.length - 1];
        if (firstChild instanceof TodoItemNode) {
            return (TodoItemNode)firstChild;
        }
        return this.getLastPointerForElement(firstChild);
    }

    public final Promise<?> updateTree() {
        if (this.myUpdatable) {
            return this.myModel.getInvoker().runOrInvokeLater(() -> DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> {
                if (!this.myDirtyFileSet.isEmpty()) {
                    this.validateCache();
                    this.getTodoTreeStructure().validateCache();
                }
                this.myModel.invalidate();
            }));
        }
        return Promises.resolvedPromise();
    }

    public void select(Object obj) {
        TodoNodeVisitor visitor = TodoTreeBuilder.getVisitorFor(obj);
        if (visitor == null) {
            TreeUtil.promiseSelectFirst((JTree)this.myTree);
        } else {
            TreeUtil.promiseSelect((JTree)this.myTree, (TreeVisitor)visitor).onError(error -> TreeUtil.promiseSelectFirst((JTree)this.myTree));
        }
    }

    private static TodoNodeVisitor getVisitorFor(Object obj) {
        if (obj instanceof TodoItemNode) {
            SmartTodoItemPointer value = (SmartTodoItemPointer)((TodoItemNode)obj).getValue();
            if (value != null) {
                return new TodoNodeVisitor(value::getTodoItem, value.getTodoItem().getFile().getVirtualFile());
            }
        } else {
            Object o = obj instanceof AbstractTreeNode ? ((AbstractTreeNode)obj).getValue() : null;
            return new TodoNodeVisitor(() -> obj instanceof AbstractTreeNode ? ((AbstractTreeNode)obj).getValue() : obj, o instanceof PsiElement ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)o)) : null);
        }
        return null;
    }

    static PsiFile getFileForNode(DefaultMutableTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof TodoFileNode) {
            return (PsiFile)((TodoFileNode)((Object)obj)).getValue();
        }
        if (obj instanceof TodoItemNode) {
            SmartTodoItemPointer pointer = (SmartTodoItemPointer)((TodoItemNode)obj).getValue();
            return pointer.getTodoItem().getFile();
        }
        return null;
    }

    void setShowPackages(boolean state) {
        this.getTodoTreeStructure().setShownPackages(state);
        this.rebuildTreeOnSettingChange();
    }

    void setFlattenPackages(boolean state) {
        this.getTodoTreeStructure().setFlattenPackages(state);
        this.rebuildTreeOnSettingChange();
    }

    void setShowModules(boolean state) {
        this.getTodoTreeStructure().setShownModules(state);
        this.rebuildTreeOnSettingChange();
    }

    private void rebuildTreeOnSettingChange() {
        List pathsToSelect = TreeUtil.collectSelectedUserObjects((JTree)this.myTree);
        this.myTree.clearSelection();
        this.getTodoTreeStructure().validateCache();
        this.updateTree().onSuccess(o -> TreeUtil.promiseSelect((JTree)this.myTree, pathsToSelect.stream().map(TodoTreeBuilder::getVisitorFor)));
    }

    void setTodoFilter(TodoFilter filter) {
        this.getTodoTreeStructure().setTodoFilter(filter);
        try {
            this.rebuildCache();
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        this.updateTree();
    }

    public TodoItemNode getNextPointer(TodoItemNode pointer) {
        Object sibling = this.getNextSibling(pointer);
        if (sibling == null) {
            return null;
        }
        if (sibling instanceof TodoItemNode) {
            return (TodoItemNode)sibling;
        }
        return this.getFirstPointerForElement(sibling);
    }

    Object getNextSibling(Object obj) {
        Object parent = this.getTodoTreeStructure().getParentElement(obj);
        if (parent == null) {
            return null;
        }
        Object[] children2 = this.getTodoTreeStructure().getChildElements(parent);
        Arrays.sort(children2, NODE_DESCRIPTOR_COMPARATOR);
        int idx = -1;
        for (int i = 0; i < children2.length; ++i) {
            if (!obj.equals(children2[i])) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return null;
        }
        if (idx < children2.length - 1) {
            return children2[idx + 1];
        }
        return this.getNextSibling(parent);
    }

    public TodoItemNode getPreviousPointer(TodoItemNode pointer) {
        Object sibling = this.getPreviousSibling(pointer);
        if (sibling == null) {
            return null;
        }
        if (sibling instanceof TodoItemNode) {
            return (TodoItemNode)sibling;
        }
        return this.getLastPointerForElement(sibling);
    }

    Object getPreviousSibling(Object obj) {
        Object parent = this.getTodoTreeStructure().getParentElement(obj);
        if (parent == null) {
            return null;
        }
        Object[] children2 = this.getTodoTreeStructure().getChildElements(parent);
        Arrays.sort(children2, NODE_DESCRIPTOR_COMPARATOR);
        int idx = -1;
        for (int i = 0; i < children2.length; ++i) {
            if (!obj.equals(children2[i])) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return null;
        }
        if (idx > 0) {
            return children2[idx - 1];
        }
        return this.getPreviousSibling(parent);
    }

    public EditorHighlighter getHighlighter(PsiFile psiFile, Document document) {
        VirtualFile file2 = psiFile.getVirtualFile();
        EditorHighlighter highlighter = this.myFile2Highlighter.get(file2);
        if (highlighter == null) {
            highlighter = HighlighterFactory.createHighlighter((EditorColorsScheme)UsageTreeColorsScheme.getInstance().getScheme(), (String)file2.getName(), (Project)this.myProject);
            highlighter.setText(document.getCharsSequence());
            this.myFile2Highlighter.put(file2, highlighter);
        }
        return highlighter;
    }

    public boolean isDirectoryEmpty(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            TodoTreeBuilder.$$$reportNull$$$0(2);
        }
        return this.myFileTree.isDirectoryEmpty(psiDirectory.getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/todo/TodoTreeBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markFileAsDirty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "rebuildCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirectoryEmpty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            TodoTreeBuilder.this.updateTree();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            PsiFile psiFile;
            if (virtualFile == null) {
                MyFileStatusListener.$$$reportNull$$$0(0);
            }
            if ((psiFile = PsiManager.getInstance((Project)TodoTreeBuilder.this.myProject).findFile(virtualFile)) != null && TodoTreeBuilder.this.canContainTodoItems(psiFile)) {
                TodoTreeBuilder.this.updateTree();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ide/todo/TodoTreeBuilder$MyFileStatusListener", "fileStatusChanged"));
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(0);
            }
            if (e.getFile() != null) {
                TodoTreeBuilder.this.markFileAsDirty(e.getFile());
                TodoTreeBuilder.this.updateTree();
                return;
            }
            PsiElement child2 = e.getChild();
            if (!(child2 instanceof PsiFile)) {
                return;
            }
            PsiFile psiFile = (PsiFile)e.getChild();
            TodoTreeBuilder.this.markFileAsDirty(psiFile);
            TodoTreeBuilder.this.updateTree();
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent e) {
            PsiFile file2;
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(1);
            }
            if ((file2 = e.getFile()) != null) {
                TodoTreeBuilder.this.markFileAsDirty(file2);
                TodoTreeBuilder.this.updateTree();
                return;
            }
            PsiElement child2 = e.getChild();
            if (child2 instanceof PsiFile) {
                PsiFile psiFile = (PsiFile)child2;
                TodoTreeBuilder.this.markFileAsDirty(psiFile);
                TodoTreeBuilder.this.updateTree();
            } else if (child2 instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)child2;
                Iterator<PsiFile> i = TodoTreeBuilder.this.getAllFiles();
                while (i.hasNext()) {
                    PsiFile psiFile = i.next();
                    if (psiFile == null || !PsiTreeUtil.isAncestor((PsiElement)psiDirectory, (PsiElement)psiFile, (boolean)true)) continue;
                    TodoTreeBuilder.this.markFileAsDirty(psiFile);
                }
                TodoTreeBuilder.this.updateTree();
            } else if (PsiTreeUtil.getParentOfType((PsiElement)child2, PsiComment.class, (boolean)false) != null) {
                TodoTreeBuilder.this.markFileAsDirty(child2.getContainingFile());
                TodoTreeBuilder.this.updateTree();
            }
        }

        public void childMoved(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(2);
            }
            if (e.getFile() != null) {
                TodoTreeBuilder.this.markFileAsDirty(e.getFile());
                TodoTreeBuilder.this.updateTree();
                return;
            }
            if (e.getChild() instanceof PsiFile) {
                PsiFile psiFile = (PsiFile)e.getChild();
                if (!TodoTreeBuilder.this.canContainTodoItems(psiFile)) {
                    return;
                }
                TodoTreeBuilder.this.markFileAsDirty(psiFile);
                TodoTreeBuilder.this.updateTree();
            } else if (e.getChild() instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)e.getChild();
                boolean shouldUpdate = false;
                Iterator<PsiFile> i = TodoTreeBuilder.this.getAllFiles();
                while (i.hasNext()) {
                    PsiFile psiFile = i.next();
                    if (psiFile == null || !PsiTreeUtil.isAncestor((PsiElement)psiDirectory, (PsiElement)psiFile, (boolean)true)) continue;
                    TodoTreeBuilder.this.markFileAsDirty(psiFile);
                    shouldUpdate = true;
                }
                if (shouldUpdate) {
                    TodoTreeBuilder.this.updateTree();
                }
            }
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(3);
            }
            if (e.getFile() != null) {
                TodoTreeBuilder.this.markFileAsDirty(e.getFile());
                TodoTreeBuilder.this.updateTree();
            }
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(4);
            }
            if (e.getFile() != null) {
                TodoTreeBuilder.this.markFileAsDirty(e.getFile());
                TodoTreeBuilder.this.updateTree();
            }
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent e) {
            PsiDirectory psiDirectory;
            Iterator<PsiFile> iterator;
            String propertyName;
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(5);
            }
            if ((propertyName = e.getPropertyName()).equals("roots")) {
                TodoTreeBuilder.this.myModel.getInvoker().runOrInvokeLater(() -> DumbService.getInstance((Project)TodoTreeBuilder.this.myProject).runWhenSmart(() -> TodoTreeBuilder.this.rebuildCache()));
                TodoTreeBuilder.this.updateTree();
            } else if ("writable".equals(propertyName) || "fileName".equals(propertyName)) {
                PsiFile psiFile = (PsiFile)e.getElement();
                if (!TodoTreeBuilder.this.canContainTodoItems(psiFile)) {
                    return;
                }
                TodoTreeBuilder.this.updateTree();
            } else if ("directoryName".equals(propertyName) && (iterator = TodoTreeBuilder.this.getFiles(psiDirectory = (PsiDirectory)e.getElement())).hasNext()) {
                TodoTreeBuilder.this.updateTree();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/todo/TodoTreeBuilder$MyPsiTreeChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildRemoval";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

