/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.scopeView.NamedScopeFilter;
import com.intellij.ide.scopeView.ScopeViewPane;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopePaneSelectInTarget
extends ProjectViewSelectInTarget {
    public ScopePaneSelectInTarget(Project project) {
        super(project);
    }

    @Override
    public String toString() {
        return SelectInManager.SCOPE;
    }

    @Override
    public boolean canSelect(PsiFileSystemItem fileSystemItem) {
        ProjectRootManager manager;
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)fileSystemItem);
        if ((file2 = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file2)) == null || !file2.isValid()) {
            return false;
        }
        ProjectRootManager projectRootManager = manager = this.myProject.isDisposed() ? null : ProjectRootManager.getInstance((Project)this.myProject);
        if (manager == null || null == manager.getFileIndex().getModuleForFile(file2)) {
            return false;
        }
        if (!(fileSystemItem instanceof PsiFile)) {
            return false;
        }
        return this.getContainingFilter((PsiFile)fileSystemItem) != null;
    }

    @Nullable
    private NamedScopeFilter getContainingFilter(@Nullable PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        if (ScratchUtil.isScratch(file2.getVirtualFile())) {
            return null;
        }
        ScopeViewPane pane2 = this.getScopeViewPane();
        if (pane2 == null) {
            return null;
        }
        for (NamedScopeFilter filter : pane2.getFilters()) {
            if (!filter.accept(file2.getVirtualFile())) continue;
            return filter;
        }
        return null;
    }

    @Override
    public void select(PsiElement element, boolean requestFocus) {
        if (this.getSubId() == null) {
            NamedScopeFilter filter = this.getContainingFilter(element.getContainingFile());
            if (filter == null) {
                return;
            }
            this.setSubId(filter.toString());
        }
        super.select(element, requestFocus);
    }

    public String getMinorViewId() {
        return "Scope";
    }

    public float getWeight() {
        return 6.5f;
    }

    @Override
    public boolean isSubIdSelectable(@NotNull String subId, @NotNull SelectInContext context) {
        PsiFileSystemItem file2;
        if (subId == null) {
            ScopePaneSelectInTarget.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ScopePaneSelectInTarget.$$$reportNull$$$0(1);
        }
        if (!((file2 = this.getContextPsiFile(context)) instanceof PsiFile)) {
            return false;
        }
        ScopeViewPane pane2 = this.getScopeViewPane();
        NamedScopeFilter filter = pane2 == null ? null : pane2.getFilter(subId);
        return filter != null && filter.accept(file2.getVirtualFile());
    }

    private ScopeViewPane getScopeViewPane() {
        ProjectView view = ProjectView.getInstance(this.myProject);
        AbstractProjectViewPane pane2 = view == null ? null : view.getProjectViewPaneById("Scope");
        return pane2 instanceof ScopeViewPane ? (ScopeViewPane)pane2 : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "subId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/scopeView/ScopePaneSelectInTarget";
        objectArray[2] = "isSubIdSelectable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

