/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.SyntheticLibraryElementNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ExternalLibrariesNode
extends ProjectViewNode<String> {
    private static final Logger LOG = Logger.getInstance(ExternalLibrariesNode.class);

    public ExternalLibrariesNode(@NotNull Project project, ViewSettings viewSettings) {
        if (project == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(0);
        }
        super(project, (Object)"External Libraries", viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        Project project;
        ProjectFileIndex index;
        if (file2 == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(1);
        }
        if (!(index = ProjectFileIndex.getInstance((Project)(project = Objects.requireNonNull(this.getProject())))).isInLibrary(file2)) {
            return false;
        }
        return this.someChildContainsFile(file2, false);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Project project = Objects.requireNonNull(this.getProject());
        ArrayList<ProjectViewNode> children2 = new ArrayList<ProjectViewNode>();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        THashSet processedLibraries = new THashSet();
        THashSet processedSdk = new THashSet();
        for (Module module : modules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                JdkOrderEntry jdkOrderEntry;
                Sdk jdk;
                if (orderEntry instanceof LibraryOrderEntry) {
                    LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                    Library library = libraryOrderEntry.getLibrary();
                    if (library == null || processedLibraries.contains(library)) continue;
                    processedLibraries.add(library);
                    if (!ExternalLibrariesNode.hasExternalEntries(fileIndex, libraryOrderEntry)) continue;
                    String libraryName = library.getName();
                    if (libraryName == null || libraryName.length() == 0) {
                        ExternalLibrariesNode.addLibraryChildren(libraryOrderEntry, children2, project, this);
                        continue;
                    }
                    children2.add(new NamedLibraryElementNode(project, new NamedLibraryElement(null, (LibraryOrSdkOrderEntry)libraryOrderEntry), this.getSettings()));
                    continue;
                }
                if (!(orderEntry instanceof JdkOrderEntry) || (jdk = (jdkOrderEntry = (JdkOrderEntry)orderEntry).getJdk()) == null || processedSdk.contains(jdk)) continue;
                processedSdk.add(jdk);
                children2.add(new NamedLibraryElementNode(project, new NamedLibraryElement(null, (LibraryOrSdkOrderEntry)jdkOrderEntry), this.getSettings()));
            }
        }
        for (AdditionalLibraryRootsProvider additionalLibraryRootsProvider : (AdditionalLibraryRootsProvider[])AdditionalLibraryRootsProvider.EP_NAME.getExtensions()) {
            Collection<SyntheticLibrary> libraries = additionalLibraryRootsProvider.getAdditionalProjectLibraries(project);
            for (SyntheticLibrary library : libraries) {
                if (!library.isShowInExternalLibrariesNode()) continue;
                if (!(library instanceof ItemPresentation)) {
                    LOG.warn("Synthetic library must implement ItemPresentation to be shown in External Libraries node: " + libraries.getClass().getSimpleName());
                    continue;
                }
                children2.add(new SyntheticLibraryElementNode(project, library, (ItemPresentation)library, this.getSettings()));
            }
        }
        ArrayList<ProjectViewNode> arrayList = children2;
        if (arrayList == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static void addLibraryChildren(LibraryOrderEntry entry, List<? super AbstractTreeNode> children2, Project project, ProjectViewNode node) {
        VirtualFile[] files2;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile file2 : files2 = entry.getRootFiles(OrderRootType.CLASSES)) {
            PsiDirectory psiDir = psiManager.findDirectory(file2);
            if (psiDir == null) continue;
            children2.add((AbstractTreeNode)new PsiDirectoryNode(project, psiDir, node.getSettings()));
        }
    }

    private static boolean hasExternalEntries(ProjectFileIndex index, LibraryOrderEntry orderEntry) {
        for (VirtualFile file2 : LibraryGroupNode.getLibraryRoots(orderEntry)) {
            if (index.isInContent(VfsUtil.getLocalFile((VirtualFile)file2))) continue;
            return true;
        }
        return false;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(3);
        }
        presentation.setPresentableText(IdeBundle.message((String)"node.projectview.external.libraries", (Object[])new Object[0]));
        presentation.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ExternalLibrariesNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ExternalLibrariesNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

