/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaselinePanel
extends NonOpaquePanel {
    private Component myBaseComponent;
    private final List<Component> myVersionComponents = new ArrayList<Component>();
    private final List<Component> myButtonComponents = new ArrayList<Component>();
    private boolean[] myButtonEnableStates;
    private Component myProgressComponent;
    private int myYOffset;
    private final JBValue myOffset = new JBValue.Float(8.0f);
    private final JBValue myBeforeButtonOffset = new JBValue.Float(40.0f);
    private final JBValue myButtonOffset = new JBValue.Float(6.0f);
    private JLabel myErrorComponent;
    private Component myErrorEnableComponent;
    private EventHandler myEventHandler;

    public BaselinePanel() {
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)6, (int)0));
        this.setLayout((LayoutManager)new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                Dimension baseSize = BaselinePanel.this.myBaseComponent.getPreferredSize();
                int width = baseSize.width;
                if (BaselinePanel.this.myProgressComponent == null) {
                    int size;
                    Component component;
                    Iterator iterator = BaselinePanel.this.myVersionComponents.iterator();
                    while (iterator.hasNext() && (component = (Component)iterator.next()).isVisible()) {
                        width += BaselinePanel.this.myOffset.get() + component.getPreferredSize().width;
                    }
                    if (BaselinePanel.this.myErrorComponent != null) {
                        width += BaselinePanel.this.myOffset.get() + ((BaselinePanel)BaselinePanel.this).myErrorComponent.getPreferredSize().width;
                        if (BaselinePanel.this.myErrorEnableComponent != null) {
                            width += BaselinePanel.this.myOffset.get() + ((BaselinePanel)BaselinePanel.this).myErrorEnableComponent.getPreferredSize().width;
                        }
                    }
                    if ((size = BaselinePanel.this.myButtonComponents.size()) > 0) {
                        int visibleCount = 0;
                        for (Component component2 : BaselinePanel.this.myButtonComponents) {
                            if (!component2.isVisible()) continue;
                            width += component2.getPreferredSize().width;
                            ++visibleCount;
                        }
                        if (visibleCount > 0) {
                            width += BaselinePanel.this.myBeforeButtonOffset.get();
                            width += (visibleCount - 1) * BaselinePanel.this.myButtonOffset.get();
                        }
                    }
                } else {
                    width += BaselinePanel.this.myOffset.get() + ((BaselinePanel)BaselinePanel.this).myProgressComponent.getPreferredSize().width;
                }
                Insets insets = parent.getInsets();
                return new Dimension(width, insets.top + baseSize.height + insets.bottom);
            }

            private int calculateBaseWidth(@NotNull Container parent) {
                if (parent == null) {
                    1.$$$reportNull$$$0(0);
                }
                int parentWidth = parent.getWidth();
                if (BaselinePanel.this.myProgressComponent != null) {
                    return parentWidth - ((BaselinePanel)BaselinePanel.this).myProgressComponent.getPreferredSize().width - BaselinePanel.this.myOffset.get();
                }
                if (!BaselinePanel.this.myVersionComponents.isEmpty() && ((Component)BaselinePanel.this.myVersionComponents.get(0)).isVisible()) {
                    for (Object component : BaselinePanel.this.myVersionComponents) {
                        parentWidth -= ((Component)component).getPreferredSize().width;
                    }
                    parentWidth -= BaselinePanel.this.myOffset.get() * BaselinePanel.this.myVersionComponents.size();
                }
                int visibleCount = 0;
                for (Component component : BaselinePanel.this.myButtonComponents) {
                    if (!component.isVisible()) continue;
                    parentWidth -= component.getPreferredSize().width;
                    ++visibleCount;
                }
                parentWidth -= BaselinePanel.this.myButtonOffset.get() * (visibleCount - 1);
                if (visibleCount > 0) {
                    parentWidth -= BaselinePanel.this.myOffset.get();
                }
                if (BaselinePanel.this.myErrorComponent != null) {
                    int errorPartWidth;
                    if (BaselinePanel.this.myErrorEnableComponent != null) {
                        parentWidth -= BaselinePanel.this.myOffset.get() + ((BaselinePanel)BaselinePanel.this).myErrorEnableComponent.getPreferredSize().width;
                    }
                    if (((BaselinePanel)BaselinePanel.this).myBaseComponent.getPreferredSize().width >= parentWidth - (errorPartWidth = ((BaselinePanel)BaselinePanel.this).myErrorComponent.getPreferredSize().width / 3)) {
                        parentWidth -= errorPartWidth;
                    }
                }
                return parentWidth;
            }

            public void layoutContainer(Container parent) {
                Component component;
                Object size;
                Dimension baseSize = BaselinePanel.this.myBaseComponent.getPreferredSize();
                int top = parent.getInsets().top;
                int y = top + BaselinePanel.this.myBaseComponent.getBaseline(baseSize.width, baseSize.height);
                int x = 0;
                int calcBaseWidth = this.calculateBaseWidth(parent);
                if (BaselinePanel.this.myBaseComponent instanceof JLabel) {
                    JLabel label2 = (JLabel)BaselinePanel.this.myBaseComponent;
                    label2.setToolTipText(calcBaseWidth < baseSize.width ? label2.getText() : null);
                }
                baseSize.width = Math.min(baseSize.width, calcBaseWidth);
                BaselinePanel.this.myBaseComponent.setBounds(x, top, baseSize.width, baseSize.height);
                x += baseSize.width;
                if (BaselinePanel.this.myProgressComponent != null) {
                    size = BaselinePanel.this.myProgressComponent.getPreferredSize();
                    this.setBaselineBounds(parent.getWidth() - ((Dimension)size).width, y, BaselinePanel.this.myProgressComponent, (Dimension)size);
                    return;
                }
                size = BaselinePanel.this.myVersionComponents.iterator();
                while (size.hasNext() && (component = (Component)size.next()).isVisible()) {
                    Dimension size2 = component.getPreferredSize();
                    this.setBaselineBounds(x += BaselinePanel.this.myOffset.get(), y, component, size2);
                    x += size2.width;
                }
                int lastX = parent.getWidth();
                boolean emptyButtons = true;
                for (int i = BaselinePanel.this.myButtonComponents.size() - 1; i >= 0; --i) {
                    Component component2 = (Component)BaselinePanel.this.myButtonComponents.get(i);
                    if (!component2.isVisible()) continue;
                    emptyButtons = false;
                    Dimension size3 = component2.getPreferredSize();
                    this.setBaselineBounds(lastX -= size3.width, y - BaselinePanel.this.myYOffset, component2, size3);
                    lastX -= BaselinePanel.this.myButtonOffset.get();
                }
                if (BaselinePanel.this.myErrorComponent != null) {
                    x += BaselinePanel.this.myOffset.get();
                    if (BaselinePanel.this.myErrorEnableComponent != null) {
                        if (!emptyButtons) {
                            lastX -= BaselinePanel.this.myBeforeButtonOffset.get();
                        }
                        lastX -= ((BaselinePanel)BaselinePanel.this).myErrorEnableComponent.getPreferredSize().width;
                        lastX -= BaselinePanel.this.myOffset.get();
                    }
                    int errorWidth = lastX - x;
                    Dimension size4 = BaselinePanel.this.myErrorComponent.getPreferredSize();
                    if (errorWidth >= size4.width) {
                        this.setBaselineBounds(x, y, BaselinePanel.this.myErrorComponent, size4);
                        BaselinePanel.this.myErrorComponent.setToolTipText(null);
                        x += size4.width;
                    } else {
                        this.setBaselineBounds(x, y, BaselinePanel.this.myErrorComponent, size4, errorWidth, size4.height);
                        BaselinePanel.this.myErrorComponent.setToolTipText(BaselinePanel.this.myErrorComponent.getText());
                        x += errorWidth;
                    }
                    if (BaselinePanel.this.myErrorEnableComponent != null) {
                        this.setBaselineBounds(x += BaselinePanel.this.myOffset.get(), y, BaselinePanel.this.myErrorEnableComponent, BaselinePanel.this.myErrorEnableComponent.getPreferredSize());
                    }
                }
            }

            private void setBaselineBounds(int x, int y, @NotNull Component component, @NotNull Dimension size) {
                if (component == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (size == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.setBaselineBounds(x, y, component, size, size.width, size.height);
            }

            private void setBaselineBounds(int x, int y, @NotNull Component component, @NotNull Dimension prefSize, int width, int height) {
                if (component == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (prefSize == null) {
                    1.$$$reportNull$$$0(4);
                }
                component.setBounds(x, y - component.getBaseline(prefSize.width, prefSize.height), width, height);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "size";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prefSize";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/newui/BaselinePanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "calculateBaseWidth";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setBaselineBounds";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void setListeners(@NotNull EventHandler eventHandler) {
        if (eventHandler == null) {
            BaselinePanel.$$$reportNull$$$0(0);
        }
        this.myEventHandler = eventHandler;
    }

    public void setYOffset(int YOffset) {
        this.myYOffset = YOffset;
    }

    public Component add(Component component) {
        assert (this.myBaseComponent == null);
        this.myBaseComponent = component;
        return super.add(component);
    }

    public void addVersionComponent(@NotNull JComponent component) {
        if (component == null) {
            BaselinePanel.$$$reportNull$$$0(1);
        }
        this.myVersionComponents.add(component);
        this.add(component, null);
    }

    public void addErrorComponents(@NotNull String message, boolean enableAction, @NotNull Runnable enableCallback) {
        if (message == null) {
            BaselinePanel.$$$reportNull$$$0(2);
        }
        if (enableCallback == null) {
            BaselinePanel.$$$reportNull$$$0(3);
        }
        if (this.myErrorComponent == null) {
            this.myErrorComponent = new JLabel();
            this.myErrorComponent.setForeground(DialogWrapper.ERROR_FOREGROUND_COLOR);
            this.myErrorComponent.setOpaque(false);
            this.add(this.myErrorComponent, null);
            if (this.myEventHandler != null) {
                this.myEventHandler.add(this.myErrorComponent);
            }
        }
        this.myErrorComponent.setText(message);
        if (enableAction) {
            if (this.myErrorEnableComponent == null) {
                LinkLabel errorAction = new LinkLabel("Enable", null);
                errorAction.setOpaque(false);
                errorAction.setListener((aSource, aLinkData) -> enableCallback.run(), null);
                this.myErrorEnableComponent = errorAction;
                this.add(this.myErrorEnableComponent, null);
                if (this.myEventHandler != null) {
                    this.myEventHandler.add((Component)errorAction);
                }
            }
        } else if (this.myErrorEnableComponent != null) {
            this.remove(this.myErrorEnableComponent);
            this.myErrorEnableComponent = null;
        }
        for (Component component : this.myVersionComponents) {
            component.setVisible(false);
        }
        this.doLayout();
    }

    public void removeErrorComponents() {
        if (this.myErrorComponent != null) {
            this.remove(this.myErrorComponent);
            this.myErrorComponent = null;
            if (this.myErrorEnableComponent != null) {
                this.remove(this.myErrorEnableComponent);
                this.myErrorEnableComponent = null;
            }
            for (Component component : this.myVersionComponents) {
                component.setVisible(true);
            }
            this.doLayout();
        }
    }

    @NotNull
    public List<Component> getButtonComponents() {
        List<Component> list2 = this.myButtonComponents;
        if (list2 == null) {
            BaselinePanel.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void addButtonComponent(@NotNull JComponent component) {
        if (component == null) {
            BaselinePanel.$$$reportNull$$$0(5);
        }
        this.myButtonComponents.add(component);
        this.add(component, null);
    }

    public void addButtonAsFirstComponent(@NotNull JComponent component) {
        if (component == null) {
            BaselinePanel.$$$reportNull$$$0(6);
        }
        if (this.myButtonComponents.isEmpty()) {
            this.myButtonComponents.add(component);
        } else {
            this.myButtonComponents.add(0, component);
        }
        this.add(component, null);
    }

    public void removeButtonComponent(@NotNull JComponent component) {
        if (component == null) {
            BaselinePanel.$$$reportNull$$$0(7);
        }
        this.myButtonComponents.remove(component);
        this.remove(component);
    }

    public void setProgressComponent(@Nullable CellPluginComponent pluginComponent, @NotNull JComponent progressComponent) {
        if (progressComponent == null) {
            BaselinePanel.$$$reportNull$$$0(8);
        }
        assert (this.myProgressComponent == null);
        this.myProgressComponent = progressComponent;
        this.add(progressComponent, null);
        if (this.myEventHandler != null && pluginComponent != null) {
            this.myEventHandler.addAll(progressComponent);
            this.myEventHandler.updateHover(pluginComponent);
        }
        this.setVisibleOther(false);
        this.doLayout();
    }

    public void removeProgressComponent() {
        assert (this.myProgressComponent != null);
        this.remove(this.myProgressComponent);
        this.myProgressComponent = null;
        this.setVisibleOther(true);
        this.doLayout();
    }

    private void setVisibleOther(boolean value) {
        for (Component component : this.myVersionComponents) {
            component.setVisible(value);
        }
        if (this.myErrorComponent != null) {
            this.myErrorComponent.setVisible(value);
        }
        if (this.myErrorEnableComponent != null) {
            this.myErrorEnableComponent.setVisible(value);
        }
        if (this.myButtonComponents.isEmpty()) {
            return;
        }
        if (value) {
            assert (this.myButtonEnableStates != null && this.myButtonEnableStates.length == this.myButtonComponents.size());
            int size = this.myButtonComponents.size();
            for (int i = 0; i < size; ++i) {
                this.myButtonComponents.get(i).setVisible(this.myButtonEnableStates[i]);
            }
            this.myButtonEnableStates = null;
        } else {
            assert (this.myButtonEnableStates == null);
            this.myButtonEnableStates = new boolean[this.myButtonComponents.size()];
            int size = this.myButtonComponents.size();
            for (int i = 0; i < size; ++i) {
                Component component = this.myButtonComponents.get(i);
                this.myButtonEnableStates[i] = component.isVisible();
                component.setVisible(false);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableCallback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/BaselinePanel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/BaselinePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getButtonComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setListeners";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addVersionComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addErrorComponents";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addButtonComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addButtonAsFirstComponent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeButtonComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setProgressComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

