/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ImplementationConflictException;
import com.intellij.diagnostic.PluginConflictReporter;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.WindowsCommandLineListener;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.Main;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ArrayUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class MainRunner {
    public static WindowsCommandLineListener LISTENER;
    public static Activity startupStart;

    private static void start(@NotNull String mainClass, @NotNull String methodName, @NotNull String[] args, @NotNull LinkedHashMap<String, Long> startupTimings) {
        if (mainClass == null) {
            MainRunner.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            MainRunner.$$$reportNull$$$0(1);
        }
        if (args == null) {
            MainRunner.$$$reportNull$$$0(2);
        }
        if (startupTimings == null) {
            MainRunner.$$$reportNull$$$0(3);
        }
        StartUpMeasurer.addTimings(startupTimings, (String)"bootstrap");
        startupStart = StartUpMeasurer.start((String)"app initialization preparation");
        Main.setFlags((String[])args);
        ThreadGroup threadGroup = new ThreadGroup("Idea Thread Group"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                MainRunner.processException(e);
            }
        };
        Runnable runnable2 = () -> {
            try {
                Activity activity = startupStart.startChild("load main class");
                ClassUtilCore.clearJarURLCache();
                Class<?> aClass = Class.forName(mainClass);
                Method method = aClass.getDeclaredMethod(methodName, ArrayUtil.EMPTY_STRING_ARRAY.getClass());
                method.setAccessible(true);
                Object[] argsArray = new Object[]{args};
                activity.end();
                method.invoke(null, argsArray);
            }
            catch (Throwable t) {
                throw new StartupAbortedException(t);
            }
        };
        new Thread(threadGroup, runnable2, "Idea Main Thread").start();
    }

    public static void processException(@NotNull Throwable t) {
        if (t == null) {
            MainRunner.$$$reportNull$$$0(4);
        }
        if (!ApplicationManagerEx.isAppLoaded()) {
            ImplementationConflictException conflictException;
            PluginException pluginException;
            PluginId pluginId;
            StartupAbortedException startupException;
            PluginManagerCore.EssentialPluginMissingException pluginMissingException = MainRunner.findCause(t, PluginManagerCore.EssentialPluginMissingException.class);
            if (pluginMissingException != null && pluginMissingException.pluginIds != null) {
                Main.showMessage((String)"Corrupted Installation", (String)("Missing essential " + (pluginMissingException.pluginIds.size() == 1 ? "plugin" : "plugins") + ":\n\n" + pluginMissingException.pluginIds.stream().sorted().collect(Collectors.joining("\n  ", "  ", "\n\n")) + "Please reinstall " + MainRunner.getProductNameSafe() + " from scratch."), (boolean)true);
                System.exit(12);
            }
            if ((startupException = MainRunner.findCause(t, StartupAbortedException.class)) == null) {
                startupException = new StartupAbortedException(t);
            }
            PluginId pluginId2 = pluginId = (pluginException = MainRunner.findCause(t, PluginException.class)) != null ? pluginException.getPluginId() : null;
            if (Logger.isInitialized() && !(t instanceof ProcessCanceledException)) {
                try {
                    PluginManagerCore.getLogger().error(t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (t instanceof StackOverflowError && "Nashorn AST Serializer".equals(Thread.currentThread().getName())) {
                    return;
                }
            }
            if ((conflictException = MainRunner.findCause(t, ImplementationConflictException.class)) != null) {
                PluginConflictReporter.INSTANCE.reportConflictByClasses(conflictException.getConflictingClasses());
            }
            if (pluginId != null && !ApplicationInfoImpl.getShadowInstance().isEssentialPlugin(pluginId.getIdString())) {
                PluginManagerCore.disablePlugin(pluginId.getIdString());
                StringWriter message = new StringWriter();
                message.append("Plugin '").append(pluginId.getIdString()).append("' failed to initialize and will be disabled. ");
                message.append(" Please restart ").append(MainRunner.getProductNameSafe()).append('.');
                message.append("\n\n");
                pluginException.getCause().printStackTrace(new PrintWriter(message));
                Main.showMessage((String)"Plugin Error", (String)message.toString(), (boolean)false);
                System.exit(8);
            } else {
                Main.showMessage((String)"Start Failed", (Throwable)t);
                System.exit(startupException.exitCode());
            }
        } else if (!(t instanceof ProcessCanceledException)) {
            PluginManagerCore.getLogger().error(t);
        }
    }

    private static String getProductNameSafe() {
        try {
            return ApplicationNamesInfo.getInstance().getFullProductName();
        }
        catch (Throwable ignore) {
            return "the IDE";
        }
    }

    private static <T extends Throwable> T findCause(Throwable t, Class<T> clazz) {
        while (t != null) {
            if (clazz.isInstance(t)) {
                return (T)((Throwable)clazz.cast(t));
            }
            t = t.getCause();
        }
        return null;
    }

    public static int processWindowsLauncherCommandLine(String currentDirectory, String[] args) {
        if (LISTENER != null) {
            return LISTENER.processWindowsLauncherCommandLine(currentDirectory, args);
        }
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupTimings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/MainRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processException";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class StartupAbortedException
    extends RuntimeException {
        private int exitCode = 3;

        StartupAbortedException(Throwable cause) {
            super(cause);
        }

        StartupAbortedException(String message, Throwable cause) {
            super(message, cause);
        }

        public int exitCode() {
            return this.exitCode;
        }

        @NotNull
        public StartupAbortedException exitCode(int exitCode) {
            this.exitCode = exitCode;
            StartupAbortedException startupAbortedException = this;
            if (startupAbortedException == null) {
                StartupAbortedException.$$$reportNull$$$0(0);
            }
            return startupAbortedException;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/MainRunner$StartupAbortedException", "exitCode"));
        }
    }
}

