/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JLabel;

public class CountComponent
extends JLabel {
    private final Color myOvalColor = JBColor.namedColor((String)"Counter.background", (Color)new Color(-862279760, true));

    public CountComponent() {
        this.setBorder(null);
        this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)(SystemInfo.isMac || SystemInfo.isLinux && (UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderDarcula()) ? UIUtil.FontSize.SMALL : UIUtil.FontSize.NORMAL)));
        this.setForeground((Color)JBColor.namedColor((String)"Counter.foreground", (Color)new JBColor(0xFFFFFF, 4080461)));
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(0);
    }

    public void setSelected(boolean selected2) {
        this.setBackground(selected2 ? UIUtil.getTreeSelectionBackground((boolean)true) : UIUtil.SIDE_PANEL_BACKGROUND);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(size.width, this.getTextOffset() + this.getOvalWidth()), Math.max(size.height, CountComponent.getOvalHeight()));
    }

    @Override
    protected void paintComponent(Graphics g) {
        int corner = JBUIScale.scale((int)14);
        int ovalWidth = this.getOvalWidth();
        int ovalHeight = CountComponent.getOvalHeight();
        int width = this.getWidth();
        int height = this.getHeight();
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        g.setColor(this.myOvalColor);
        g.fillRoundRect(this.getTextOffset() + (width - ovalWidth) / 2, (height - ovalHeight) / 2, ovalWidth, ovalHeight, corner, corner);
        config2.restore();
        super.paintComponent(g);
    }

    private int getOvalWidth() {
        int i = this.getText().length() == 1 ? 16 : 20;
        return JBUIScale.scale((int)i);
    }

    private int getTextOffset() {
        String text2 = this.getText();
        return text2.equals("1") || text2.equals("3") || text2.equals("4") ? 1 : 0;
    }

    private static int getOvalHeight() {
        return JBUIScale.scale((int)14);
    }
}

