/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.hierarchy.ExporterToTextFileHierarchy;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyNodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyBrowserBase
extends SimpleToolWindowPanel
implements HierarchyBrowser,
Disposable,
DataProvider {
    private static final HierarchyNodeDescriptor[] EMPTY_DESCRIPTORS = new HierarchyNodeDescriptor[0];
    protected final Project myProject;
    protected Content myContent;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private volatile boolean myDisposed;

    protected HierarchyBrowserBase(@NotNull Project project) {
        if (project == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(0);
        }
        super(true, true);
        this.myProject = project;
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBase.this.myProject).IS_AUTOSCROLL_TO_SOURCE;
            }

            protected void setAutoScrollMode(boolean state) {
                HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBase.this.myProject).IS_AUTOSCROLL_TO_SOURCE = state;
            }
        };
    }

    public void setContent(Content content2) {
        this.myContent = content2;
    }

    protected void buildUi(@NotNull JComponent toolbar, @NotNull JComponent content2) {
        if (toolbar == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(1);
        }
        if (content2 == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(2);
        }
        this.setToolbar(toolbar);
        this.setContent(content2);
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    protected ActionToolbar createToolbar(@NotNull String place, String helpID) {
        if (place == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(3);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        this.appendActions(actionGroup, helpID);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(place, (ActionGroup)actionGroup, true);
        actionToolbar.setTargetComponent((JComponent)((Object)this));
        ActionToolbar actionToolbar2 = actionToolbar;
        if (actionToolbar2 == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(4);
        }
        return actionToolbar2;
    }

    protected void appendActions(@NotNull DefaultActionGroup actionGroup, @Nullable String helpID) {
        if (actionGroup == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(5);
        }
        actionGroup.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        ActionManager actionManager = ActionManager.getInstance();
        actionGroup.add(actionManager.getAction("ExpandAll"));
        actionGroup.add(actionManager.getAction("PinToolwindowTab"));
        actionGroup.add(CommonActionsManager.getInstance().createExportToTextFileAction((ExporterToTextFile)new ExporterToTextFileHierarchy(this)));
        actionGroup.add((AnAction)new CloseAction());
    }

    protected abstract JTree getCurrentTree();

    abstract StructureTreeModel getCurrentBuilder();

    @Nullable
    protected abstract PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor var1);

    @Nullable
    protected DefaultMutableTreeNode getSelectedNode() {
        JTree tree = this.getCurrentTree();
        if (tree == null) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return (DefaultMutableTreeNode)lastPathComponent;
    }

    @Nullable
    protected final PsiElement getSelectedElement() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        HierarchyNodeDescriptor descriptor2 = node != null ? this.getDescriptor(node) : null;
        return descriptor2 != null ? this.getElementFromDescriptor(descriptor2) : null;
    }

    @Nullable
    protected HierarchyNodeDescriptor getDescriptor(DefaultMutableTreeNode node) {
        Object userObject;
        Object object = userObject = node != null ? node.getUserObject() : null;
        if (userObject instanceof HierarchyNodeDescriptor) {
            return (HierarchyNodeDescriptor)((Object)userObject);
        }
        return null;
    }

    public PsiElement[] getAvailableElements() {
        JTree tree = this.getCurrentTree();
        if (tree == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        TreeModel model2 = tree.getModel();
        Object root = model2.getRoot();
        if (!(root instanceof DefaultMutableTreeNode)) {
            return PsiElement.EMPTY_ARRAY;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)root;
        HierarchyNodeDescriptor descriptor2 = this.getDescriptor(node);
        HashSet result2 = new HashSet();
        this.collectElements(descriptor2, result2);
        return result2.toArray(PsiElement.EMPTY_ARRAY);
    }

    private void collectElements(HierarchyNodeDescriptor descriptor2, Set<? super PsiElement> out) {
        Object[] children2;
        if (descriptor2 == null) {
            return;
        }
        PsiElement element = this.getElementFromDescriptor(descriptor2);
        if (element != null) {
            out.add((PsiElement)element.getNavigationElement());
        }
        if ((children2 = descriptor2.getCachedChildren()) == null) {
            return;
        }
        for (Object child2 : children2) {
            if (!(child2 instanceof HierarchyNodeDescriptor)) continue;
            HierarchyNodeDescriptor childDescriptor = (HierarchyNodeDescriptor)((Object)child2);
            this.collectElements(childDescriptor, out);
        }
    }

    public final HierarchyNodeDescriptor[] getSelectedDescriptors() {
        JTree tree = this.getCurrentTree();
        if (tree == null) {
            return EMPTY_DESCRIPTORS;
        }
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return EMPTY_DESCRIPTORS;
        }
        ArrayList<HierarchyNodeDescriptor> list2 = new ArrayList<HierarchyNodeDescriptor>(paths.length);
        for (TreePath path : paths) {
            DefaultMutableTreeNode node;
            HierarchyNodeDescriptor descriptor2;
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof DefaultMutableTreeNode) || (descriptor2 = this.getDescriptor(node = (DefaultMutableTreeNode)lastPathComponent)) == null) continue;
            list2.add(descriptor2);
        }
        return list2.toArray(new HierarchyNodeDescriptor[0]);
    }

    @NotNull
    protected PsiElement[] getSelectedElements() {
        HierarchyNodeDescriptor[] descriptors = this.getSelectedDescriptors();
        ArrayList<PsiElement> elements2 = new ArrayList<PsiElement>();
        for (HierarchyNodeDescriptor descriptor2 : descriptors) {
            PsiElement element = this.getElementFromDescriptor(descriptor2);
            if (element == null) continue;
            elements2.add(element);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(elements2);
        if (psiElementArray == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    private Navigatable[] getNavigatables() {
        HierarchyNodeDescriptor[] selectedDescriptors = this.getSelectedDescriptors();
        if (selectedDescriptors == null || selectedDescriptors.length == 0) {
            return null;
        }
        ArrayList<Navigatable> result2 = new ArrayList<Navigatable>();
        for (HierarchyNodeDescriptor descriptor2 : selectedDescriptors) {
            Navigatable navigatable = this.getNavigatable(descriptor2);
            if (navigatable == null) continue;
            result2.add(navigatable);
        }
        return result2.toArray(new Navigatable[0]);
    }

    private Navigatable getNavigatable(HierarchyNodeDescriptor descriptor2) {
        if (descriptor2 instanceof Navigatable && descriptor2.isValid()) {
            return (Navigatable)descriptor2;
        }
        PsiElement element = this.getElementFromDescriptor(descriptor2);
        if (element instanceof NavigatablePsiElement && element.isValid()) {
            return (NavigatablePsiElement)element;
        }
        return null;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        JTree tree;
        if (dataId == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(7);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement anElement = this.getSelectedElement();
            return anElement != null && anElement.isValid() ? anElement : super.getData(dataId);
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return this.getSelectedElements();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            DefaultMutableTreeNode selectedNode = this.getSelectedNode();
            if (selectedNode == null) {
                return null;
            }
            HierarchyNodeDescriptor descriptor2 = this.getDescriptor(selectedNode);
            if (descriptor2 == null) {
                return null;
            }
            return this.getNavigatable(descriptor2);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getNavigatables();
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId) && (tree = this.getCurrentTree()) != null) {
            return new DefaultTreeExpander(tree);
        }
        return super.getData(dataId);
    }

    protected void configureTree(@NotNull Tree tree) {
        if (tree == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(8);
        }
        tree.getSelectionModel().setSelectionMode(4);
        tree.setToggleClickCount(-1);
        tree.setCellRenderer((TreeCellRenderer)((Object)new HierarchyNodeRenderer()));
        new TreeSpeedSearch((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        this.myAutoScrollToSourceHandler.install((JTree)tree);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildUi";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendActions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class CloseAction
    extends CloseTabToolbarAction {
        private CloseAction() {
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(0);
            }
            Objects.requireNonNull(HierarchyBrowserBase.this.myContent.getManager()).removeContent(HierarchyBrowserBase.this.myContent, true);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setVisible(HierarchyBrowserBase.this.myContent != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBase$CloseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

