/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="BookmarkManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class BookmarkManager
implements PersistentStateComponent<Element> {
    private static final int MAX_AUTO_DESCRIPTION_SIZE = 50;
    private final MultiMap<VirtualFile, Bookmark> myBookmarks = MultiMap.createConcurrentSet();
    private final Map<Trinity<VirtualFile, Integer, String>, Bookmark> myDeletedDocumentBookmarks = new HashMap<Trinity<VirtualFile, Integer, String>, Bookmark>();
    private final Map<Document, List<Trinity<Bookmark, Integer, String>>> myBeforeChangeData = new HashMap<Document, List<Trinity<Bookmark, Integer, String>>>();
    private final MessageBus myBus;
    private final Project myProject;
    private boolean mySortedState;

    public static BookmarkManager getInstance(Project project) {
        return (BookmarkManager)ServiceManager.getService((Project)project, BookmarkManager.class);
    }

    public BookmarkManager(Project project, PsiDocumentManager documentManager, EditorColorsManager colorsManager, EditorFactory editorFactory) {
        this.myProject = project;
        this.myBus = project.getMessageBus();
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(EditorColorsManager.TOPIC, __ -> this.colorsChanged());
        EditorEventMulticaster multicaster = editorFactory.getEventMulticaster();
        multicaster.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this.myProject);
        multicaster.addEditorMouseListener((EditorMouseListener)new MyEditorMouseListener(), (Disposable)this.myProject);
        documentManager.addListener(new PsiDocumentManager.Listener(){

            public void documentCreated(@NotNull Document document, PsiFile psiFile) {
                VirtualFile file2;
                if (document == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((file2 = FileDocumentManager.getInstance().getFile(document)) == null) {
                    return;
                }
                Collection fileBookmarks = BookmarkManager.this.myBookmarks.get((Object)file2);
                if (!fileBookmarks.isEmpty()) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (BookmarkManager.this.myProject.isDisposed()) {
                            return;
                        }
                        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, BookmarkManager.this.myProject, true);
                        for (Bookmark bookmark : fileBookmarks) {
                            bookmark.createHighlighter(markup);
                        }
                    });
                }
            }

            public void fileCreated(@NotNull PsiFile file2, @NotNull Document document) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/bookmarks/BookmarkManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentCreated";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.mySortedState = UISettings.getInstance().getSortBookmarks();
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> {
            if (this.mySortedState != uiSettings.getSortBookmarks()) {
                this.mySortedState = uiSettings.getSortBookmarks();
                EventQueue.invokeLater(() -> ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarksOrderChanged());
            }
        });
    }

    public void editDescription(@NotNull Bookmark bookmark, @NotNull JComponent popup2) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(0);
        }
        if (popup2 == null) {
            BookmarkManager.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String description = Messages.showInputDialog((Component)popup2, (String)IdeBundle.message((String)"action.bookmark.edit.description.dialog.message", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.bookmark.edit.description.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)bookmark.getDescription(), null);
        if (description != null) {
            this.setDescription(bookmark, description);
        }
    }

    public void addEditorBookmark(@NotNull Editor editor, int lineIndex) {
        if (editor == null) {
            BookmarkManager.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.addTextBookmark(virtualFile, lineIndex, BookmarkManager.getAutoDescription(editor, lineIndex));
    }

    @NotNull
    public Bookmark addTextBookmark(@NotNull VirtualFile file2, int lineIndex, @NotNull String description) {
        if (file2 == null) {
            BookmarkManager.$$$reportNull$$$0(3);
        }
        if (description == null) {
            BookmarkManager.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Bookmark b = new Bookmark(this.myProject, file2, lineIndex, description);
        this.myBookmarks.values().forEach(bookmark -> ++bookmark.index);
        this.myBookmarks.putValue((Object)file2, (Object)b);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkAdded(b);
        Bookmark bookmark2 = b;
        if (bookmark2 == null) {
            BookmarkManager.$$$reportNull$$$0(5);
        }
        return bookmark2;
    }

    @Nullable
    public Bookmark addFileBookmark(@NotNull VirtualFile file2, @NotNull String description) {
        if (file2 == null) {
            BookmarkManager.$$$reportNull$$$0(6);
        }
        if (description == null) {
            BookmarkManager.$$$reportNull$$$0(7);
        }
        if (this.findFileBookmark(file2) != null) {
            return null;
        }
        return this.addTextBookmark(file2, -1, description);
    }

    @NotNull
    private static String getAutoDescription(@NotNull Editor editor, int lineIndex) {
        String autoDescription;
        if (editor == null) {
            BookmarkManager.$$$reportNull$$$0(8);
        }
        if ((autoDescription = editor.getSelectionModel().getSelectedText()) == null) {
            Document document = editor.getDocument();
            autoDescription = document.getCharsSequence().subSequence(document.getLineStartOffset(lineIndex), document.getLineEndOffset(lineIndex)).toString().trim();
        }
        if (autoDescription.length() > 50) {
            String string = autoDescription.substring(0, 50) + "...";
            if (string == null) {
                BookmarkManager.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = autoDescription;
        if (string == null) {
            BookmarkManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public List<Bookmark> getValidBookmarks() {
        List answer = ContainerUtil.filter((Collection)this.myBookmarks.values(), b -> b.isValid());
        if (UISettings.getInstance().getSortBookmarks()) {
            Collections.sort(answer);
        } else {
            Collections.sort(answer, Comparator.comparingInt(b -> b.index));
        }
        List list2 = answer;
        if (list2 == null) {
            BookmarkManager.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Nullable
    public Bookmark findEditorBookmark(@NotNull Document document, int line2) {
        VirtualFile file2;
        if (document == null) {
            BookmarkManager.$$$reportNull$$$0(12);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) == null) {
            return null;
        }
        return (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.get((Object)file2), bookmark -> bookmark.getLine() == line2);
    }

    @Nullable
    public Bookmark findFileBookmark(@NotNull VirtualFile file2) {
        if (file2 == null) {
            BookmarkManager.$$$reportNull$$$0(13);
        }
        return (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.get((Object)file2), bookmark -> bookmark.getLine() == -1);
    }

    @Nullable
    public Bookmark findBookmarkForMnemonic(char m) {
        char mm = Character.toUpperCase(m);
        return (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), bookmark -> bookmark.getMnemonic() == mm);
    }

    public boolean hasBookmarksWithMnemonics() {
        return ContainerUtil.or((Iterable)this.myBookmarks.values(), bookmark -> bookmark.getMnemonic() != '\u0000');
    }

    public void removeBookmark(@NotNull Bookmark bookmark) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        VirtualFile file2 = bookmark.getFile();
        if (this.myBookmarks.remove((Object)file2, (Object)bookmark)) {
            int index = bookmark.index;
            this.myBookmarks.values().forEach(b -> {
                b.index = b.index - (b.index > index ? 1 : 0);
            });
            bookmark.release();
            ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkRemoved(bookmark);
        }
    }

    public Element getState() {
        Element container = new Element("BookmarkManager");
        this.writeExternal(container);
        return container;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            BookmarkManager.$$$reportNull$$$0(15);
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
            Bookmark[] bookmarks;
            for (Bookmark bookmark : bookmarks = this.myBookmarks.values().toArray(new Bookmark[0])) {
                bookmark.release();
            }
            this.myBookmarks.clear();
            this.readExternal(state);
        }));
    }

    private void readExternal(Element element) {
        for (Object o : element.getChildren("bookmark")) {
            Element bookmarkElement = (Element)o;
            String url = bookmarkElement.getAttributeValue("url");
            String line2 = bookmarkElement.getAttributeValue("line");
            String description = StringUtil.notNullize((String)bookmarkElement.getAttributeValue("description"));
            String mnemonic = bookmarkElement.getAttributeValue("mnemonic");
            Bookmark b = null;
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file2 != null) {
                if (line2 != null) {
                    try {
                        int lineIndex = Integer.parseInt(line2);
                        b = this.addTextBookmark(file2, lineIndex, description);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    b = this.addFileBookmark(file2, description);
                }
            }
            if (b == null || mnemonic == null || mnemonic.length() != 1) continue;
            this.setMnemonic(b, mnemonic.charAt(0));
        }
    }

    private void writeExternal(Element element) {
        ArrayList bookmarks = new ArrayList(this.myBookmarks.values());
        Collections.sort(bookmarks, Comparator.comparingInt(o -> o.index).reversed());
        for (Bookmark bookmark : bookmarks) {
            char mnemonic;
            int line2;
            if (!bookmark.isValid()) continue;
            Element bookmarkElement = new Element("bookmark");
            bookmarkElement.setAttribute("url", bookmark.getFile().getUrl());
            String description = bookmark.nullizeEmptyDescription();
            if (description != null) {
                bookmarkElement.setAttribute("description", description);
            }
            if ((line2 = bookmark.getLine()) >= 0) {
                bookmarkElement.setAttribute("line", String.valueOf(line2));
            }
            if ((mnemonic = bookmark.getMnemonic()) != '\u0000') {
                bookmarkElement.setAttribute("mnemonic", String.valueOf(mnemonic));
            }
            element.addContent(bookmarkElement);
        }
    }

    public void moveBookmarkUp(@NotNull Bookmark bookmark) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int index = bookmark.index;
        if (index > 0) {
            Bookmark other = (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), b -> b.index == index - 1);
            other.index = index;
            bookmark.index = index - 1;
            EventQueue.invokeLater(() -> {
                ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(bookmark);
                ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(other);
            });
        }
    }

    public void moveBookmarkDown(@NotNull Bookmark bookmark) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int index = bookmark.index;
        if (index < this.myBookmarks.values().size() - 1) {
            Bookmark other = (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), b -> b.index == index + 1);
            other.index = index;
            bookmark.index = index + 1;
            EventQueue.invokeLater(() -> {
                ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(bookmark);
                ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(other);
            });
        }
    }

    @Nullable
    public Bookmark findLineBookmark(@NotNull Editor editor, boolean isWrapped, boolean next) {
        VirtualFile file2;
        if (editor == null) {
            BookmarkManager.$$$reportNull$$$0(18);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
            return null;
        }
        ArrayList bookmarksForDocument = new ArrayList(this.myBookmarks.get((Object)file2));
        if (bookmarksForDocument.isEmpty()) {
            return null;
        }
        int sign = next ? 1 : -1;
        Collections.sort(bookmarksForDocument, (o1, o2) -> sign * (o1.getLine() - o2.getLine()));
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        for (Bookmark bookmark : bookmarksForDocument) {
            if (next && bookmark.getLine() > caretLine) {
                return bookmark;
            }
            if (next || bookmark.getLine() >= caretLine) continue;
            return bookmark;
        }
        return isWrapped && !bookmarksForDocument.isEmpty() ? (Bookmark)bookmarksForDocument.get(0) : null;
    }

    public void setMnemonic(@NotNull Bookmark bookmark, char c2) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Bookmark old = this.findBookmarkForMnemonic(c2);
        if (old != null) {
            this.removeBookmark(old);
        }
        bookmark.setMnemonic(c2);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(bookmark);
    }

    public void setDescription(@NotNull Bookmark bookmark, @NotNull String description) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(20);
        }
        if (description == null) {
            BookmarkManager.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        bookmark.setDescription(description);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(bookmark);
    }

    private void colorsChanged() {
        for (Bookmark bookmark : this.myBookmarks.values()) {
            bookmark.updateHighlighter();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bookmark";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 2: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/bookmarks/BookmarkManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/bookmarks/BookmarkManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addTextBookmark";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidBookmarks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "editDescription";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addEditorBookmark";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTextBookmark";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFileBookmark";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAutoDescription";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findEditorBookmark";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFileBookmark";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeBookmark";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "moveBookmarkUp";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "moveBookmarkDown";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findLineBookmark";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setMnemonic";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            Document doc = e.getDocument();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(doc);
            if (file2 != null) {
                for (Bookmark bookmark : BookmarkManager.this.myBookmarks.get((Object)file2)) {
                    if (bookmark.getLine() == -1) continue;
                    List list2 = BookmarkManager.this.myBeforeChangeData.computeIfAbsent(doc, __ -> new ArrayList());
                    list2.add(new Trinity((Object)bookmark, (Object)bookmark.getLine(), (Object)doc.getText(new TextRange(doc.getLineStartOffset(bookmark.getLine()), doc.getLineEndOffset(bookmark.getLine())))));
                }
            }
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(1);
            }
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(e.getDocument());
            ArrayList<Bookmark> bookmarksToRemove = null;
            if (file2 != null) {
                for (Bookmark bookmark : BookmarkManager.this.myBookmarks.get((Object)file2)) {
                    if (bookmark.isValid() && !this.isDuplicate(bookmark, file2, (List<Bookmark>)bookmarksToRemove)) continue;
                    if (bookmarksToRemove == null) {
                        bookmarksToRemove = new ArrayList<Bookmark>();
                    }
                    bookmarksToRemove.add(bookmark);
                }
            }
            if (bookmarksToRemove != null) {
                for (Bookmark bookmark : bookmarksToRemove) {
                    this.moveToDeleted(bookmark);
                }
            }
            BookmarkManager.this.myBeforeChangeData.remove(e.getDocument());
            Iterator iterator = BookmarkManager.this.myDeletedDocumentBookmarks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                VirtualFile virtualFile = (VirtualFile)((Trinity)entry.getKey()).first;
                if (!virtualFile.isValid()) {
                    iterator.remove();
                    continue;
                }
                Bookmark bookmark = (Bookmark)entry.getValue();
                Document document = bookmark.getCachedDocument();
                if (document == null || !bookmark.getFile().equals(virtualFile)) continue;
                Integer line2 = (Integer)((Trinity)entry.getKey()).second;
                if (document.getLineCount() <= line2) continue;
                String bookmarkedText = (String)((Trinity)entry.getKey()).third;
                String lineContent = this.getLineContent(document, line2);
                if (!bookmarkedText.equals(lineContent) && line2 > 1 && (bookmarkedText.equals(StringUtil.trimEnd((String)e.getNewFragment().toString(), (String)"\n")) || bookmarkedText.equals(StringUtil.trimEnd((String)e.getOldFragment().toString(), (String)"\n")))) {
                    line2 = line2 - 2;
                    lineContent = this.getLineContent(document, line2);
                }
                if (!bookmarkedText.equals(lineContent) || BookmarkManager.this.findEditorBookmark(document, line2) != null) continue;
                Bookmark restored = BookmarkManager.this.addTextBookmark(bookmark.getFile(), line2, bookmark.getDescription());
                if (bookmark.getMnemonic() != '\u0000') {
                    BookmarkManager.this.setMnemonic(restored, bookmark.getMnemonic());
                }
                iterator.remove();
            }
        }

        private boolean isDuplicate(Bookmark bookmark, @NotNull VirtualFile file2, @Nullable List<Bookmark> toRemove2) {
            if (file2 == null) {
                MyDocumentListener.$$$reportNull$$$0(2);
            }
            for (Bookmark b : BookmarkManager.this.myBookmarks.get((Object)file2)) {
                if (b == bookmark || !b.isValid() || !Comparing.equal((Object)b.getFile(), (Object)bookmark.getFile()) || b.getLine() != bookmark.getLine() || toRemove2 != null && toRemove2.contains(b)) continue;
                return true;
            }
            return false;
        }

        private void moveToDeleted(Bookmark bookmark) {
            List list2 = (List)BookmarkManager.this.myBeforeChangeData.get(bookmark.getCachedDocument());
            if (list2 != null) {
                for (Trinity trinity : list2) {
                    if (trinity.first != bookmark) continue;
                    BookmarkManager.this.removeBookmark(bookmark);
                    BookmarkManager.this.myDeletedDocumentBookmarks.put(new Trinity((Object)bookmark.getFile(), trinity.second, trinity.third), bookmark);
                    break;
                }
            }
        }

        private String getLineContent(Document document, int line2) {
            int start2 = document.getLineStartOffset(line2);
            int end = document.getLineEndOffset(line2);
            return document.getText(new TextRange(start2, end));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/bookmarks/BookmarkManager$MyDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDuplicate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyEditorMouseListener
    implements EditorMouseListener {
        private MyEditorMouseListener() {
        }

        public void mouseClicked(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(0);
            }
            if (e.getArea() != EditorMouseEventArea.LINE_MARKERS_AREA) {
                return;
            }
            if (e.getMouseEvent().isPopupTrigger()) {
                return;
            }
            if ((e.getMouseEvent().getModifiers() & (SystemInfo.isMac ? 4 : 2)) == 0) {
                return;
            }
            Editor editor = e.getEditor();
            int line2 = editor.xyToLogicalPosition((Point)new Point((int)e.getMouseEvent().getX(), (int)e.getMouseEvent().getY())).line;
            if (line2 < 0) {
                return;
            }
            Document document = editor.getDocument();
            Bookmark bookmark = BookmarkManager.this.findEditorBookmark(document, line2);
            if (bookmark == null) {
                BookmarkManager.this.addEditorBookmark(editor, line2);
            } else {
                BookmarkManager.this.removeBookmark(bookmark);
            }
            e.consume();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/bookmarks/BookmarkManager$MyEditorMouseListener", "mouseClicked"));
        }
    }
}

