/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CopyReferenceFQNTransferable;
import com.intellij.ide.actions.CopyReferenceUtil;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyReferenceAction
extends DumbAwareAction {
    public static final DataFlavor ourFlavor = FileCopyPasteUtil.createJvmDataFlavor(CopyReferenceFQNTransferable.class);

    public CopyReferenceAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            CopyReferenceAction.$$$reportNull$$$0(0);
        }
        boolean plural = false;
        boolean paths = false;
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && FileDocumentManager.getInstance().getFile(editor.getDocument()) != null) {
            enabled = true;
        } else {
            List<PsiElement> elements2 = CopyReferenceUtil.getElementsToCopy(editor, dataContext);
            enabled = !elements2.isEmpty();
            plural = elements2.size() > 1;
            paths = elements2.stream().allMatch(el -> el instanceof PsiFileSystemItem && CopyReferenceUtil.getQualifiedNameFromProviders(el) == null);
        }
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
        e.getPresentation().setText(paths ? (plural ? "Cop&y Relative Paths" : "Cop&y Relative Path") : (plural ? "Cop&y References" : "Cop&y Reference"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyReferenceAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        List<PsiElement> elements2 = CopyReferenceUtil.getElementsToCopy(editor, dataContext);
        String copy = CopyReferenceUtil.doCopy(elements2, editor);
        if (copy != null) {
            CopyPasteManager.getInstance().setContents((Transferable)new CopyReferenceFQNTransferable(copy));
            CopyReferenceUtil.setStatusBarText(project, IdeBundle.message((String)"message.reference.to.fqn.has.been.copied", (Object[])new Object[]{copy}));
        } else if (editor != null && project != null) {
            Document document = editor.getDocument();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(document);
            if (file2 != null) {
                String toCopy = CopyReferenceUtil.getFileFqn(file2) + ":" + (editor.getCaretModel().getLogicalPosition().line + 1);
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(toCopy));
                CopyReferenceUtil.setStatusBarText(project, toCopy + " has been copied");
            }
            return;
        }
        CopyReferenceUtil.highlight(editor, project, elements2);
    }

    public static boolean doCopy(PsiElement element, Project project) {
        return CopyReferenceAction.doCopy(Collections.singletonList(element), project);
    }

    private static boolean doCopy(List<? extends PsiElement> elements2, @Nullable Project project) {
        String toCopy = CopyReferenceUtil.doCopy(elements2, null);
        CopyPasteManager.getInstance().setContents((Transferable)new CopyReferenceFQNTransferable(toCopy));
        CopyReferenceUtil.setStatusBarText(project, IdeBundle.message((String)"message.reference.to.fqn.has.been.copied", (Object[])new Object[]{toCopy}));
        return true;
    }

    @Nullable
    public static String elementToFqn(@Nullable PsiElement element) {
        return CopyReferenceUtil.elementToFqn(element, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/actions/CopyReferenceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface VirtualFileQualifiedNameProvider {
        public static final ExtensionPointName<VirtualFileQualifiedNameProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.virtualFileQualifiedNameProvider");

        @Nullable
        public String getQualifiedName(@NotNull Project var1, @NotNull VirtualFile var2);
    }
}

