/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.content.Content;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ActivateToolWindowAction
extends DumbAwareAction {
    private final String myToolWindowId;

    private ActivateToolWindowAction(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(0);
        }
        this.myToolWindowId = toolWindowId;
    }

    @NotNull
    public String getToolWindowId() {
        String string = this.myToolWindowId;
        if (string == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void ensureToolWindowActionRegistered(@NotNull ToolWindowImpl toolWindow) {
        String actionId;
        ActionManager actionManager;
        AnAction action2;
        if (toolWindow == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(2);
        }
        if ((action2 = (actionManager = ActionManager.getInstance()).getAction(actionId = ActivateToolWindowAction.getActionIdForToolWindow(toolWindow.getId()))) == null) {
            ActivateToolWindowAction newAction = new ActivateToolWindowAction(toolWindow.getId());
            newAction.updatePresentation(newAction.getTemplatePresentation(), toolWindow);
            actionManager.registerAction(actionId, (AnAction)newAction);
        }
    }

    public static void updateToolWindowActionPresentation(@NotNull ToolWindowImpl toolWindow) {
        String actionId;
        ActionManager actionManager;
        AnAction action2;
        if (toolWindow == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(3);
        }
        if ((action2 = (actionManager = ActionManager.getInstance()).getAction(actionId = ActivateToolWindowAction.getActionIdForToolWindow(toolWindow.getId()))) instanceof ActivateToolWindowAction) {
            ((ActivateToolWindowAction)action2).updatePresentation(action2.getTemplatePresentation(), toolWindow);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(4);
        }
        Project project = ActivateToolWindowAction.getEventProject((AnActionEvent)e);
        Presentation presentation = e.getPresentation();
        if (project == null || project.isDisposed()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(this.myToolWindowId);
        if (toolWindow == null) {
            presentation.setEnabledAndVisible(false);
        } else {
            presentation.setVisible(true);
            presentation.setEnabled(toolWindow.isAvailable());
            this.updatePresentation(presentation, toolWindow);
        }
    }

    private void updatePresentation(@NotNull Presentation presentation, @NotNull ToolWindow toolWindow) {
        if (presentation == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(5);
        }
        if (toolWindow == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(6);
        }
        String title = toolWindow.getStripeTitle();
        presentation.setText(title);
        presentation.setDescription(IdeBundle.message((String)"action.activate.tool.window", (Object[])new Object[]{title}));
        Icon icon = toolWindow.getIcon();
        if ("Event Log".equals(this.myToolWindowId)) {
            icon = AllIcons.Ide.Notification.InfoEvents;
        }
        presentation.setIcon((Icon)(icon == null ? null : new SizedIcon(icon, icon.getIconHeight(), icon.getIconHeight())));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Content[] contents;
        Project project;
        if (e == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(7);
        }
        if ((project = ActivateToolWindowAction.getEventProject((AnActionEvent)e)) == null) {
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow window = windowManager.getToolWindow(this.myToolWindowId);
        InputEvent event = e.getInputEvent();
        Runnable run2 = null;
        if (event instanceof KeyEvent && event.isShiftDown() && (contents = window.getContentManager().getContents()).length > 0 && window.getContentManager().getSelectedContent() != contents[0]) {
            run2 = () -> window.getContentManager().setSelectedContent(contents[0], true, true);
        }
        if (windowManager.isEditorComponentActive() || !this.myToolWindowId.equals(windowManager.getActiveToolWindowId()) || run2 != null) {
            if (run2 != null && window.isActive()) {
                run2.run();
            } else {
                window.activate(run2);
            }
        } else {
            windowManager.getToolWindow(this.myToolWindowId).hide(null);
        }
    }

    @NonNls
    public static String getActionIdForToolWindow(String id) {
        return "Activate" + id.replaceAll(" ", "") + "ToolWindow";
    }

    public static int getMnemonicForToolWindow(String id) {
        Shortcut[] shortcuts;
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        for (Shortcut shortcut : shortcuts = activeKeymap.getShortcuts(ActivateToolWindowAction.getActionIdForToolWindow(id))) {
            int keyCode;
            KeyStroke keyStroke;
            int modifiers;
            if (!(shortcut instanceof KeyboardShortcut) || (modifiers = (keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke()).getModifiers()) != 520 && modifiers != 8 && modifiers != 512 && modifiers != 260 && modifiers != 4 && modifiers != 256 || 48 > (keyCode = keyStroke.getKeyCode()) || keyCode > 57) continue;
            char c2 = (char)(48 + keyCode - 48);
            return c2;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ActivateToolWindowAction";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ActivateToolWindowAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ensureToolWindowActionRegistered";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateToolWindowActionPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

