/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.RecentChange;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.DirectoryHistoryDialogModel;
import com.intellij.history.integration.ui.models.RecentChangeDialogModel;
import com.intellij.history.integration.ui.views.DirectoryHistoryDialog;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RecentChangeDialog
extends DirectoryHistoryDialog {
    private final RecentChange myChange;

    public RecentChangeDialog(Project p, IdeaGateway gw, RecentChange c2) {
        super(p, gw, null, false);
        this.myChange = c2;
        this.init();
    }

    @Override
    protected DirectoryHistoryDialogModel createModel(LocalHistoryFacade vcs) {
        return new RecentChangeDialogModel(this.myProject, this.myGateway, vcs, this.myChange);
    }

    @Override
    protected JComponent createComponent() {
        JPanel result2 = new JPanel(new BorderLayout());
        result2.add((Component)super.createComponent(), "Center");
        result2.add((Component)this.createButtonsPanel(), "South");
        return result2;
    }

    @Override
    protected boolean showRevisionsList() {
        return false;
    }

    @Override
    protected boolean showSearchField() {
        return false;
    }

    private JPanel createButtonsPanel() {
        AbstractAction revert = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentChangeDialog.this.revert();
                RecentChangeDialog.this.close();
            }
        };
        UIUtil.setActionNameAndMnemonic((String)LocalHistoryBundle.message("action.revert", new Object[0]), (Action)revert);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalGlue());
        p.add(new JButton(revert));
        return p;
    }

    @Override
    protected String getHelpId() {
        return "reference.dialogs.recentChanges";
    }
}

