/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.FormatRangesStorage;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class FormatTextRanges
implements FormattingRangesInfo {
    private final List<TextRange> myInsertedRanges;
    private final FormatRangesStorage myStorage;

    public FormatTextRanges() {
        this.myStorage = new FormatRangesStorage();
        this.myInsertedRanges = null;
    }

    public FormatTextRanges(TextRange range2, boolean processHeadingWhitespace) {
        this.myStorage = new FormatRangesStorage();
        this.myInsertedRanges = null;
        this.add(range2, processHeadingWhitespace);
    }

    public FormatTextRanges(@NotNull ChangedRangesInfo changedRangesInfo) {
        if (changedRangesInfo == null) {
            FormatTextRanges.$$$reportNull$$$0(0);
        }
        this.myStorage = new FormatRangesStorage();
        List<TextRange> optimized = FormatTextRanges.optimizedChangedRanges(changedRangesInfo.allChangedRanges);
        optimized.forEach(range2 -> this.add((TextRange)range2, true));
        this.myInsertedRanges = changedRangesInfo.insertedRanges;
    }

    public void add(TextRange range2, boolean processHeadingWhitespace) {
        this.myStorage.add(range2, processHeadingWhitespace);
    }

    @Override
    public boolean isWhitespaceReadOnly(@NotNull TextRange range2) {
        if (range2 == null) {
            FormatTextRanges.$$$reportNull$$$0(1);
        }
        return this.myStorage.isWhiteSpaceReadOnly(range2);
    }

    @Override
    public boolean isReadOnly(@NotNull TextRange range2) {
        if (range2 == null) {
            FormatTextRanges.$$$reportNull$$$0(2);
        }
        return this.myStorage.isReadOnly(range2);
    }

    @Override
    public boolean isOnInsertedLine(int offset) {
        if (this.myInsertedRanges == null) {
            return false;
        }
        Optional<TextRange> enclosingRange = this.myInsertedRanges.stream().filter(range2 -> range2.contains(offset)).findAny();
        return enclosingRange.isPresent();
    }

    public List<FormatTextRange> getRanges() {
        return this.myStorage.getRanges();
    }

    public FormatTextRanges ensureNonEmpty() {
        FormatTextRanges result2 = new FormatTextRanges();
        for (FormatTextRange range2 : this.myStorage.getRanges()) {
            if (range2.isProcessHeadingWhitespace()) {
                result2.add(range2.getNonEmptyTextRange(), true);
                continue;
            }
            result2.add(range2.getTextRange(), false);
        }
        return result2;
    }

    public boolean isEmpty() {
        return this.myStorage.isEmpty();
    }

    public boolean isFullReformat(PsiFile file2) {
        List<FormatTextRange> ranges2 = this.myStorage.getRanges();
        return ranges2.size() == 1 && file2.getTextRange().equals((Object)ranges2.get(0).getTextRange());
    }

    public List<TextRange> getTextRanges() {
        return ContainerUtil.map(this.myStorage.getRanges(), FormatTextRange::getTextRange);
    }

    public List<TextRange> getExtendedFormattingRanges() {
        return ContainerUtil.map(this.myStorage.getRanges(), range2 -> {
            TextRange textRange = range2.getTextRange();
            return new UnfairTextRange(textRange.getStartOffset() - 500, textRange.getEndOffset() + 500);
        });
    }

    private static List<TextRange> optimizedChangedRanges(@NotNull List<TextRange> allChangedRanges) {
        if (allChangedRanges == null) {
            FormatTextRanges.$$$reportNull$$$0(3);
        }
        if (allChangedRanges.isEmpty()) {
            return allChangedRanges;
        }
        List sorted = ContainerUtil.sorted(allChangedRanges, (Comparator)Segment.BY_START_OFFSET_THEN_END_OFFSET);
        List result2 = ContainerUtil.newSmartList();
        TextRange prev = (TextRange)sorted.get(0);
        for (TextRange next : sorted) {
            if (next.getStartOffset() <= prev.getEndOffset() + 5) {
                int newEndOffset = Math.max(prev.getEndOffset(), next.getEndOffset());
                prev = new TextRange(prev.getStartOffset(), newEndOffset);
                continue;
            }
            result2.add(prev);
            prev = next;
        }
        result2.add(prev);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRangesInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allChangedRanges";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/FormatTextRanges";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhitespaceReadOnly";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadOnly";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "optimizedChangedRanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

