/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShowUsagesTableCellRenderer
implements TableCellRenderer {
    private final UsageViewImpl myUsageView;
    @NotNull
    private final AtomicInteger myOutOfScopeUsages;
    @NotNull
    private final SearchScope mySearchScope;
    private static final int CURRENT_ASTERISK_COL = 0;
    private static final int FILE_GROUP_COL = 1;
    private static final int LINE_NUMBER_COL = 2;
    private static final int USAGE_TEXT_COL = 3;

    ShowUsagesTableCellRenderer(@NotNull UsageViewImpl usageView, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope) {
        if (usageView == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(0);
        }
        if (outOfScopeUsages == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(2);
        }
        this.myUsageView = usageView;
        this.myOutOfScopeUsages = outOfScopeUsages;
        this.mySearchScope = searchScope;
    }

    @Override
    public Component getTableCellRendererComponent(JTable list2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color rowForeground;
        UsageNode usageNode = value instanceof UsageNode ? (UsageNode)value : null;
        Usage usage = usageNode == null ? null : usageNode.getUsage();
        Color fileBgColor = this.getBackgroundColor(isSelected, usage);
        Color selectionBg = UIUtil.getListSelectionBackground();
        Color selectionFg = UIUtil.getListSelectionForeground();
        Color rowBackground = isSelected ? selectionBg : (fileBgColor == null ? list2.getBackground() : fileBgColor);
        Color color = rowForeground = isSelected ? selectionFg : list2.getForeground();
        if (usageNode == null || usageNode instanceof ShowUsagesAction.StringNode) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append(ObjectUtils.notNull((Object)value, (Object)"").toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column, list2);
        }
        if (usage == ShowUsagesTable.MORE_USAGES_SEPARATOR) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append("...<");
            textChunks.append("more usages", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column, list2);
        }
        if (usage == ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append("...<");
            textChunks.append(UsageViewManagerImpl.outOfScopeMessage((int)this.myOutOfScopeUsages.get(), (SearchScope)this.mySearchScope), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column, list2);
        }
        LayoutManager layout = column == 3 ? new BorderLayout() : new FlowLayout(column == 2 ? 2 : 0, 0, 0){

            @Override
            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                for (Component component : container.getComponents()) {
                    Rectangle b = component.getBounds();
                    Insets insets = container.getInsets();
                    component.setBounds(b.x, b.y, b.width, container.getSize().height - insets.top - insets.bottom);
                }
            }
        };
        JPanel panel2 = new JPanel(layout);
        panel2.setFont(null);
        boolean isOriginUsage = this.myUsageView.isOriginUsage(usage);
        if (isOriginUsage) {
            rowBackground = ShowUsagesTableCellRenderer.slightlyDifferentColor(rowBackground);
            if (fileBgColor != null) {
                fileBgColor = ShowUsagesTableCellRenderer.slightlyDifferentColor(fileBgColor);
            }
            selectionBg = ShowUsagesTableCellRenderer.slightlyDifferentColor(selectionBg);
        }
        panel2.setBackground(rowBackground);
        panel2.setForeground(rowForeground);
        SimpleColoredComponent textChunks = new SimpleColoredComponent();
        UsagePresentation presentation = usage.getPresentation();
        TextChunk[] text2 = presentation.getText();
        switch (column) {
            case 0: {
                if (!isOriginUsage) break;
                panel2.add(new JLabel(isSelected ? AllIcons.General.ModifiedSelected : AllIcons.General.Modified));
                break;
            }
            case 1: {
                this.appendGroupText(list2, (GroupNode)usageNode.getParent(), panel2, fileBgColor, isSelected);
                break;
            }
            case 2: {
                if (text2.length != 0) {
                    TextChunk chunk = text2[0];
                    textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, chunk));
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list2, (SimpleColoredComponent)textChunks, (boolean)false, (boolean)isSelected);
                panel2.add((Component)textChunks);
                break;
            }
            case 3: {
                Icon icon = presentation.getIcon();
                textChunks.setIcon(icon == null ? EmptyIcon.ICON_16 : icon);
                textChunks.append("").appendTextPadding(JBUIScale.scale((int)21));
                for (int i = 1; i < text2.length; ++i) {
                    TextChunk chunk = text2[i];
                    textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, chunk));
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list2, (SimpleColoredComponent)textChunks, (boolean)false, (boolean)isSelected);
                panel2.add((Component)textChunks);
                if (!isOriginUsage) break;
                SimpleColoredComponent origin = new SimpleColoredComponent();
                origin.setIconTextGap(JBUIScale.scale((int)5));
                SimpleTextAttributes attributes = text2.length == 0 ? SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, new Color(0x808080), null, null) : ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, text2[0]);
                origin.append("| Current", attributes);
                origin.appendTextPadding(JBUIScale.scale((int)45));
                panel2.add((Component)origin, "East");
                break;
            }
            default: {
                throw new IllegalStateException("unknown column: " + column);
            }
        }
        return panel2;
    }

    @NotNull
    private static Color slightlyDifferentColor(@NotNull Color back) {
        if (back == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(3);
        }
        Color color = EditorColorsManager.getInstance().isDarkEditor() ? ColorUtil.brighter((Color)back, (int)3) : ColorUtil.hackBrightness((Color)back, (int)1, (float)0.952381f);
        if (color == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(4);
        }
        return color;
    }

    @NotNull
    private static SimpleTextAttributes getAttributes(boolean isSelected, Color fileBgColor, Color selectionBg, Color selectionFg, @NotNull TextChunk chunk) {
        if (chunk == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(5);
        }
        SimpleTextAttributes background = chunk.getSimpleAttributesIgnoreBackground();
        SimpleTextAttributes simpleTextAttributes = isSelected ? new SimpleTextAttributes(selectionBg, selectionFg, null, background.getStyle()) : ShowUsagesTableCellRenderer.deriveBgColor(background, fileBgColor);
        if (simpleTextAttributes == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(6);
        }
        return simpleTextAttributes;
    }

    @NotNull
    private static Component textComponentSpanningWholeRow(@NotNull SimpleColoredComponent chunks, Color rowBackground, Color rowForeground, final int column, final @NotNull JTable table) {
        if (chunks == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(7);
        }
        if (table == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(8);
        }
        SimpleColoredComponent component = new SimpleColoredComponent(){

            protected void doPaint(Graphics2D g) {
                int offset = 0;
                TableColumnModel columnModel = table.getColumnModel();
                for (int i = 0; i < column; ++i) {
                    offset += columnModel.getColumn(i).getWidth();
                }
                g.translate(-offset, 0);
                this.setSize(this.getWidth() + offset, this.getHeight());
                super.doPaint(g);
                g.translate(offset, 0);
            }

            @NotNull
            public Dimension getPreferredSize() {
                Dimension dimension = column == table.getColumnModel().getColumnCount() - 1 ? super.getPreferredSize() : new Dimension(0, 0);
                if (dimension == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dimension;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesTableCellRenderer$2", "getPreferredSize"));
            }
        };
        component.setBackground(rowBackground);
        component.setForeground(rowForeground);
        SimpleColoredComponent.ColoredIterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            String fragment = iterator.getFragment();
            SimpleTextAttributes attributes = iterator.getTextAttributes();
            attributes = attributes.derive(attributes.getStyle(), rowForeground, rowBackground, attributes.getWaveColor());
            component.append(fragment, attributes);
        }
        SimpleColoredComponent simpleColoredComponent = component;
        if (simpleColoredComponent == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(9);
        }
        return simpleColoredComponent;
    }

    @NotNull
    private static SimpleTextAttributes deriveBgColor(@NotNull SimpleTextAttributes attributes, @Nullable Color fileBgColor) {
        if (attributes == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(10);
        }
        if (fileBgColor != null) {
            attributes = attributes.derive(-1, null, fileBgColor, null);
        }
        SimpleTextAttributes simpleTextAttributes = attributes;
        if (simpleTextAttributes == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(11);
        }
        return simpleTextAttributes;
    }

    private Color getBackgroundColor(boolean isSelected, Usage usage) {
        Color fileBgColor = null;
        if (isSelected) {
            fileBgColor = UIUtil.getListSelectionBackground();
        } else {
            Project project;
            Color color;
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = usage instanceof UsageInFile ? ((UsageInFile)usage).getFile() : null;
            if (virtualFile != null && (color = VfsPresentationUtil.getFileBackgroundColor(project = this.myUsageView.getProject(), virtualFile)) != null) {
                fileBgColor = color;
            }
        }
        return fileBgColor;
    }

    private void appendGroupText(@NotNull JTable table, GroupNode node, @NotNull JPanel panel2, Color fileBgColor, boolean isSelected) {
        UsageGroup group;
        if (table == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(12);
        }
        if (panel2 == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(13);
        }
        UsageGroup usageGroup = group = node == null ? null : node.getGroup();
        if (group == null) {
            return;
        }
        GroupNode parentGroup = (GroupNode)node.getParent();
        this.appendGroupText(table, parentGroup, panel2, fileBgColor, isSelected);
        if (node.canNavigateToSource()) {
            SimpleColoredComponent renderer2 = new SimpleColoredComponent();
            renderer2.setIcon(group.getIcon(false));
            SimpleTextAttributes attributes = ShowUsagesTableCellRenderer.deriveBgColor(SimpleTextAttributes.REGULAR_ATTRIBUTES, fileBgColor);
            renderer2.append(group.getText((UsageView)this.myUsageView), attributes);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)renderer2, (boolean)false, (boolean)isSelected);
            panel2.add((Component)renderer2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outOfScopeUsages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "back";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesTableCellRenderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesTableCellRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "slightlyDifferentColor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "textComponentSpanningWholeRow";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveBgColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "slightlyDifferentColor";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "textComponentSpanningWholeRow";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deriveBgColor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendGroupText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

