/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationTypeUsagesCollector
extends ProjectUsagesCollector {
    public static final String FACTORY_FIELD = "factory";

    @Override
    @NotNull
    public String getGroupId() {
        if ("run.configuration.type" == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(0);
        }
        return "run.configuration.type";
    }

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(1);
        }
        TObjectIntHashMap templates = new TObjectIntHashMap();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project.isDisposed()) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            for (RunnerAndConfigurationSettings settings : runManager.getAllSettings()) {
                Template template;
                RunConfiguration runConfiguration = settings.getConfiguration();
                ConfigurationFactory configurationFactory = runConfiguration.getFactory();
                if (configurationFactory == null) continue;
                ConfigurationType configurationType = configurationFactory.getType();
                String eventId = RunConfigurationTypeUsagesCollector.toConfigurationId(configurationType);
                FeatureUsageData data = RunConfigurationTypeUsagesCollector.createData(settings, runConfiguration);
                if (configurationType.getConfigurationFactories().length > 1) {
                    data.addData(FACTORY_FIELD, configurationFactory.getId());
                }
                if (templates.containsKey((Object)(template = new Template(eventId, data)))) {
                    templates.increment((Object)template);
                    continue;
                }
                templates.put((Object)template, 1);
            }
        });
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        templates.forEachEntry((template, value) -> result2.add(((Template)template).createMetricEvent(value)));
        HashSet<MetricEvent> hashSet = result2;
        if (hashSet == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    public static String toConfigurationId(@NotNull ConfigurationType configurationType) {
        if (configurationType == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(3);
        }
        String string = configurationType instanceof UnknownConfigurationType ? "unknown" : configurationType.getId();
        if (string == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static FeatureUsageData createData(@NotNull RunnerAndConfigurationSettings settings, @NotNull RunConfiguration runConfiguration) {
        if (settings == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(5);
        }
        if (runConfiguration == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(6);
        }
        return new FeatureUsageData().addData("shared", settings.isShared()).addData("edit_before_run", settings.isEditBeforeRun()).addData("activate_before_run", settings.isActivateToolWindowBeforeRun()).addData("parallel", runConfiguration.isAllowRunningInParallel()).addData("temporary", settings.isTemporary());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toConfigurationId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toConfigurationId";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RunConfigurationUtilValidator
    extends CustomWhiteListRule {
        @Override
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "run_config".equals(ruleId) || "run_config_factory".equals(ruleId);
        }

        @Override
        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            String factoryId;
            if (data == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(1);
            }
            if (RunConfigurationUtilValidator.isThirdPartyValue(data) || "unknown".equals(data)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    RunConfigurationUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            String configurationId = context.eventId;
            String string = factoryId = context.eventData.containsKey(RunConfigurationTypeUsagesCollector.FACTORY_FIELD) ? context.eventData.get(RunConfigurationTypeUsagesCollector.FACTORY_FIELD).toString() : null;
            if (StringUtil.equals((CharSequence)data, (CharSequence)configurationId) || StringUtil.equals((CharSequence)data, (CharSequence)factoryId)) {
                Pair<ConfigurationType, ConfigurationFactory> configurationAndFactory = RunConfigurationUtilValidator.findConfigurationAndFactory(configurationId, factoryId);
                ConfigurationType configuration = (ConfigurationType)configurationAndFactory.getFirst();
                ConfigurationFactory factory = (ConfigurationFactory)configurationAndFactory.getSecond();
                if (configuration != null && (StringUtil.isEmpty((String)factoryId) || factory != null)) {
                    PluginInfo info = PluginInfoDetectorKt.getPluginInfo(configuration.getClass());
                    if (StringUtil.equals((CharSequence)data, (CharSequence)context.eventId)) {
                        context.setPluginInfo(info);
                    }
                    ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                    if (validationResultType == null) {
                        RunConfigurationUtilValidator.$$$reportNull$$$0(3);
                    }
                    return validationResultType;
                }
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        @NotNull
        private static Pair<ConfigurationType, ConfigurationFactory> findConfigurationAndFactory(@NotNull String configurationId, @Nullable String factoryId) {
            ConfigurationType configuration;
            if (configurationId == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(5);
            }
            if ((configuration = RunConfigurationUtilValidator.findRunConfigurationById(configurationId)) == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    RunConfigurationUtilValidator.$$$reportNull$$$0(6);
                }
                return pair;
            }
            ConfigurationFactory factory = StringUtil.isEmpty((String)factoryId) ? null : RunConfigurationUtilValidator.findFactoryById(configuration, factoryId);
            Pair pair = Pair.create((Object)configuration, (Object)factory);
            if (pair == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(7);
            }
            return pair;
        }

        @Nullable
        private static ConfigurationType findRunConfigurationById(@NotNull String configuration) {
            ConfigurationType[] types;
            if (configuration == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(8);
            }
            for (ConfigurationType type : types = (ConfigurationType[])ConfigurationType.CONFIGURATION_TYPE_EP.getExtensions()) {
                if (!StringUtil.equals((CharSequence)type.getId(), (CharSequence)configuration)) continue;
                return type;
            }
            return null;
        }

        @Nullable
        private static ConfigurationFactory findFactoryById(@NotNull ConfigurationType configuration, @NotNull String factoryId) {
            if (configuration == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(9);
            }
            if (factoryId == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(10);
            }
            for (ConfigurationFactory factory : configuration.getConfigurationFactories()) {
                if (!StringUtil.equals((CharSequence)factory.getId(), (CharSequence)factoryId)) continue;
                return factory;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector$RunConfigurationUtilValidator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationId";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factoryId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector$RunConfigurationUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findConfigurationAndFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findConfigurationAndFactory";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findRunConfigurationById";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findFactoryById";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Template {
        private final String myKey;
        private final FeatureUsageData myData;

        private Template(String key, FeatureUsageData data) {
            this.myKey = key;
            this.myData = data;
        }

        @NotNull
        private MetricEvent createMetricEvent(int count) {
            MetricEvent metricEvent = MetricEventFactoryKt.newCounterMetric(this.myKey, count, this.myData);
            if (metricEvent == null) {
                Template.$$$reportNull$$$0(0);
            }
            return metricEvent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            return Objects.equals(this.myKey, template.myKey) && Objects.equals(this.myData, template.myData);
        }

        public int hashCode() {
            return Objects.hash(this.myKey, this.myData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector$Template", "createMetricEvent"));
        }
    }
}

