/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.google.common.collect.ImmutableMap;
import com.intellij.execution.configurations.GeneralCommandLine;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class EnvironmentVariablesData {
    public static final EnvironmentVariablesData DEFAULT = new EnvironmentVariablesData((Map<String, String>)ImmutableMap.of(), true);
    private static final String ENVS = "envs";
    private static final String PASS_PARENT_ENVS = "pass-parent-envs";
    private static final String ENV = "env";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private final ImmutableMap<String, String> myEnvs;
    private final boolean myPassParentEnvs;

    private EnvironmentVariablesData(@NotNull Map<String, String> envs, boolean passParentEnvs) {
        if (envs == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(0);
        }
        this.myEnvs = ImmutableMap.copyOf(envs);
        this.myPassParentEnvs = passParentEnvs;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        ImmutableMap<String, String> immutableMap = this.myEnvs;
        if (immutableMap == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(1);
        }
        return immutableMap;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentVariablesData data = (EnvironmentVariablesData)o;
        return this.myPassParentEnvs == data.myPassParentEnvs && this.myEnvs.equals(data.myEnvs);
    }

    public int hashCode() {
        int result2 = this.myEnvs.hashCode();
        result2 = 31 * result2 + (this.myPassParentEnvs ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "envs=" + this.myEnvs + ", passParentEnvs=" + this.myPassParentEnvs;
    }

    @NotNull
    public static EnvironmentVariablesData readExternal(@NotNull Element element) {
        Element envsElement;
        if (element == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(2);
        }
        if ((envsElement = element.getChild(ENVS)) == null) {
            EnvironmentVariablesData environmentVariablesData = DEFAULT;
            if (environmentVariablesData == null) {
                EnvironmentVariablesData.$$$reportNull$$$0(3);
            }
            return environmentVariablesData;
        }
        Object envs = ImmutableMap.of();
        String passParentEnvsStr = envsElement.getAttributeValue(PASS_PARENT_ENVS);
        boolean passParentEnvs = passParentEnvsStr == null || Boolean.parseBoolean(passParentEnvsStr);
        for (Element envElement : envsElement.getChildren(ENV)) {
            String envName = envElement.getAttributeValue(NAME);
            String envValue = envElement.getAttributeValue(VALUE);
            if (envName == null || envValue == null) continue;
            if (envs.isEmpty()) {
                envs = new LinkedHashMap();
            }
            envs.put(envName, envValue);
        }
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create((Map<String, String>)envs, passParentEnvs);
        if (environmentVariablesData == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(4);
        }
        return environmentVariablesData;
    }

    public void writeExternal(@NotNull Element parent) {
        if (parent == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(5);
        }
        Element envsElement = new Element(ENVS);
        if (!this.myPassParentEnvs) {
            envsElement.setAttribute(PASS_PARENT_ENVS, Boolean.FALSE.toString());
        }
        for (Map.Entry entry : this.myEnvs.entrySet()) {
            envsElement.addContent(new Element(ENV).setAttribute(NAME, (String)entry.getKey()).setAttribute(VALUE, (String)entry.getValue()));
        }
        parent.addContent(envsElement);
    }

    public void configureCommandLine(@NotNull GeneralCommandLine commandLine, boolean consoleParentEnvs) {
        if (commandLine == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(6);
        }
        commandLine.withParentEnvironmentType(!this.myPassParentEnvs ? GeneralCommandLine.ParentEnvironmentType.NONE : (consoleParentEnvs ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.SYSTEM));
        commandLine.withEnvironment(this.myEnvs);
    }

    @NotNull
    public static EnvironmentVariablesData create(@NotNull Map<String, String> envs, boolean passParentEnvs) {
        if (envs == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(7);
        }
        EnvironmentVariablesData environmentVariablesData = passParentEnvs && envs.isEmpty() ? DEFAULT : new EnvironmentVariablesData(envs, passParentEnvs);
        if (environmentVariablesData == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(8);
        }
        return environmentVariablesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = ENVS;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configuration/EnvironmentVariablesData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configuration/EnvironmentVariablesData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

