/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.SuggestUsingRunDashBoardUtil;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContextAction
extends BaseRunConfigurationAction {
    private final Executor myExecutor;

    public RunContextAction(final @NotNull Executor executor) {
        if (executor == null) {
            RunContextAction.$$$reportNull$$$0(0);
        }
        super(ExecutionBundle.message((String)"perform.action.with.context.configuration.action.name", (Object[])new Object[]{executor.getStartActionText()}), null, (Icon)new IconLoader.LazyIcon(){

            protected Icon compute() {
                return executor.getIcon();
            }
        });
        this.myExecutor = executor;
    }

    @Override
    protected void perform(ConfigurationContext context) {
        RunnerAndConfigurationSettings configuration = context.findExisting();
        RunManagerEx runManager = (RunManagerEx)context.getRunManager();
        if (configuration == null) {
            configuration = context.getConfiguration();
            if (configuration == null) {
                return;
            }
            runManager.setTemporaryConfiguration(configuration);
        }
        if (Registry.is((String)"select.run.configuration.from.context")) {
            runManager.setSelectedConfiguration(configuration);
        }
        ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)this.myExecutor, null, null, (DataContext)context.getDataContext());
    }

    @Override
    protected boolean isEnabledFor(RunConfiguration configuration) {
        return this.getRunner(configuration) != null;
    }

    @Nullable
    private ProgramRunner getRunner(RunConfiguration configuration) {
        return ProgramRunner.getRunner((String)this.myExecutor.getId(), (RunProfile)configuration);
    }

    @Override
    protected void updatePresentation(Presentation presentation, @NotNull String actionText, ConfigurationContext context) {
        if (actionText == null) {
            RunContextAction.$$$reportNull$$$0(1);
        }
        presentation.setText(this.myExecutor.getStartActionText(actionText), true);
        Pair<Boolean, Boolean> b = this.isEnabledAndVisible(context);
        presentation.setEnabled(((Boolean)b.first).booleanValue());
        presentation.setVisible(((Boolean)b.second).booleanValue());
    }

    private Pair<Boolean, Boolean> isEnabledAndVisible(ConfigurationContext context) {
        ProgramRunner runner;
        RunnerAndConfigurationSettings configuration = context.findExisting();
        if (configuration == null) {
            configuration = context.getConfiguration();
        }
        ProgramRunner programRunner = runner = configuration == null ? null : this.getRunner(configuration.getConfiguration());
        if (runner == null) {
            return Pair.create((Object)false, (Object)false);
        }
        return Pair.create((Object)(!ExecutorRegistry.getInstance().isStarting(context.getProject(), this.myExecutor.getId(), runner.getRunnerId()) ? 1 : 0), (Object)true);
    }

    @Override
    @NotNull
    protected List<AnAction> createChildActions(@NotNull ConfigurationContext context, @NotNull List<? extends ConfigurationFromContext> configurations) {
        if (context == null) {
            RunContextAction.$$$reportNull$$$0(2);
        }
        if (configurations == null) {
            RunContextAction.$$$reportNull$$$0(3);
        }
        ArrayList<AnAction> childActions = new ArrayList<AnAction>(super.createChildActions(context, configurations));
        boolean isMultipleConfigurationsFromAlternativeLocations = configurations.size() > 1 && configurations.get(0).isFromAlternativeLocation();
        boolean isRunAction = this.myExecutor.getId().equals(DefaultRunExecutor.EXECUTOR_ID);
        if (isMultipleConfigurationsFromAlternativeLocations && isRunAction) {
            childActions.add(this.runAllConfigurationsAction(context, configurations));
        }
        ArrayList<AnAction> arrayList = childActions;
        if (arrayList == null) {
            RunContextAction.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private AnAction runAllConfigurationsAction(final @NotNull ConfigurationContext context, final @NotNull List<? extends ConfigurationFromContext> configurationsFromContext) {
        if (context == null) {
            RunContextAction.$$$reportNull$$$0(5);
        }
        if (configurationsFromContext == null) {
            RunContextAction.$$$reportNull$$$0(6);
        }
        AnAction anAction = new AnAction("Run all", "Run all configurations available in this context", AllIcons.RunConfigurations.Compound){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                long groupId = ExecutionEnvironment.getNextUnusedExecutionId();
                List types = ContainerUtil.map((Collection)configurationsFromContext, context1 -> context1.getConfiguration().getType());
                SuggestUsingRunDashBoardUtil.promptUserToUseRunDashboard((Project)context.getProject(), (Collection)types);
                for (ConfigurationFromContext configuration : configurationsFromContext) {
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration.getConfigurationSettings(), (Executor)RunContextAction.this.myExecutor, (long)groupId);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/actions/RunContextAction$2", "actionPerformed"));
            }
        };
        if (anAction == null) {
            RunContextAction.$$$reportNull$$$0(7);
        }
        return anAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionText";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/RunContextAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationsFromContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/RunContextAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "runAllConfigurationsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createChildActions";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runAllConfigurationsAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

