/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionMode;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PairConsumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionModes {
    private static final Logger LOG = Logger.getInstance(ExecutionMode.class);
    private static final PairConsumer<ExecutionMode, String> DEFAULT_TIMEOUT_CALLBACK = (mode, presentableCmdLine) -> LOG.error("Timeout (" + mode.getTimeout() + " sec) on executing: " + presentableCmdLine);

    public static class SameThreadMode
    extends ExecutionMode {
        private final int myTimeout;
        @NotNull
        private final PairConsumer<ExecutionMode, String> myTimeoutCallback;

        public SameThreadMode(boolean cancelable, @Nullable String title2, int timeout) {
            this(cancelable, title2, timeout, (PairConsumer<ExecutionMode, String>)DEFAULT_TIMEOUT_CALLBACK);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
        public SameThreadMode(boolean cancelable, @Nullable String title2, int timeout, @NotNull PairConsumer<ExecutionMode, String> timeoutCallback) {
            if (timeoutCallback == null) {
                SameThreadMode.$$$reportNull$$$0(0);
            }
            super(cancelable, null, title2, false, false, null);
            this.myTimeout = timeout;
            this.myTimeoutCallback = timeoutCallback;
        }

        public SameThreadMode(@Nullable String title2) {
            this(true, title2, -1);
        }

        public SameThreadMode(boolean cancelable) {
            this(cancelable, null, -1);
        }

        public SameThreadMode(int timeout) {
            this(false, null, timeout);
        }

        public SameThreadMode() {
            this(true);
        }

        @Override
        public int getTimeout() {
            return this.myTimeout;
        }

        @Override
        public void onTimeout(@NotNull ProcessHandler processHandler2, @NotNull String commandLineString, @NotNull ProcessOutput outputCollected, @Nullable Throwable invocatorStack) {
            if (processHandler2 == null) {
                SameThreadMode.$$$reportNull$$$0(1);
            }
            if (commandLineString == null) {
                SameThreadMode.$$$reportNull$$$0(2);
            }
            if (outputCollected == null) {
                SameThreadMode.$$$reportNull$$$0(3);
            }
            super.onTimeout(processHandler2, commandLineString, outputCollected, invocatorStack);
            String output = "\n    stdout: " + outputCollected.getStdout() + ";\n    stderr: " + outputCollected.getStderr();
            LOG.error(new Throwable("Timeout (" + this.getTimeout() + " sec) on executing: " + commandLineString + "; output collected: " + output, invocatorStack));
        }

        @Override
        @Deprecated
        @NotNull
        public PairConsumer<ExecutionMode, String> getTimeoutCallback() {
            PairConsumer<ExecutionMode, String> pairConsumer = this.myTimeoutCallback;
            if (pairConsumer == null) {
                SameThreadMode.$$$reportNull$$$0(4);
            }
            return pairConsumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeoutCallback";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLineString";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputCollected";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ExecutionModes$SameThreadMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ExecutionModes$SameThreadMode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeoutCallback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onTimeout";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ModalProgressMode
    extends ExecutionMode {
        public ModalProgressMode(boolean cancelable, @Nullable String title, JComponent progressParentComponent) {
            super(cancelable, title, null, false, true, progressParentComponent);
        }

        public ModalProgressMode(@Nullable String title) {
            this(true, title, null);
        }

        public ModalProgressMode(@Nullable String title, JComponent progressParentComponent) {
            this(true, title, progressParentComponent);
        }
    }

    public static class BackGroundMode
    extends ExecutionMode {
        public BackGroundMode(boolean cancelable, @Nullable String title) {
            super(cancelable, title, null, true, false, null);
        }

        public BackGroundMode(@Nullable String title) {
            this(true, title);
        }
    }
}

