/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogConsoleImpl;
import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import gnu.trove.THashMap;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogConsoleManagerBase
implements LogConsoleManager,
Disposable {
    private final Project myProject;
    private final Map<AdditionalTabComponent, Content> myAdditionalContent;
    private final GlobalSearchScope mySearchScope;

    protected LogConsoleManagerBase(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(1);
        }
        this.myAdditionalContent = new THashMap();
        this.myProject = project;
        this.mySearchScope = searchScope;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addLogConsole(@NotNull String name, final @NotNull String path, @NotNull Charset charset, long skippedContent, @NotNull RunConfigurationBase runConfigurationBase) {
        void runConfiguration;
        if (name == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(2);
        }
        if (path == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(3);
        }
        if (charset == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(4);
        }
        if (runConfigurationBase == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(5);
        }
        this.doAddLogConsole(new LogConsoleImpl(this.myProject, new File(path), charset, skippedContent, name, false, this.mySearchScope){

            @Override
            public boolean isActive() {
                return LogConsoleManagerBase.this.isConsoleActive(path);
            }
        }, path, this.getDefaultIcon(), (RunProfile)runConfiguration);
    }

    private void doAddLogConsole(final @NotNull LogConsoleBase log2, String id, Icon icon, @Nullable RunProfile runProfile) {
        if (log2 == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(6);
        }
        if (runProfile instanceof RunConfigurationBase) {
            ((RunConfigurationBase)runProfile).customizeLogConsole((LogConsole)log2);
        }
        log2.attachStopLogConsoleTrackingListener(this.getProcessHandler());
        this.addAdditionalTabComponent(log2, id, icon);
        this.getUi().addListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                log2.activate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/logging/LogConsoleManagerBase$2", "selectionChanged"));
            }
        }, (Disposable)log2);
    }

    private boolean isConsoleActive(String id) {
        Content content2 = this.getUi().findContent(id);
        return content2 != null && content2.isSelected();
    }

    @Override
    public void removeLogConsole(@NotNull String path) {
        Content content2;
        if (path == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(7);
        }
        if ((content2 = this.getUi().findContent(path)) != null) {
            this.removeAdditionalTabComponent((LogConsoleBase)((Object)content2.getComponent()));
        }
    }

    public void addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id) {
        if (tabComponent == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(8);
        }
        if (id == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(9);
        }
        this.addAdditionalTabComponent(tabComponent, id, this.getDefaultIcon());
    }

    public Content addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id, @Nullable Icon icon) {
        if (tabComponent == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(10);
        }
        if (id == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(11);
        }
        return this.addAdditionalTabComponent(tabComponent, id, icon, true);
    }

    public Content addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id, @Nullable Icon icon, boolean closeable) {
        if (tabComponent == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(12);
        }
        if (id == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(13);
        }
        Content logContent = this.getUi().createContent(id, (ComponentWithActions)tabComponent, tabComponent.getTabTitle(), icon, tabComponent.getPreferredFocusableComponent());
        logContent.setCloseable(closeable);
        this.myAdditionalContent.put(tabComponent, logContent);
        this.getUi().addContent(logContent);
        return logContent;
    }

    public void removeAdditionalTabComponent(@NotNull AdditionalTabComponent component) {
        if (component == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(14);
        }
        Disposer.dispose((Disposable)component);
        Content content2 = this.myAdditionalContent.remove(component);
        if (!this.getUi().isDisposed()) {
            this.getUi().removeContent(content2, true);
        }
    }

    public void dispose() {
        for (AdditionalTabComponent component : this.myAdditionalContent.keySet().toArray(new AdditionalTabComponent[0])) {
            this.removeAdditionalTabComponent(component);
        }
    }

    protected abstract Icon getDefaultIcon();

    protected abstract RunnerLayoutUi getUi();

    public abstract ProcessHandler getProcessHandler();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabComponent";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/logging/LogConsoleManagerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addLogConsole";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddLogConsole";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeLogConsole";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addAdditionalTabComponent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAdditionalTabComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

