/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.GenerateJarAccessLogActionKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/GenerateJarAccessLogActivity;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
public final class GenerateJarAccessLogActivity
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!Registry.is((String)"ide.reorder.jars.in.classpath")) {
            return;
        }
        File orderFile = new File(PathManager.getSystemPath(), "classpath-order.txt");
        if (!orderFile.exists()) {
            try {
                ClassLoader classLoader = GenerateJarAccessLogActivity.class.getClassLoader();
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"GenerateJarAccessLogActi\u2026y::class.java.classLoader");
                String string = orderFile.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"orderFile.path");
                GenerateJarAccessLogActionKt.generateJarAccessLog(classLoader, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

