/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.codeInspection.export.InspectionTreeHtmlWriter;
import com.intellij.codeInspection.ui.AggregateResultsExporter;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExportHTMLAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ExportHTMLAction.class);
    private final InspectionResultsView myView;
    @NonNls
    private static final String ROOT = "root";
    @NonNls
    private static final String AGGREGATE = "_aggregate";
    @NonNls
    private static final String HTML = "HTML";
    @NonNls
    private static final String XML = "XML";

    public ExportHTMLAction(InspectionResultsView view) {
        super(InspectionsBundle.message((String)"inspection.action.export.html", (Object[])new Object[0]), null, AllIcons.ToolbarDecorator.Export);
        this.myView = view;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportHTMLAction.$$$reportNull$$$0(0);
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(InspectionsBundle.message((String)"inspection.action.export.popup.title", (Object[])new Object[0]), new String[]{HTML, XML}){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> ExportHTMLAction.this.exportHTML(Comparing.strEqual((String)selectedValue, (String)ExportHTMLAction.HTML)));
            }
        });
        InspectionResultsView.showPopup(e, (JBPopup)popup2);
    }

    private void exportHTML(boolean exportToHTML) {
        ExportToHTMLDialog exportToHTMLDialog = new ExportToHTMLDialog(this.myView.getProject(), exportToHTML);
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(this.myView.getProject());
        if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
            exportToHTMLSettings.OUTPUT_DIRECTORY = PathManager.getHomePath() + File.separator + "inspections";
        }
        exportToHTMLDialog.reset();
        if (!exportToHTMLDialog.showAndGet()) {
            return;
        }
        exportToHTMLDialog.apply();
        String outputDirectoryName = exportToHTMLSettings.OUTPUT_DIRECTORY;
        ApplicationManager.getApplication().invokeLater(() -> {
            Runnable exportRunnable = () -> ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myView.isDisposed()) {
                    return;
                }
                if (!exportToHTML) {
                    this.dump2xml(outputDirectoryName);
                } else {
                    try {
                        new InspectionTreeHtmlWriter(this.myView, outputDirectoryName);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                }
            });
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(exportRunnable, InspectionsBundle.message((String)(exportToHTML ? "inspection.generating.html.progress.title" : "inspection.generating.xml.progress.title"), (Object[])new Object[0]), true, this.myView.getProject())) {
                return;
            }
            if (exportToHTML && exportToHTMLSettings.OPEN_IN_BROWSER) {
                BrowserUtil.browse((File)new File(exportToHTMLSettings.OUTPUT_DIRECTORY, "index.html"));
            }
        });
    }

    private void dump2xml(String outputDirectoryName) {
        try {
            File outputDir = new File(outputDirectoryName);
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new IOException("Cannot create '" + outputDir + "'");
            }
            Format format = JDOMUtil.createFormat((String)"\n");
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            InspectionProfileImpl profile2 = this.myView.getCurrentProfile();
            String singleTool = profile2.getSingleTool();
            MultiMap shortName2Wrapper = new MultiMap();
            if (singleTool != null) {
                shortName2Wrapper.put((Object)singleTool, this.getWrappersForAllScopes(singleTool));
            } else {
                InspectionTreeModel model2 = this.myView.getTree().getInspectionTreeModel();
                model2.traverse(model2.getRoot()).filter(InspectionNode.class).filter(n -> !n.isExcluded()).map(InspectionNode::getToolWrapper).forEach(w -> shortName2Wrapper.putValue((Object)w.getShortName(), w));
            }
            for (Map.Entry entry : shortName2Wrapper.entrySet()) {
                String shortName = (String)entry.getKey();
                Collection wrappers = (Collection)entry.getValue();
                this.writeInspectionResult(shortName, wrappers, outputDirectoryName, format, xmlOutputFactory);
            }
            this.writeProfileName(outputDirectoryName);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Component)this.myView, (String)e.getMessage()));
        }
    }

    private void writeInspectionResult(@NotNull String shortName, @NotNull Collection<? extends InspectionToolWrapper> wrappers, String outputDirectoryName, @NotNull Format format, @NotNull XMLOutputFactory xmlOutputFactory) {
        if (shortName == null) {
            ExportHTMLAction.$$$reportNull$$$0(1);
        }
        if (wrappers == null) {
            ExportHTMLAction.$$$reportNull$$$0(2);
        }
        if (format == null) {
            ExportHTMLAction.$$$reportNull$$$0(3);
        }
        if (xmlOutputFactory == null) {
            ExportHTMLAction.$$$reportNull$$$0(4);
        }
        if (wrappers.isEmpty()) {
            return;
        }
        try (XmlWriterWrapper reportWriter = new XmlWriterWrapper(this.myView.getProject(), outputDirectoryName, shortName, xmlOutputFactory, format, "problems");
             XmlWriterWrapper aggregateWriter = new XmlWriterWrapper(this.myView.getProject(), outputDirectoryName, shortName + AGGREGATE, xmlOutputFactory, format, ROOT);){
            reportWriter.checkOpen();
            for (InspectionToolWrapper inspectionToolWrapper : wrappers) {
                InspectionToolPresentation presentation = this.myView.getGlobalInspectionContext().getPresentation(inspectionToolWrapper);
                presentation.exportResults(reportWriter::writeElement, presentation::isExcluded, presentation::isExcluded);
                if (!(presentation instanceof AggregateResultsExporter)) continue;
                ((AggregateResultsExporter)((Object)presentation)).exportAggregateResults(aggregateWriter::writeElement);
            }
        }
    }

    private void writeProfileName(String outputDirectoryName) throws IOException {
        Element element = new Element("inspections");
        element.setAttribute("profile", this.myView.getCurrentProfileName());
        JDOMUtil.write((Element)element, (File)new File(outputDirectoryName, ".descriptions.xml"), (String)CodeStyle.getDefaultSettings().getLineSeparator());
    }

    @NotNull
    public static BufferedWriter getWriter(String outputDirectoryName, String name) throws FileNotFoundException {
        File file2 = ExportHTMLAction.getInspectionResultFile(outputDirectoryName, name);
        FileUtil.createParentDirs((File)file2);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), StandardCharsets.UTF_8));
        if (bufferedWriter == null) {
            ExportHTMLAction.$$$reportNull$$$0(5);
        }
        return bufferedWriter;
    }

    @NotNull
    public static File getInspectionResultFile(String outputDirectoryName, String name) {
        File file2 = new File(outputDirectoryName, name + ".xml");
        if (file2 == null) {
            ExportHTMLAction.$$$reportNull$$$0(6);
        }
        return file2;
    }

    @NotNull
    public static Path getInspectionResultPath(String outputDirectoryName, String name) {
        Path path = Paths.get(outputDirectoryName, name + ".xml");
        if (path == null) {
            ExportHTMLAction.$$$reportNull$$$0(7);
        }
        return path;
    }

    @NotNull
    private Collection<InspectionToolWrapper> getWrappersForAllScopes(@NotNull String shortName) {
        GlobalInspectionContextImpl context;
        Tools tools;
        if (shortName == null) {
            ExportHTMLAction.$$$reportNull$$$0(8);
        }
        if ((tools = (context = this.myView.getGlobalInspectionContext()).getTools().get(shortName)) != null) {
            List list2 = ContainerUtil.map((Collection)tools.getTools(), ScopeToolState::getTool);
            if (list2 == null) {
                ExportHTMLAction.$$$reportNull$$$0(9);
            }
            return list2;
        }
        List<InspectionToolWrapper> list3 = Collections.emptyList();
        if (list3 == null) {
            ExportHTMLAction.$$$reportNull$$$0(10);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlOutputFactory";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/actions/ExportHTMLAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/actions/ExportHTMLAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionResultFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionResultPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappersForAllScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeInspectionResult";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWrappersForAllScopes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class XmlWriterWrapperException
    extends RuntimeException {
        private XmlWriterWrapperException(Throwable cause) {
            super(cause.getMessage(), cause);
        }
    }

    private static class XmlWriterWrapper
    implements Closeable {
        private final Project myProject;
        private final String myOutputDirectoryName;
        private final String myName;
        private final XMLOutputFactory myFactory;
        private final Format myFormat;
        private final String myRootTagName;
        private XMLStreamWriter myXmlWriter;
        private Writer myFileWriter;

        XmlWriterWrapper(@NotNull Project project, @NotNull String outputDirectoryName, @NotNull String name, @NotNull XMLOutputFactory factory, @NotNull Format format, @NotNull String rootTagName) {
            if (project == null) {
                XmlWriterWrapper.$$$reportNull$$$0(0);
            }
            if (outputDirectoryName == null) {
                XmlWriterWrapper.$$$reportNull$$$0(1);
            }
            if (name == null) {
                XmlWriterWrapper.$$$reportNull$$$0(2);
            }
            if (factory == null) {
                XmlWriterWrapper.$$$reportNull$$$0(3);
            }
            if (format == null) {
                XmlWriterWrapper.$$$reportNull$$$0(4);
            }
            if (rootTagName == null) {
                XmlWriterWrapper.$$$reportNull$$$0(5);
            }
            this.myProject = project;
            this.myOutputDirectoryName = outputDirectoryName;
            this.myName = name;
            this.myFactory = factory;
            this.myFormat = format;
            this.myRootTagName = rootTagName;
        }

        void writeElement(@NotNull Element element) {
            if (element == null) {
                XmlWriterWrapper.$$$reportNull$$$0(6);
            }
            try {
                this.checkOpen();
                this.myXmlWriter.writeCharacters(this.myFormat.getLineSeparator() + this.myFormat.getIndent());
                this.myXmlWriter.flush();
                JbXmlOutputter.collapseMacrosAndWrite(element, (ComponentManager)this.myProject, this.myFileWriter);
                this.myFileWriter.flush();
            }
            catch (IOException | XMLStreamException e) {
                throw new XmlWriterWrapperException(e);
            }
        }

        void checkOpen() {
            if (this.myXmlWriter == null) {
                this.myFileWriter = XmlWriterWrapper.openFile(this.myOutputDirectoryName, this.myName);
                this.myXmlWriter = this.startWritingXml(this.myFileWriter);
            }
        }

        @Override
        public void close() {
            if (this.myXmlWriter != null) {
                try {
                    this.endWritingXml(this.myXmlWriter);
                }
                finally {
                    this.myXmlWriter = null;
                    try {
                        XmlWriterWrapper.closeFile(this.myFileWriter);
                    }
                    finally {
                        this.myFileWriter = null;
                    }
                }
            }
        }

        @NotNull
        private static Writer openFile(@NotNull String outputDirectoryName, @NotNull String name) {
            BufferedWriter bufferedWriter;
            if (outputDirectoryName == null) {
                XmlWriterWrapper.$$$reportNull$$$0(7);
            }
            if (name == null) {
                XmlWriterWrapper.$$$reportNull$$$0(8);
            }
            try {
                bufferedWriter = ExportHTMLAction.getWriter(outputDirectoryName, name);
            }
            catch (FileNotFoundException e) {
                throw new XmlWriterWrapperException(e);
            }
            if (bufferedWriter == null) {
                XmlWriterWrapper.$$$reportNull$$$0(9);
            }
            return bufferedWriter;
        }

        private static void closeFile(@NotNull Writer fileWriter) {
            if (fileWriter == null) {
                XmlWriterWrapper.$$$reportNull$$$0(10);
            }
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                throw new XmlWriterWrapperException(e);
            }
        }

        @NotNull
        private XMLStreamWriter startWritingXml(@NotNull Writer fileWriter) {
            XMLStreamWriter xMLStreamWriter;
            if (fileWriter == null) {
                XmlWriterWrapper.$$$reportNull$$$0(11);
            }
            try {
                XMLStreamWriter xmlWriter = this.myFactory.createXMLStreamWriter(fileWriter);
                xmlWriter.writeStartElement(this.myRootTagName);
                xMLStreamWriter = xmlWriter;
            }
            catch (XMLStreamException e) {
                throw new XmlWriterWrapperException(e);
            }
            if (xMLStreamWriter == null) {
                XmlWriterWrapper.$$$reportNull$$$0(12);
            }
            return xMLStreamWriter;
        }

        private void endWritingXml(@NotNull XMLStreamWriter xmlWriter) {
            if (xmlWriter == null) {
                XmlWriterWrapper.$$$reportNull$$$0(13);
            }
            try {
                try {
                    xmlWriter.writeCharacters(this.myFormat.getLineSeparator());
                    xmlWriter.writeEndElement();
                    xmlWriter.flush();
                }
                finally {
                    xmlWriter.close();
                }
            }
            catch (XMLStreamException e) {
                throw new XmlWriterWrapperException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputDirectoryName";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootTagName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ui/actions/ExportHTMLAction$XmlWriterWrapper";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileWriter";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlWriter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ui/actions/ExportHTMLAction$XmlWriterWrapper";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "openFile";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startWritingXml";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "writeElement";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "openFile";
                    break;
                }
                case 9: 
                case 12: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "closeFile";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "startWritingXml";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "endWritingXml";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

