/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ModuleProblemDescriptor;
import com.intellij.codeInspection.ModuleProblemDescriptorImpl;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.actions.RunInspectionAction;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflineDescriptorResolveResult {
    private static final Logger LOG = Logger.getInstance(OfflineDescriptorResolveResult.class);
    private final RefEntity myResolvedEntity;
    private final CommonProblemDescriptor myResolvedDescriptor;
    private volatile boolean myExcluded;

    private OfflineDescriptorResolveResult(RefEntity resolvedEntity, CommonProblemDescriptor resolvedDescriptor) {
        this.myResolvedEntity = resolvedEntity;
        this.myResolvedDescriptor = resolvedDescriptor;
    }

    @Nullable
    RefEntity getResolvedEntity() {
        return this.myResolvedEntity;
    }

    @Nullable
    CommonProblemDescriptor getResolvedDescriptor() {
        return this.myResolvedDescriptor;
    }

    public boolean isExcluded() {
        return this.myExcluded;
    }

    public void setExcluded(boolean excluded) {
        this.myExcluded = excluded;
    }

    @NotNull
    static OfflineDescriptorResolveResult resolve(@NotNull OfflineProblemDescriptor descriptor2, @NotNull InspectionToolWrapper wrapper2, @NotNull InspectionToolPresentation presentation) {
        if (descriptor2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(0);
        }
        if (wrapper2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(2);
        }
        RefEntity element = descriptor2.getRefElement(presentation.getContext().getRefManager());
        CommonProblemDescriptor resolvedDescriptor = (CommonProblemDescriptor)ReadAction.compute(() -> OfflineDescriptorResolveResult.createDescriptor(element, descriptor2, wrapper2, presentation));
        OfflineDescriptorResolveResult offlineDescriptorResolveResult = new OfflineDescriptorResolveResult(element, resolvedDescriptor);
        if (offlineDescriptorResolveResult == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(3);
        }
        return offlineDescriptorResolveResult;
    }

    @Nullable
    private static CommonProblemDescriptor createDescriptor(@Nullable RefEntity element, @NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        if (offlineDescriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(4);
        }
        if (toolWrapper == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(5);
        }
        if (presentation == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(6);
        }
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            CommonProblemDescriptor descriptor2;
            LocalInspectionToolWrapper localTool = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper();
            if (localTool != null && (descriptor2 = OfflineDescriptorResolveResult.createDescriptor(element, offlineDescriptor, localTool, presentation)) != null) {
                return descriptor2;
            }
            return OfflineDescriptorResolveResult.createRerunGlobalToolDescriptor((GlobalInspectionToolWrapper)toolWrapper, element, offlineDescriptor);
        }
        Project project = presentation.getContext().getProject();
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
        if (toolWrapper instanceof LocalInspectionToolWrapper && !(toolWrapper.getTool() instanceof UnfairLocalInspectionTool) && element instanceof RefElement) {
            ProblemDescriptor descriptor3;
            PsiElement psiElement = ((RefElement)element).getPsiElement();
            if (psiElement != null && (descriptor3 = (ProblemDescriptor)ProgressManager.getInstance().runProcess(() -> OfflineDescriptorResolveResult.runLocalTool(psiElement, offlineDescriptor, (LocalInspectionToolWrapper)toolWrapper, inspectionManager, presentation.getContext()), (ProgressIndicator)new DaemonProgressIndicator())) != null) {
                return descriptor3;
            }
            return null;
        }
        CommonProblemDescriptor descriptor4 = OfflineDescriptorResolveResult.createProblemDescriptorFromOfflineDescriptor(element, offlineDescriptor, QuickFix.EMPTY_ARRAY, project);
        QuickFix[] quickFixes = OfflineDescriptorResolveResult.getFixes(descriptor4, element, presentation, offlineDescriptor.getHints());
        if (quickFixes != null) {
            descriptor4 = OfflineDescriptorResolveResult.createProblemDescriptorFromOfflineDescriptor(element, offlineDescriptor, quickFixes, project);
        }
        return descriptor4;
    }

    @NotNull
    private static CommonProblemDescriptor createProblemDescriptorFromOfflineDescriptor(@Nullable RefEntity element, @NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull QuickFix[] fixes, @NotNull Project project) {
        if (offlineDescriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(7);
        }
        if (fixes == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(8);
        }
        if (project == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(9);
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
        if (element instanceof RefElement) {
            ProblemDescriptorBackedByRefElement problemDescriptorBackedByRefElement = new ProblemDescriptorBackedByRefElement((RefElement)element, offlineDescriptor, fixes);
            if (problemDescriptorBackedByRefElement == null) {
                OfflineDescriptorResolveResult.$$$reportNull$$$0(10);
            }
            return problemDescriptorBackedByRefElement;
        }
        if (element instanceof RefModule) {
            ModuleProblemDescriptor moduleProblemDescriptor = inspectionManager.createProblemDescriptor(offlineDescriptor.getDescription(), ((RefModule)element).getModule(), fixes);
            if (moduleProblemDescriptor == null) {
                OfflineDescriptorResolveResult.$$$reportNull$$$0(11);
            }
            return moduleProblemDescriptor;
        }
        CommonProblemDescriptor commonProblemDescriptor = inspectionManager.createProblemDescriptor(offlineDescriptor.getDescription(), fixes);
        if (commonProblemDescriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(12);
        }
        return commonProblemDescriptor;
    }

    private static ProblemDescriptor runLocalTool(@NotNull PsiElement psiElement, @NotNull OfflineProblemDescriptor offlineProblemDescriptor, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContextImpl context) {
        if (psiElement == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(13);
        }
        if (offlineProblemDescriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(14);
        }
        if (toolWrapper == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(15);
        }
        if (inspectionManager == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(16);
        }
        if (context == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(17);
        }
        PsiFile containingFile = psiElement.getContainingFile();
        ProblemsHolder holder = new ProblemsHolder(inspectionManager, containingFile, false);
        LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
        TextRange textRange = psiElement.getTextRange();
        LOG.assertTrue(textRange != null, (Object)("text range muse be not null here; isValid = " + psiElement.isValid() + ", isPhysical = " + psiElement.isPhysical() + ", containingFile = " + containingFile.getName() + ", inspection = " + toolWrapper.getShortName()));
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(containingFile, startOffset, endOffset);
        final PsiElementVisitor visitor = localTool.buildVisitor(holder, true, session2);
        localTool.inspectionStarted(session2, false);
        PsiElement[] elementsInRange = OfflineDescriptorResolveResult.getElementsIntersectingRange(containingFile, startOffset, endOffset);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)context.getProject());
        for (PsiElement element : elementsInRange) {
            List injectedPsiFiles = injectedLanguageManager.getInjectedPsiFiles(element);
            if (injectedPsiFiles != null) {
                for (Pair file2 : injectedPsiFiles) {
                    ((PsiElement)file2.getFirst()).accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(PsiElement element) {
                            element.accept(visitor);
                            super.visitElement(element);
                        }
                    });
                }
            }
            element.accept(visitor);
        }
        localTool.inspectionFinished(session2, holder);
        if (holder.hasResults()) {
            List list2 = holder.getResults();
            int idx = offlineProblemDescriptor.getProblemIndex();
            int curIdx = 0;
            for (ProblemDescriptor descriptor2 : list2) {
                PsiNamedElement member = BatchModeDescriptorsUtil.getContainerElement(descriptor2.getPsiElement(), localTool, context);
                if (!(psiElement instanceof PsiFile) && !psiElement.equals(member)) continue;
                if (curIdx == idx) {
                    return descriptor2;
                }
                ++curIdx;
            }
        }
        return null;
    }

    @NotNull
    private static PsiElement[] getElementsIntersectingRange(PsiFile file2, int startOffset, int endOffset) {
        FileViewProvider viewProvider = file2.getViewProvider();
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            result2.addAll(CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, startOffset, endOffset, true));
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(18);
        }
        return psiElementArray;
    }

    @Nullable
    private static QuickFix[] getFixes(@NotNull CommonProblemDescriptor descriptor2, RefEntity entity, InspectionToolPresentation presentation, List<String> hints) {
        if (descriptor2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(19);
        }
        ArrayList fixes = new ArrayList(hints == null ? 1 : hints.size());
        if (hints == null) {
            OfflineDescriptorResolveResult.addFix(descriptor2, entity, fixes, null, presentation);
        } else {
            for (String hint : hints) {
                OfflineDescriptorResolveResult.addFix(descriptor2, entity, fixes, hint, presentation);
            }
        }
        return fixes.isEmpty() ? null : fixes.toArray(QuickFix.EMPTY_ARRAY);
    }

    private static void addFix(@NotNull CommonProblemDescriptor descriptor2, RefEntity entity, List<? super QuickFix> fixes, String hint, InspectionToolPresentation presentation) {
        if (descriptor2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(20);
        }
        ContainerUtil.addAllNotNull(fixes, (Object[])new QuickFix[]{presentation.findQuickFixes(descriptor2, entity, hint)});
    }

    private static CommonProblemDescriptor createRerunGlobalToolDescriptor(final @NotNull GlobalInspectionToolWrapper wrapper2, final @Nullable RefEntity entity, OfflineProblemDescriptor offlineDescriptor) {
        if (wrapper2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(21);
        }
        QuickFix rerunFix = new QuickFix(){

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = "Rerun '" + wrapper2.getDisplayName() + "' inspection";
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor2) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                VirtualFile file2 = null;
                if (entity != null && entity.isValid() && entity instanceof RefElement) {
                    file2 = ((RefElement)entity).getPointer().getVirtualFile();
                }
                PsiFile psiFile = null;
                if (file2 != null) {
                    psiFile = PsiManager.getInstance((Project)project).findFile(file2);
                }
                RunInspectionAction.runInspection(project, wrapper2.getShortName(), file2, null, psiFile);
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        List hints = offlineDescriptor.getHints();
        if (hints != null && entity instanceof RefModule) {
            List<QuickFix> fixes = hints.stream().map(hint -> ((GlobalInspectionTool)wrapper2.getTool()).getQuickFix(hint)).filter(f -> f != null).collect(Collectors.toList());
            return new ModuleProblemDescriptorImpl((QuickFix[])ArrayUtil.append((Object[])fixes.toArray(QuickFix.EMPTY_ARRAY), (Object)rerunFix), offlineDescriptor.getDescription(), ((RefModule)entity).getModule());
        }
        return new CommonProblemDescriptorImpl(new QuickFix[]{rerunFix}, offlineDescriptor.getDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlineDescriptor";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlineProblemDescriptor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemDescriptorFromOfflineDescriptor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsIntersectingRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptorFromOfflineDescriptor";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runLocalTool";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addFix";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createRerunGlobalToolDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProblemDescriptorBackedByRefElement
    implements ProblemDescriptor {
        private final RefElement myElement;
        private final OfflineProblemDescriptor myOfflineProblemDescriptor;
        private final QuickFix[] myFixes;

        private ProblemDescriptorBackedByRefElement(RefElement element, OfflineProblemDescriptor descriptor2, QuickFix[] fixes) {
            this.myElement = element;
            this.myOfflineProblemDescriptor = descriptor2;
            this.myFixes = fixes;
        }

        public PsiElement getPsiElement() {
            return this.myElement.getPsiElement();
        }

        public PsiElement getStartElement() {
            return this.getPsiElement();
        }

        public PsiElement getEndElement() {
            return this.getPsiElement();
        }

        public TextRange getTextRangeInElement() {
            return null;
        }

        public int getLineNumber() {
            return 0;
        }

        @NotNull
        public ProblemHighlightType getHighlightType() {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (problemHighlightType == null) {
                ProblemDescriptorBackedByRefElement.$$$reportNull$$$0(0);
            }
            return problemHighlightType;
        }

        public boolean isAfterEndOfLine() {
            return false;
        }

        public void setTextAttributes(TextAttributesKey key) {
        }

        @Nullable
        public ProblemGroup getProblemGroup() {
            return null;
        }

        public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
        }

        public boolean showTooltip() {
            return false;
        }

        @NotNull
        public String getDescriptionTemplate() {
            String string = this.myOfflineProblemDescriptor.getDescription();
            if (string == null) {
                ProblemDescriptorBackedByRefElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public QuickFix[] getFixes() {
            return this.myFixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult$ProblemDescriptorBackedByRefElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptionTemplate";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

