/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.RangeSplitter;
import com.intellij.codeInsight.unwrap.UnwrapHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ScopeHighlighter {
    public static final NotNullFunction<PsiElement, TextRange> NATURAL_RANGER = dom -> dom.getTextRange();
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final List<RangeHighlighter> myActiveHighliters;
    @NotNull
    private final NotNullFunction<? super PsiElement, ? extends TextRange> myRanger;

    public ScopeHighlighter(@NotNull Editor editor) {
        if (editor == null) {
            ScopeHighlighter.$$$reportNull$$$0(0);
        }
        this(editor, NATURAL_RANGER);
    }

    public ScopeHighlighter(@NotNull Editor editor, @NotNull NotNullFunction<? super PsiElement, ? extends TextRange> ranger) {
        if (editor == null) {
            ScopeHighlighter.$$$reportNull$$$0(1);
        }
        if (ranger == null) {
            ScopeHighlighter.$$$reportNull$$$0(2);
        }
        this.myActiveHighliters = new ArrayList<RangeHighlighter>();
        this.myEditor = editor;
        this.myRanger = ranger;
    }

    public void highlight(@NotNull PsiElement wholeAffected, @NotNull List<? extends PsiElement> toExtract) {
        if (wholeAffected == null) {
            ScopeHighlighter.$$$reportNull$$$0(3);
        }
        if (toExtract == null) {
            ScopeHighlighter.$$$reportNull$$$0(4);
        }
        Pair<TextRange, List<TextRange>> ranges2 = this.collectTextRanges(wholeAffected, toExtract);
        this.highlight(ranges2);
    }

    public void highlight(@NotNull Pair<TextRange, List<TextRange>> ranges2) {
        if (ranges2 == null) {
            ScopeHighlighter.$$$reportNull$$$0(5);
        }
        this.dropHighlight();
        TextRange wholeRange = (TextRange)ranges2.first;
        List rangesToExtract = (List)ranges2.second;
        List<TextRange> rangesToRemove = RangeSplitter.split(wholeRange, rangesToExtract);
        for (TextRange r : rangesToRemove) {
            this.addHighlighter(r, 6001, ScopeHighlighter.getTestAttributesForRemoval());
        }
        for (TextRange r : rangesToExtract) {
            this.addHighlighter(r, 6001, UnwrapHandler.getTestAttributesForExtract());
        }
    }

    private Pair<TextRange, List<TextRange>> collectTextRanges(PsiElement wholeElement, List<? extends PsiElement> elementsToExtract) {
        TextRange affectedRange = this.getRange(wholeElement);
        ArrayList<TextRange> rangesToExtract = new ArrayList<TextRange>();
        for (PsiElement psiElement : elementsToExtract) {
            rangesToExtract.add(this.getRange(psiElement));
        }
        return Pair.create((Object)affectedRange, rangesToExtract);
    }

    private TextRange getRange(PsiElement e) {
        return (TextRange)this.myRanger.fun((Object)e);
    }

    private void addHighlighter(TextRange r, int level, TextAttributes attr) {
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(r.getStartOffset(), r.getEndOffset(), level, attr, HighlighterTargetArea.EXACT_RANGE);
        this.myActiveHighliters.add(highlighter);
    }

    public void dropHighlight() {
        for (RangeHighlighter h : this.myActiveHighliters) {
            h.dispose();
        }
        this.myActiveHighliters.clear();
    }

    private static TextAttributes getTestAttributesForRemoval() {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        return manager.getGlobalScheme().getAttributes(EditorColors.DELETED_TEXT_ATTRIBUTES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wholeAffected";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExtract";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/unwrap/ScopeHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "highlight";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

