/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import org.jetbrains.annotations.NotNull;

public class EscapeHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public EscapeHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    protected void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
        if (editor == null) {
            EscapeHandler.$$$reportNull$$$0(0);
        }
        if (editor.getCaretModel().getCaretCount() == 1) {
            HighlightManagerImpl highlightManager;
            editor.setHeaderComponent(null);
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project != null && (highlightManager = (HighlightManagerImpl)HighlightManager.getInstance((Project)project)) != null && highlightManager.hideHighlights(editor, 3)) {
                FindModel model2;
                FindManager findManager;
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                if (statusBar != null) {
                    statusBar.setInfo("");
                }
                if ((findManager = FindManager.getInstance((Project)project)) != null && (model2 = findManager.getFindNextModel(editor)) != null) {
                    model2.setSearchHighlighters(false);
                    findManager.setFindNextModel(model2);
                }
                return;
            }
        }
        this.myOriginalHandler.execute(editor, caret, dataContext);
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        HighlightManagerImpl highlightManager;
        if (editor == null) {
            EscapeHandler.$$$reportNull$$$0(1);
        }
        if (caret == null) {
            EscapeHandler.$$$reportNull$$$0(2);
        }
        if (editor.hasHeaderComponent()) {
            return true;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && (highlightManager = (HighlightManagerImpl)HighlightManager.getInstance((Project)project)) != null && highlightManager.hasHideByEscapeHighlighters(editor)) {
            return true;
        }
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/highlighting/EscapeHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

