/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.editorActions.emacs.EmacsProcessingHandler;
import com.intellij.codeInsight.editorActions.emacs.LanguageEmacsExtension;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.NotNull;

public class EmacsStyleIndentAction
extends BaseCodeInsightAction
implements DumbAware {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        Handler handler2 = new Handler();
        if (handler2 == null) {
            EmacsStyleIndentAction.$$$reportNull$$$0(0);
        }
        return handler2;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement context;
        if (project == null) {
            EmacsStyleIndentAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            EmacsStyleIndentAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            EmacsStyleIndentAction.$$$reportNull$$$0(3);
        }
        return (context = file2.findElementAt(editor.getCaretModel().getOffset())) != null && LanguageFormatting.INSTANCE.forContext(context) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Handler
    implements CodeInsightActionHandler {
        private Handler() {
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
            EmacsProcessingHandler.Result result2;
            EmacsProcessingHandler emacsProcessingHandler;
            if (project == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if ((emacsProcessingHandler = (EmacsProcessingHandler)LanguageEmacsExtension.INSTANCE.forLanguage(file2.getLanguage())) != null && (result2 = emacsProcessingHandler.changeIndent(project, editor, file2)) == EmacsProcessingHandler.Result.STOP) {
                return;
            }
            Document document = editor.getDocument();
            int startLine = document.getLineNumber(editor.getSelectionModel().getSelectionStart());
            int endLine = document.getLineNumber(editor.getSelectionModel().getSelectionEnd());
            for (int line2 = startLine; line2 <= endLine; ++line2) {
                int lineStart = document.getLineStartOffset(line2);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                int newPos = codeStyleManager.adjustLineIndent(file2, lineStart);
                if (startLine != endLine || editor.getCaretModel().getOffset() >= newPos) continue;
                editor.getCaretModel().moveToOffset(newPos);
                editor.getSelectionModel().removeSelection();
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction$Handler";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

