/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.actions.ShowErrorDescriptionAction;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInspection.ui.InspectionNodeInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DaemonTooltipRenderer
extends LineTooltipRenderer {
    @NonNls
    protected static final String END_MARKER = "<!-- end marker -->";

    DaemonTooltipRenderer(String text2, Object[] comparable) {
        super(text2, comparable);
    }

    DaemonTooltipRenderer(String text2, int width, Object[] comparable) {
        super(text2, width, comparable);
    }

    @Override
    protected void onHide(@NotNull JComponent contentComponent) {
        if (contentComponent == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(0);
        }
        ShowErrorDescriptionAction.rememberCurrentWidth(contentComponent.getWidth());
    }

    @Override
    @NotNull
    protected String dressDescription(@NotNull Editor editor, @NotNull String tooltipText, boolean expand) {
        if (editor == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(1);
        }
        if (tooltipText == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(2);
        }
        if (!expand) {
            String string = super.dressDescription(editor, tooltipText, false);
            if (string == null) {
                DaemonTooltipRenderer.$$$reportNull$$$0(3);
            }
            return string;
        }
        List<String> problems = this.getProblems(tooltipText);
        StringBuilder text2 = new StringBuilder();
        for (String problem : problems) {
            String ref = DaemonTooltipRenderer.getLinkRef(problem);
            if (ref != null) {
                String description = TooltipLinkHandlerEP.getDescription(ref, editor);
                if (description == null) continue;
                description = InspectionNodeInfo.stripUIRefsFromInspectionDescription(UIUtil.getHtmlBody((Html)new Html(description).setKeepFont(true)));
                text2.append(this.getHtmlForProblemWithLink(problem)).append(END_MARKER).append("<p>").append("<span style=\"color:").append(ColorUtil.toHex((Color)this.getDescriptionTitleColor())).append("\">Inspection info:</span>").append(description).append("<hr size=1 noshade>");
                continue;
            }
            text2.append(UIUtil.getHtmlBody((Html)new Html(problem).setKeepFont(true))).append("<hr size=1 noshade>");
        }
        if (text2.length() > 0) {
            String string = XmlStringUtil.wrapInHtml((CharSequence)StringUtil.trimEnd((String)text2.toString(), (String)"<hr size=1 noshade>"));
            if (string == null) {
                DaemonTooltipRenderer.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = super.dressDescription(editor, tooltipText, true);
        if (string == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected List<String> getProblems(@NotNull String tooltipText) {
        if (tooltipText == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(6);
        }
        List list2 = StringUtil.split((String)UIUtil.getHtmlBody((Html)new Html(tooltipText).setKeepFont(true)), (String)"<hr size=1 noshade>");
        if (list2 == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    protected String getHtmlForProblemWithLink(@NotNull String problem) {
        if (problem == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(8);
        }
        Html html = new Html(problem).setKeepFont(true);
        String string = UIUtil.getHtmlBody((Html)html).replace(DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]), DaemonBundle.message((String)"inspection.collapse.description", (Object[])new Object[0]));
        if (string == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    protected static String getLinkRef(@NonNls String text2) {
        String ref;
        int quoteIdx;
        String linkWithRef = "<a href=\"";
        int linkStartIdx = text2.indexOf("<a href=\"");
        if (linkStartIdx >= 0 && (quoteIdx = (ref = text2.substring(linkStartIdx + "<a href=\"".length())).indexOf(34)) > 0) {
            return ref.substring(0, quoteIdx);
        }
        return null;
    }

    @NotNull
    protected Color getDescriptionTitleColor() {
        JBColor jBColor = JBColor.namedColor((String)"ToolTip.infoForeground", (Color)new JBColor(0x919191, 0x919191));
        if (jBColor == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(10);
        }
        return jBColor;
    }

    @Override
    @NotNull
    protected LineTooltipRenderer createRenderer(@Nullable String text2, int width) {
        DaemonTooltipRenderer daemonTooltipRenderer = new DaemonTooltipRenderer(text2, width, this.getEqualityObjects());
        if (daemonTooltipRenderer == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(11);
        }
        return daemonTooltipRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRenderer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRenderer";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dressDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblems";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlForProblemWithLink";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionTitleColor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onHide";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dressDescription";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProblems";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlForProblemWithLink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

