/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CamelHumpMatcher
extends PrefixMatcher {
    private final MinusculeMatcher myMatcher;
    private final MinusculeMatcher myCaseInsensitiveMatcher;
    private final boolean myCaseSensitive;
    private static boolean ourForceStartMatching;
    private final boolean myTypoTolerant;

    public CamelHumpMatcher(@NotNull String prefix) {
        if (prefix == null) {
            CamelHumpMatcher.$$$reportNull$$$0(0);
        }
        this(prefix, true);
    }

    public CamelHumpMatcher(String prefix, boolean caseSensitive) {
        this(prefix, caseSensitive, false);
    }

    CamelHumpMatcher(String prefix, boolean caseSensitive, boolean typoTolerant) {
        super(prefix);
        this.myCaseSensitive = caseSensitive;
        this.myTypoTolerant = typoTolerant;
        this.myMatcher = this.createMatcher(this.myCaseSensitive);
        this.myCaseInsensitiveMatcher = this.createMatcher(false);
    }

    public boolean isStartMatch(String name) {
        return this.myMatcher.isStartMatch(name);
    }

    public boolean isStartMatch(LookupElement element) {
        for (String s : CompletionUtil.iterateLookupStrings(element)) {
            FList ranges2 = this.myCaseInsensitiveMatcher.matchingFragments(s);
            if (ranges2 == null || !ranges2.isEmpty() && CamelHumpMatcher.skipUnderscores(s) < ((TextRange)ranges2.get(0)).getStartOffset()) continue;
            return true;
        }
        return false;
    }

    boolean isTypoTolerant() {
        return this.myTypoTolerant;
    }

    private static int skipUnderscores(@NotNull String name) {
        if (name == null) {
            CamelHumpMatcher.$$$reportNull$$$0(1);
        }
        return CharArrayUtil.shiftForward((CharSequence)name, (int)0, (String)"_");
    }

    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            CamelHumpMatcher.$$$reportNull$$$0(2);
        }
        if (name.startsWith("_") && CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE == 3 && this.firstLetterCaseDiffers(name)) {
            return false;
        }
        return this.myMatcher.matches(name);
    }

    private boolean firstLetterCaseDiffers(String name) {
        int nameFirst = CamelHumpMatcher.skipUnderscores(name);
        int prefixFirst = CamelHumpMatcher.skipUnderscores(this.myPrefix);
        return nameFirst < name.length() && prefixFirst < this.myPrefix.length() && CamelHumpMatcher.caseDiffers(name.charAt(nameFirst), this.myPrefix.charAt(prefixFirst));
    }

    private static boolean caseDiffers(char c1, char c2) {
        return Character.isLowerCase(c1) != Character.isLowerCase(c2) || Character.isUpperCase(c1) != Character.isUpperCase(c2);
    }

    public boolean prefixMatches(@NotNull LookupElement element) {
        if (element == null) {
            CamelHumpMatcher.$$$reportNull$$$0(3);
        }
        return this.prefixMatchersInternal(element, !element.isCaseSensitive());
    }

    private boolean prefixMatchersInternal(LookupElement element, boolean itemCaseInsensitive) {
        for (String name : element.getAllLookupStrings()) {
            if (itemCaseInsensitive && StringUtil.startsWithIgnoreCase((String)name, (String)this.myPrefix) || this.prefixMatches(name)) {
                return true;
            }
            if (!itemCaseInsensitive || 1 == CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE || !this.myCaseInsensitiveMatcher.matches(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            CamelHumpMatcher.$$$reportNull$$$0(4);
        }
        if (prefix.equals(this.myPrefix)) {
            CamelHumpMatcher camelHumpMatcher = this;
            if (camelHumpMatcher == null) {
                CamelHumpMatcher.$$$reportNull$$$0(5);
            }
            return camelHumpMatcher;
        }
        CamelHumpMatcher camelHumpMatcher = new CamelHumpMatcher(prefix, this.myCaseSensitive, this.myTypoTolerant);
        if (camelHumpMatcher == null) {
            CamelHumpMatcher.$$$reportNull$$$0(6);
        }
        return camelHumpMatcher;
    }

    private MinusculeMatcher createMatcher(boolean caseSensitive) {
        String prefix = CamelHumpMatcher.applyMiddleMatching(this.myPrefix);
        NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher((String)prefix);
        if (caseSensitive) {
            int setting = CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE;
            if (setting == 3) {
                builder2 = builder2.withCaseSensitivity(NameUtil.MatchingCaseSensitivity.FIRST_LETTER);
            } else if (setting == 1) {
                builder2 = builder2.withCaseSensitivity(NameUtil.MatchingCaseSensitivity.ALL);
            }
        }
        if (this.myTypoTolerant) {
            builder2 = builder2.typoTolerant();
        }
        return builder2.build();
    }

    public static String applyMiddleMatching(String prefix) {
        if (Registry.is((String)"ide.completion.middle.matching") && !prefix.isEmpty() && !ourForceStartMatching) {
            return "*" + StringUtil.replace((String)prefix, (String)".", (String)". ").trim();
        }
        return prefix;
    }

    public String toString() {
        return this.myPrefix;
    }

    @Deprecated
    public static void forceStartMatching(Disposable parent) {
        ourForceStartMatching = true;
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                ourForceStartMatching = false;
            }
        });
    }

    public int matchingDegree(String string) {
        return this.matchingDegree(string, this.matchingFragments(string));
    }

    @Nullable
    public FList<TextRange> matchingFragments(String string) {
        return this.myMatcher.matchingFragments(string);
    }

    public int matchingDegree(String string, @Nullable FList<? extends TextRange> fragments) {
        int matchStart;
        FList ciRanges;
        int underscoreEnd = CamelHumpMatcher.skipUnderscores(string);
        if (underscoreEnd > 0 && (ciRanges = this.myCaseInsensitiveMatcher.matchingFragments(string)) != null && !ciRanges.isEmpty() && (matchStart = ((TextRange)ciRanges.get(0)).getStartOffset()) > 0 && matchStart <= underscoreEnd) {
            return this.myCaseInsensitiveMatcher.matchingDegree(string.substring(matchStart), true) - 1;
        }
        return this.myMatcher.matchingDegree(string, true, fragments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/CamelHumpMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/CamelHumpMatcher";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "skipUnderscores";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithPrefix";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

