/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.HtmlStyleManagerKt;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.BitUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0016J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0010J\u0016\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003J\u001c\u0010!\u001a\u00020\u00122\n\u0010\u0005\u001a\u00060\"j\u0002`#2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0016\u0010$\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u0010R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/codeEditor/printing/HtmlStyleManager;", "", "isInline", "", "(Z)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "()Z", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "separatorStyleMap", "Lgnu/trove/THashMap;", "Ljava/awt/Color;", "", "styleMap", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "ensureStyles", "", "hIterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "methodSeparators", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "getSeparatorClassName", "color", "isDefaultAttributes", "attributes", "writeStyleTag", "writer", "Ljava/io/Writer;", "isUseLineNumberStyle", "writeTextAttributes", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "writeTextStyle", "intellij.platform.lang.impl"})
public final class HtmlStyleManager {
    private final THashMap<TextAttributes, String> styleMap;
    private final THashMap<Color, String> separatorStyleMap;
    private final StringBuilder buffer;
    private final EditorColorsScheme scheme;
    private final boolean isInline;

    public final void ensureStyles(@NotNull HighlighterIterator hIterator, @NotNull List<? extends LineMarkerInfo<PsiElement>> methodSeparators) {
        Intrinsics.checkParameterIsNotNull((Object)hIterator, (String)"hIterator");
        Intrinsics.checkParameterIsNotNull(methodSeparators, (String)"methodSeparators");
        while (!hIterator.atEnd()) {
            TextAttributes textAttributes = hIterator.getTextAttributes();
            if (!this.styleMap.containsKey((Object)textAttributes)) {
                String styleName = "s" + this.styleMap.size();
                this.styleMap.put((Object)textAttributes, (Object)styleName);
                this.buffer.append('.' + styleName + " { ");
                Appendable appendable = this.buffer;
                TextAttributes textAttributes2 = textAttributes;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes2, (String)"textAttributes");
                this.writeTextAttributes(appendable, textAttributes2);
                this.buffer.append("}\n");
            }
            hIterator.advance();
        }
        for (LineMarkerInfo<PsiElement> lineMarkerInfo : methodSeparators) {
            Color color = lineMarkerInfo.separatorColor;
            if (color == null || this.separatorStyleMap.containsKey((Object)color)) continue;
            String styleName = "ls" + this.separatorStyleMap.size();
            this.separatorStyleMap.put((Object)color, (Object)styleName);
            String htmlColor = HtmlStyleManagerKt.colorToHtml(color);
            this.buffer.append('.' + styleName + " { height: 1px; border-width: 0; color: " + htmlColor + "; background-color:" + htmlColor + "}\n");
        }
    }

    private final void writeTextAttributes(Appendable buffer, TextAttributes attributes) {
        Color color = attributes.getForegroundColor();
        if (color == null) {
            Color color2 = this.scheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"scheme.defaultForeground");
        }
        Color foreColor = color;
        buffer.append("color: " + HtmlStyleManagerKt.colorToHtml(foreColor) + ';');
        if (BitUtil.isSet((int)attributes.getFontType(), (int)1)) {
            buffer.append(" font-weight: bold;");
        }
        if (BitUtil.isSet((int)attributes.getFontType(), (int)2)) {
            buffer.append(" font-style: italic;");
        }
    }

    public final void writeStyleTag(@NotNull Writer writer, boolean isUseLineNumberStyle) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        writer.write("<style type=\"text/css\">\n");
        if (isUseLineNumberStyle) {
            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
            EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
            EditorColorsScheme scheme = editorColorsScheme;
            Color lineNumbers = scheme.getColor(EditorColors.LINE_NUMBERS_COLOR);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = ".ln { color: #%s; font-weight: normal; font-style: normal; }\n";
            Object[] objectArray = new Object[1];
            Color color = lineNumbers;
            if (color == null) {
                color = (Color)Gray.x00;
            }
            objectArray[0] = ColorUtil.toHex((Color)color);
            Object[] objectArray2 = objectArray;
            StringBuilder stringBuilder = this.buffer;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            stringBuilder.append(string3);
        }
        writer.append(this.buffer);
        writer.write("</style>\n");
    }

    public final boolean isDefaultAttributes(@NotNull TextAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Color color = attributes.getForegroundColor();
        if (color == null) {
            Color color2 = this.scheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"scheme.defaultForeground");
        }
        return color.equals(Color.BLACK) && attributes.getFontType() == 0;
    }

    public final void writeTextStyle(@NotNull Writer writer, @NotNull TextAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        writer.write("<span ");
        if (this.isInline) {
            writer.write("style=\"");
            this.writeTextAttributes(writer, attributes);
            writer.write("\">");
        } else {
            writer.write("class=\"");
            Object object = this.styleMap.get((Object)attributes);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            writer.write((String)object);
            writer.write("\">");
        }
    }

    @NotNull
    public final String getSeparatorClassName(@NotNull Color color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Object object = this.separatorStyleMap.get((Object)color);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (String)object;
    }

    public final boolean isInline() {
        return this.isInline;
    }

    public HtmlStyleManager(boolean isInline) {
        this.isInline = isInline;
        this.styleMap = new THashMap();
        this.separatorStyleMap = new THashMap();
        this.buffer = new StringBuilder();
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        this.scheme = editorColorsScheme;
    }
}

