/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bootRuntime.command;

import com.intellij.bootRuntime.BinTrayUtil;
import com.intellij.bootRuntime.Controller;
import com.intellij.bootRuntime.bundles.Runtime;
import com.intellij.bootRuntime.command.RuntimeCommand;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.HttpRequests;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

public class Download
extends RuntimeCommand {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.bootRuntime.command.Download");

    public Download(Project project, Controller controller, Runtime runtime) {
        super(project, controller, "Download", runtime);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File downloadDirectoryFile = this.myRuntime.getDownloadPath();
        if (!BinTrayUtil.downloadPath().exists()) {
            BinTrayUtil.downloadPath().mkdir();
        }
        if (!downloadDirectoryFile.exists()) {
            String link2 = "https://bintray.com/jetbrains/intellij-jdk/download_file?file_path=" + this.getRuntime().getFileName();
            this.runWithProgress("Downloading...", progressIndicator -> {
                progressIndicator.setIndeterminate(true);
                try {
                    HttpRequests.request((String)link2).saveToFile(downloadDirectoryFile, progressIndicator);
                }
                catch (IOException ioe) {
                    LOG.warn((Throwable)ioe);
                }
            });
        }
    }
}

