/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bootRuntime;

import com.intellij.bootRuntime.OperationSystem;
import com.intellij.bootRuntime.RuntimeBundleFactoryKt;
import com.intellij.bootRuntime.RuntimeLocationsFactory;
import com.intellij.bootRuntime.RuntimeLocationsFactory$WhenMappings;
import com.intellij.bootRuntime.bundles.Local;
import com.intellij.bootRuntime.bundles.Remote;
import com.intellij.bootRuntime.bundles.Runtime;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004\u00a8\u0006\u0015"}, d2={"Lcom/intellij/bootRuntime/RuntimeLocationsFactory;", "", "()V", "bintrayBundles", "", "Lcom/intellij/bootRuntime/bundles/Runtime;", "project", "Lcom/intellij/openapi/project/Project;", "bundlesFromLocations", "locations", "Ljava/io/File;", "collectRuntimes", "", "link", "", "bundleNamePattern", "localBundles", "operationSystem", "Lcom/intellij/bootRuntime/OperationSystem;", "runtimeLocations", "runtimesFrom", "intellij.platform.lang.impl"})
public final class RuntimeLocationsFactory {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> runtimesFrom(@NotNull List<? extends File> locations) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(locations, (String)"locations");
        Iterable $this$flatMap$iv = locations;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File l = (File)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)l, null, (int)1, null)), (Function1)runtimesFrom.1.1.INSTANCE), (Function1)runtimesFrom.1.2.INSTANCE));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final List<File> runtimeLocations(@NotNull OperationSystem operationSystem) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)operationSystem), (String)"operationSystem");
        switch (RuntimeLocationsFactory$WhenMappings.$EnumSwitchMapping$0[operationSystem.ordinal()]) {
            case 1: 
            case 2: {
                list2 = CollectionsKt.plus((Collection)RuntimeBundleFactoryKt.access$getWINDOWS_X86_JVM_LOCATION$p(), (Iterable)RuntimeBundleFactoryKt.access$getWINDOWS_X64_JVM_LOCATION$p());
                break;
            }
            case 3: {
                list2 = RuntimeBundleFactoryKt.access$getLINUX_JVM_LOCATIONS$p();
                break;
            }
            case 4: {
                list2 = RuntimeBundleFactoryKt.access$getMAC_OS_JVM_LOCATIONS$p();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Runtime> bundlesFromLocations(@NotNull Project project, @NotNull List<? extends File> locations) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(locations, (String)"locations");
        Iterable $this$map$iv = locations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void location;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Local local = new Local(project, (File)location);
            collection.add(local);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final OperationSystem operationSystem() {
        return SystemInfo.is64Bit && SystemInfo.isWindows ? OperationSystem.Windows64 : (SystemInfo.is32Bit && SystemInfo.isWindows ? OperationSystem.Windows32 : (SystemInfo.isMac ? OperationSystem.MacOSX : OperationSystem.Linux));
    }

    @NotNull
    public final List<Runtime> localBundles(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.bundlesFromLocations(project, this.runtimesFrom(this.runtimeLocations(this.operationSystem())));
    }

    @NotNull
    public final List<Runtime> bintrayBundles(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String subject = "jetbrains";
        String repoName = "intellij-jdk";
        String jbrRepoName = "intellij-jbr";
        String linkTemplate = "https://dl.bintray.com/%s/%s";
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = new Object[]{subject, repoName};
        Object object = this;
        boolean bl = false;
        String string = String.format(linkTemplate, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
        Object object2 = string;
        List<Runtime> runtimes = ((RuntimeLocationsFactory)object).collectRuntimes((String)object2, project, ".*\"(jbsdk.*%s.*?)\"");
        stringCompanionObject = StringCompanionObject.INSTANCE;
        objectArray = new Object[]{subject, jbrRepoName};
        object2 = this;
        object = runtimes;
        bl = false;
        String string2 = String.format(linkTemplate, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        object.addAll((Collection)super.collectRuntimes(string3, project, ".*\".*?(jbrsdk.*%s.*?)\""));
        return runtimes;
    }

    private final List<Runtime> collectRuntimes(String link2, Project project, String bundleNamePattern) {
        URL uRL = new URL(link2);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object[] objectArray = TextStreamsKt.readBytes((URL)uRL);
        boolean bl2 = false;
        boolean bl3 = false;
        String response = new String((byte[])objectArray, charset);
        String osFilter = "";
        if (SystemInfo.isMac) {
            osFilter = "osx";
        } else if (SystemInfo.isLinux) {
            osFilter = "linux";
        } else if (SystemInfo.isWindows) {
            osFilter = "win";
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        objectArray = new Object[]{osFilter};
        bl2 = false;
        String string = String.format(bundleNamePattern, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
        Pattern r = Pattern.compile(string);
        Matcher m = r.matcher(response);
        bl2 = false;
        List list2 = new ArrayList();
        while (m.find()) {
            String string2 = m.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"m.group(1)");
            list2.add(new Remote(project, string2));
        }
        return list2;
    }
}

