/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class ShSemanticEditorPosition {
    private final HighlighterIterator myIterator;

    private ShSemanticEditorPosition(@NotNull EditorEx editor, int offset) {
        if (editor == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(0);
        }
        this.myIterator = editor.getHighlighter().createIterator(offset);
    }

    void moveBefore() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.retreat();
        }
    }

    void moveBeforeOptionalMix(IElementType ... elements) {
        if (elements == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(1);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.retreat();
        }
    }

    void moveAfterOptionalMix(IElementType ... elements) {
        if (elements == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(2);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.advance();
        }
    }

    boolean isAtAnyOf(IElementType ... syntaxElements) {
        if (syntaxElements == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(3);
        }
        if (!this.myIterator.atEnd()) {
            IElementType currElement = this.myIterator.getTokenType();
            for (IElementType element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isAt(@NotNull IElementType elementType) {
        if (elementType == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(4);
        }
        return !this.myIterator.atEnd() && this.myIterator.getTokenType() == elementType;
    }

    int getStartOffset() {
        return !this.myIterator.atEnd() ? this.myIterator.getStart() : -1;
    }

    @NotNull
    static ShSemanticEditorPosition createEditorPosition(@NotNull EditorEx editor, int offset) {
        if (editor == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(5);
        }
        ShSemanticEditorPosition shSemanticEditorPosition = new ShSemanticEditorPosition(editor, offset);
        if (shSemanticEditorPosition == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(6);
        }
        return shSemanticEditorPosition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/formatter/ShSemanticEditorPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/formatter/ShSemanticEditorPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "moveBeforeOptionalMix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moveAfterOptionalMix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAtAnyOf";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAt";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditorPosition";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

