/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.UnknownMacroException;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a>\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012H\u0082\b\u001a&\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000e2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u001aD\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00162\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0010\b\u0002\u0010#\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0006\u001a\b\u0010$\u001a\u00020\u0016H\u0000\u001a\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0016H\u0002\u001a \u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000bH\u0002\u00a8\u0006."}, d2={"exportInstalledPlugins", "", "zipOut", "Ljava/util/zip/ZipOutputStream;", "exportSettings", "exportFiles", "", "Ljava/nio/file/Path;", "out", "Ljava/io/OutputStream;", "configPath", "", "getAdditionalExportFile", "stateAnnotation", "Lcom/intellij/openapi/components/State;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "isSkipFile", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "file", "", "getComponentPresentableName", "state", "aClass", "Ljava/lang/Class;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getExportableComponentsMap", "", "", "Lcom/intellij/configurationStore/ExportableItem;", "isOnlyExisting", "isComputePresentableNames", "onlyPaths", "isImportExportActionApplicable", "isStorageExportable", "storage", "Lcom/intellij/openapi/components/Storage;", "isRoamable", "messageOrDefault", "classLoader", "Ljava/lang/ClassLoader;", "bundleName", "defaultName", "intellij.platform.configurationStore.impl"})
public final class ExportSettingsActionKt {
    public static final boolean isImportExportActionApplicable() {
        Application app;
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
        StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager();
        if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
            stateStorageManager = null;
        }
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        if (stateStorageManagerImpl == null) {
            return true;
        }
        StateStorageManagerImpl storageManager2 = stateStorageManagerImpl;
        return !storageManager2.isStreamProviderPreventExportAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportSettings(@NotNull Set<? extends Path> exportFiles, @NotNull OutputStream out, @NotNull String configPath) {
        Intrinsics.checkParameterIsNotNull(exportFiles, (String)"exportFiles");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        Closeable closeable = new ZipOutputStream(out);
        boolean bl = false;
        Throwable throwable = null;
        try {
            ZipOutputStream zipOut = (ZipOutputStream)closeable;
            boolean bl2 = false;
            THashSet writtenItemRelativePaths = new THashSet();
            for (Path path : exportFiles) {
                BasicFileAttributes fileInfo;
                String relativePath;
                if (PathKt.basicAttributesIfExists((Path)path) == null) {
                    continue;
                }
                Path path2 = path.toAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file.toAbsolutePath()");
                if (FileUtilRt.getRelativePath((String)configPath, (String)PathKt.getSystemIndependentPath((Path)path2), (char)'/') == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)relativePath, (String)"FileUtilRt.getRelativePa\u2026emIndependentPath, '/')!!");
                if (fileInfo.isDirectory()) {
                    ZipUtil.addDirToZipRecursively((ZipOutputStream)zipOut, null, (File)path.toFile(), (String)relativePath, null, (Set)((Set)writtenItemRelativePaths));
                    continue;
                }
                ZipUtil.addFileToZip((ZipOutputStream)zipOut, (File)path.toFile(), (String)relativePath, (Set)((Set)writtenItemRelativePaths), null, (ZipUtil.FileContentProcessor)new ZipUtil.FileContentProcessor(path){
                    final /* synthetic */ Path $file;

                    @NotNull
                    public final InputStream getContent(@NotNull File it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return PathKt.inputStream((Path)this.$file);
                    }
                    {
                        this.$file = path;
                    }
                }, (boolean)false);
            }
            ExportSettingsActionKt.exportInstalledPlugins(zipOut);
            zipOut.putNextEntry(new ZipEntry("IntelliJ IDEA Global Settings"));
            zipOut.closeEntry();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void exportInstalledPlugins(@NotNull ZipOutputStream zipOut) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)zipOut, (String)"zipOut");
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptorArray, (String)"PluginManagerCore.getPlugins()");
        IdeaPluginDescriptor[] $this$mapNotNull$iv = ideaPluginDescriptorArray;
        boolean $i$f$mapNotNull = false;
        IdeaPluginDescriptor[] ideaPluginDescriptorArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_9 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_9).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var9_9[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (!v1.isBundled() && it.isEnabled()) {
                PluginId pluginId = it.getPluginId();
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"it.pluginId");
                string = pluginId.getIdString();
            } else {
                string = null;
            }
            if (string == null) continue;
            String string2 = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List plugins = (List)destination$iv$iv;
        if (!plugins.isEmpty()) {
            zipOut.putNextEntry(new ZipEntry("installed.txt"));
            try {
                PluginManagerCore.writePluginsList((Collection)plugins, (Writer)new OutputStreamWriter((OutputStream)zipOut, Charsets.UTF_8));
            }
            finally {
                zipOut.closeEntry();
            }
        }
    }

    @NotNull
    public static final Map<Path, List<ExportableItem>> getExportableComponentsMap(boolean isOnlyExisting, boolean isComputePresentableNames, @NotNull StateStorageManager storageManager2, @Nullable Set<String> onlyPaths) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
        LinkedHashMap result = new LinkedHashMap();
        Function1 processor2 = (Function1)new Function1<ExportableComponent, Unit>(result){
            final /* synthetic */ LinkedHashMap $result;

            public final void invoke(@NotNull ExportableComponent component) {
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                for (File file : component.getExportFiles()) {
                    Path path = file.toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file.toPath()");
                    String string = component.getPresentableName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"component.presentableName");
                    ExportableItem item = new ExportableItem(path, string, RoamingType.DEFAULT);
                    UtilKt.putValue((Map)this.$result, (Object)item.getFile(), (Object)item);
                }
            }
            {
                this.$result = linkedHashMap;
                super(1);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ApplicationImpl app = (ApplicationImpl)application;
        Object[] objectArray = app.getComponents(ExportableApplicationComponent.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"app.getComponents(Export\u2026ionComponent::class.java)");
        Object $this$forEach$iv = objectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            processor2.invoke(element$iv);
        }
        List list = ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ServiceBean.loadServices\u2026bleComponent::class.java)");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            processor2.invoke(element$iv);
        }
        String configPath = storageManager2.expandMacros("$ROOT_CONFIG$");
        Function1<Path, Boolean> $fun$isSkipFile$1 = new Function1<Path, Boolean>(onlyPaths, configPath, isOnlyExisting){
            final /* synthetic */ Set $onlyPaths;
            final /* synthetic */ String $configPath;
            final /* synthetic */ boolean $isOnlyExisting;

            public final boolean invoke(@NotNull Path file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                if (this.$onlyPaths != null) {
                    String string = FileUtilRt.getRelativePath((String)this.$configPath, (String)PathKt.getSystemIndependentPath((Path)file), (char)'/');
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtilRt.getRelativePa\u2026emIndependentPath, '/')!!");
                    String relativePath = string;
                    if (!StringsKt.contains$default((CharSequence)((Object)file.getFileName()).toString(), (char)'.', (boolean)false, (int)2, null) && !PathKt.isFile((Path)file)) {
                        relativePath = relativePath + '/';
                    }
                    if (!this.$onlyPaths.contains(relativePath)) {
                        return true;
                    }
                }
                return this.$isOnlyExisting && !PathKt.exists((Path)file);
            }
            {
                this.$onlyPaths = set;
                this.$configPath = string;
                this.$isOnlyExisting = bl;
                super(1);
            }
        };
        if (isOnlyExisting || onlyPaths != null) {
            Set set = result.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"result.keys");
            CollectionsKt.removeAll((Iterable)set, (Function1)((Function1)new Function1<Path, Boolean>($fun$isSkipFile$1){
                final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;

                public final boolean invoke(@NotNull Path p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return this.$isSkipFile$1.invoke(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return null;
                }

                public final String getName() {
                    return "isSkipFile";
                }

                public final String getSignature() {
                    return "invoke(Ljava/nio/file/Path;)Z";
                }
                {
                    this.$isSkipFile$1 = var1_1;
                    super(1);
                }
            }));
        }
        THashMap fileToContent = new THashMap();
        ServiceManagerImpl.processAllImplementationClasses((ComponentManager)((ComponentManager)app), (BiPredicate)new BiPredicate<Class<?>, PluginDescriptor>(storageManager2, $fun$isSkipFile$1, isComputePresentableNames, isOnlyExisting, fileToContent, result){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;
            final /* synthetic */ boolean $isComputePresentableNames;
            final /* synthetic */ boolean $isOnlyExisting;
            final /* synthetic */ THashMap $fileToContent;
            final /* synthetic */ LinkedHashMap $result;

            public final boolean test(Class<?> aClass, PluginDescriptor pluginDescriptor) {
                boolean isFileIncluded;
                boolean isRoamable;
                State stateAnnotation;
                block17: {
                    block16: {
                        Class<?> clazz = aClass;
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"aClass");
                        stateAnnotation = StoreUtilKt.getStateSpec(clazz);
                        if (stateAnnotation == null) break block16;
                        CharSequence charSequence = stateAnnotation.name();
                        boolean bl = false;
                        if (!(charSequence.length() == 0) && !ExportableComponent.class.isAssignableFrom(aClass)) break block17;
                    }
                    return true;
                }
                Storage storage2 = (Storage)CollectionsKt.firstOrNull(ComponentStoreImplKt.sortByDeprecated(stateAnnotation.storages()));
                if (storage2 == null) {
                    return true;
                }
                Storage storage3 = storage2;
                boolean bl = isRoamable = StateStorageManagerImplKt.getEffectiveRoamingType(storage3.roamingType(), StateStorageManagerImplKt.getPath(storage3)) != RoamingType.DISABLED;
                if (!ExportSettingsActionKt.access$isStorageExportable(storage3, isRoamable)) {
                    return true;
                }
                Path additionalExportFile = null;
                Path file = null;
                try {
                    Path path;
                    StateStorageManager storageManager$iv = this.$storageManager;
                    boolean $i$f$getAdditionalExportFile = false;
                    String additionalExportPath$iv = stateAnnotation.additionalExportFile();
                    CharSequence charSequence = additionalExportPath$iv;
                    boolean bl2 = false;
                    if (!(charSequence.length() > 0)) {
                        path = null;
                    } else {
                        Path additionalExportFile$iv = null;
                        additionalExportFile$iv = additionalExportPath$iv.charAt(0) == '$' ? Paths.get(storageManager$iv.expandMacros(additionalExportPath$iv), new String[0]) : Paths.get(storageManager$iv.expandMacros("$ROOT_CONFIG$"), additionalExportPath$iv);
                        Path path2 = additionalExportFile$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"additionalExportFile");
                        Path p1 = path2;
                        boolean bl3 = false;
                        path = this.$isSkipFile$1.invoke(p1) ? null : additionalExportFile$iv;
                    }
                    additionalExportFile = path;
                    Path path3 = Paths.get(this.$storageManager.expandMacros(StateStorageManagerImplKt.getPath(storage3)), new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(storageManager\u2026pandMacros(storage.path))");
                    file = path3;
                }
                catch (UnknownMacroException e) {
                    ComponentStoreImplKt.getLOG().error("Cannot expand macro for component \"" + stateAnnotation.name() + '\"', (Throwable)e);
                    return true;
                }
                boolean bl4 = isFileIncluded = !this.$isSkipFile$1.invoke(file);
                if (isFileIncluded || additionalExportFile != null) {
                    String presentableName;
                    if (this.$isComputePresentableNames && this.$isOnlyExisting && additionalExportFile == null && StringsKt.endsWith$default((String)((Object)file.getFileName()).toString(), (String)".xml", (boolean)false, (int)2, null)) {
                        String content;
                        Object object;
                        Map $this$getOrPut$iv = (Map)this.$fileToContent;
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(file);
                        if (value$iv == null) {
                            boolean bl5 = false;
                            String answer$iv = PathKt.readText((Path)file);
                            $this$getOrPut$iv.put(file, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        String string = content = (String)object;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"content");
                        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)("<component name=\"" + stateAnnotation.name() + '\"'), (boolean)false, (int)2, null)) {
                            return true;
                        }
                    }
                    String string = presentableName = this.$isComputePresentableNames ? ExportSettingsActionKt.access$getComponentPresentableName(stateAnnotation, aClass, pluginDescriptor) : "";
                    if (isFileIncluded) {
                        UtilKt.putValue((Map)this.$result, (Object)file, (Object)new ExportableItem(file, presentableName, storage3.roamingType()));
                    }
                    if (additionalExportFile != null) {
                        UtilKt.putValue((Map)this.$result, (Object)additionalExportFile, (Object)new ExportableItem(additionalExportFile, presentableName + " (schemes)", RoamingType.DEFAULT));
                    }
                }
                return true;
            }
            {
                this.$storageManager = stateStorageManager;
                this.$isSkipFile$1 = var2_2;
                this.$isComputePresentableNames = bl;
                this.$isOnlyExisting = bl2;
                this.$fileToContent = tHashMap;
                this.$result = linkedHashMap;
            }
        });
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        if (schemeManagerFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        }
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1<? super SchemeManagerImpl<Scheme, Scheme>, Unit>)((Function1)new Function1<SchemeManagerImpl<Scheme, Scheme>, Unit>(storageManager2, result, $fun$isSkipFile$1){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ LinkedHashMap $result;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;

            public final void invoke(@NotNull SchemeManagerImpl<Scheme, Scheme> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                if (it.getRoamingType() != RoamingType.DISABLED) {
                    Path file;
                    Character c = StringsKt.getOrNull((CharSequence)it.getFileSpec(), (int)0);
                    if (!(c != null && c.charValue() == '$' || this.$result.containsKey(file = Paths.get(this.$storageManager.expandMacros("$ROOT_CONFIG$"), it.getFileSpec())))) {
                        Path path = file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                        if (!this.$isSkipFile$1.invoke(path)) {
                            Map map = this.$result;
                            String string = it.getPresentableName();
                            if (string == null) {
                                string = "";
                            }
                            UtilKt.putValue((Map)map, (Object)file, (Object)new ExportableItem(file, string, it.getRoamingType()));
                        }
                    }
                }
            }
            {
                this.$storageManager = stateStorageManager;
                this.$result = linkedHashMap;
                this.$isSkipFile$1 = var3_3;
                super(1);
            }
        }));
        return result;
    }

    public static /* synthetic */ Map getExportableComponentsMap$default(boolean bl, boolean bl2, StateStorageManager stateStorageManager, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager();
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return ExportSettingsActionKt.getExportableComponentsMap(bl, bl2, stateStorageManager, set);
    }

    private static final Path getAdditionalExportFile(State stateAnnotation, StateStorageManager storageManager2, Function1<? super Path, Boolean> isSkipFile) {
        int $i$f$getAdditionalExportFile = 0;
        String additionalExportPath = stateAnnotation.additionalExportFile();
        CharSequence charSequence = additionalExportPath;
        boolean bl = false;
        if (!(charSequence.length() > 0)) {
            return null;
        }
        Path additionalExportFile = null;
        additionalExportFile = additionalExportPath.charAt(0) == '$' ? Paths.get(storageManager2.expandMacros(additionalExportPath), new String[0]) : Paths.get(storageManager2.expandMacros("$ROOT_CONFIG$"), additionalExportPath);
        Path path = additionalExportFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"additionalExportFile");
        return (Boolean)isSkipFile.invoke((Object)path) != false ? null : additionalExportFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isStorageExportable(Storage storage2, boolean isRoamable) {
        if (storage2.exportable()) {
            return true;
        }
        if (!isRoamable) return false;
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass((Class)storage2.storageClass()), (Object)Reflection.getOrCreateKotlinClass(StateStorage.class))) return false;
        CharSequence charSequence = StateStorageManagerImplKt.getPath(storage2);
        boolean bl = false;
        if (charSequence.length() != 0) return true;
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getComponentPresentableName(State state, Class<?> aClass, PluginDescriptor pluginDescriptor) {
        presentableName = state.presentableName();
        if (Intrinsics.areEqual((Object)presentableName, State.NameGetter.class) ^ true) {
            try {
                v0 = ((State.NameGetter)ReflectionUtil.newInstance((Class)presentableName)).get();
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"ReflectionUtil.newInstance(presentableName).get()");
                return (String)v0;
            }
            catch (Exception e) {
                ComponentStoreImplKt.getLOG().error((Throwable)e);
            }
        }
        defaultName = state.name();
        $fun$trimDefaultName$1 = new Function0<String>(defaultName){
            final /* synthetic */ String $defaultName;

            @NotNull
            public final String invoke() {
                return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)this.$defaultName, (CharSequence)".Settings"), (CharSequence)".Settings");
            }
            {
                this.$defaultName = string;
                super(0);
            }
        };
        resourceBundleName = null;
        if (!(pluginDescriptor instanceof IdeaPluginDescriptor)) ** GOTO lbl-1000
        v1 = ((IdeaPluginDescriptor)pluginDescriptor).getPluginId();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"pluginDescriptor.pluginId");
        if (Intrinsics.areEqual((Object)"com.intellij", (Object)v1.getIdString()) ^ true) {
            resourceBundleName = ((IdeaPluginDescriptor)pluginDescriptor).getResourceBundleBaseName();
            if (resourceBundleName == null) {
                if (!Intrinsics.areEqual((Object)((IdeaPluginDescriptor)pluginDescriptor).getVendor(), (Object)"JetBrains")) return $fun$trimDefaultName$1.invoke();
                resourceBundleName = "messages.OptionsBundle";
            }
        } else lbl-1000:
        // 2 sources

        {
            resourceBundleName = "messages.OptionsBundle";
        }
        if ((v2 /* !! */  = pluginDescriptor) == null || (v2 /* !! */  = v2 /* !! */ .getPluginClassLoader()) == null) {
            v2 /* !! */  = classLoader /* !! */  = aClass.getClassLoader();
        }
        if (classLoader /* !! */  == null) return $fun$trimDefaultName$1.invoke();
        message = ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader /* !! */ , resourceBundleName, defaultName);
        if (message != defaultName) {
            return message;
        }
        if (!PlatformUtils.isRubyMine()) return $fun$trimDefaultName$1.invoke();
        return ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader /* !! */ , "org.jetbrains.plugins.ruby.RBundle", defaultName);
    }

    private static final String messageOrDefault(ClassLoader classLoader, String bundleName, String defaultName) {
        ResourceBundle resourceBundle = AbstractBundle.getResourceBundle((String)bundleName, (ClassLoader)classLoader);
        if (resourceBundle == null) {
            return defaultName;
        }
        ResourceBundle bundle = resourceBundle;
        String string = CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)("exportable." + defaultName + ".presentable.name"), (String)defaultName, (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CommonBundle.messageOrDe\u2026table.name\", defaultName)");
        return string;
    }

    public static final /* synthetic */ boolean access$isStorageExportable(Storage storage2, boolean isRoamable) {
        return ExportSettingsActionKt.isStorageExportable(storage2, isRoamable);
    }

    public static final /* synthetic */ Path access$getAdditionalExportFile(State stateAnnotation, StateStorageManager storageManager2, Function1 isSkipFile) {
        return ExportSettingsActionKt.getAdditionalExportFile(stateAnnotation, storageManager2, (Function1<? super Path, Boolean>)isSkipFile);
    }

    public static final /* synthetic */ String access$getComponentPresentableName(State state, Class aClass, PluginDescriptor pluginDescriptor) {
        return ExportSettingsActionKt.getComponentPresentableName(state, aClass, pluginDescriptor);
    }
}

